/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.set;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.iterators.AbstractIteratorDecorator;
import org.apache.commons.collections.list.UnmodifiableList;
import org.apache.commons.collections.set.AbstractSerializableSetDecorator;

public class ListOrderedSet
extends AbstractSerializableSetDecorator
implements Set {
    private static final long serialVersionUID = -228664372470420141L;
    protected final List setOrder;

    public static ListOrderedSet decorate(Set set, List list) {
        if (set == null) {
            throw new IllegalArgumentException("Set must not be null");
        }
        if (list == null) {
            throw new IllegalArgumentException("List must not be null");
        }
        if (set.size() > 0 || list.size() > 0) {
            throw new IllegalArgumentException("Set and List must be empty");
        }
        return new ListOrderedSet(set, list);
    }

    public static ListOrderedSet decorate(Set set) {
        return new ListOrderedSet(set);
    }

    public static ListOrderedSet decorate(List list) {
        if (list == null) {
            throw new IllegalArgumentException("List must not be null");
        }
        HashSet hashSet = new HashSet(list);
        list.retainAll(hashSet);
        return new ListOrderedSet(hashSet, list);
    }

    public ListOrderedSet() {
        super(new HashSet());
        this.setOrder = new ArrayList();
    }

    protected ListOrderedSet(Set set) {
        super(set);
        this.setOrder = new ArrayList(set);
    }

    protected ListOrderedSet(Set set, List list) {
        super(set);
        if (list == null) {
            throw new IllegalArgumentException("List must not be null");
        }
        this.setOrder = list;
    }

    public List asList() {
        return UnmodifiableList.decorate(this.setOrder);
    }

    public void clear() {
        this.collection.clear();
        this.setOrder.clear();
    }

    public Iterator iterator() {
        return new OrderedSetIterator(this.setOrder.iterator(), this.collection, null);
    }

    public boolean add(Object object) {
        if (this.collection.contains(object)) {
            return this.collection.add(object);
        }
        boolean bl = this.collection.add(object);
        this.setOrder.add(object);
        return bl;
    }

    public boolean addAll(Collection coll) {
        boolean bl = false;
        Iterator iterator = coll.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            bl |= this.add(e2);
        }
        return bl;
    }

    public boolean remove(Object object) {
        boolean bl = this.collection.remove(object);
        this.setOrder.remove(object);
        return bl;
    }

    public boolean removeAll(Collection coll) {
        boolean bl = false;
        Iterator iterator = coll.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            bl |= this.remove(e2);
        }
        return bl;
    }

    public boolean retainAll(Collection coll) {
        boolean bl = this.collection.retainAll(coll);
        if (!bl) {
            return false;
        }
        if (this.collection.size() == 0) {
            this.setOrder.clear();
        } else {
            Iterator iterator = this.setOrder.iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                if (this.collection.contains(e2)) continue;
                iterator.remove();
            }
        }
        return bl;
    }

    public Object[] toArray() {
        return this.setOrder.toArray();
    }

    public Object[] toArray(Object[] a2) {
        return this.setOrder.toArray(a2);
    }

    public Object get(int index) {
        return this.setOrder.get(index);
    }

    public int indexOf(Object object) {
        return this.setOrder.indexOf(object);
    }

    public void add(int index, Object object) {
        if (!this.contains(object)) {
            this.collection.add(object);
            this.setOrder.add(index, object);
        }
    }

    public boolean addAll(int index, Collection coll) {
        boolean bl = false;
        Iterator iterator = coll.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (this.contains(e2)) continue;
            this.collection.add(e2);
            this.setOrder.add(index, e2);
            ++index;
            bl = true;
        }
        return bl;
    }

    public Object remove(int index) {
        Object e2 = this.setOrder.remove(index);
        this.remove(e2);
        return e2;
    }

    public String toString() {
        return this.setOrder.toString();
    }

    static class 1 {
    }

    static class OrderedSetIterator
    extends AbstractIteratorDecorator {
        protected final Collection set;
        protected Object last;

        private OrderedSetIterator(Iterator iterator, Collection set) {
            super(iterator);
            this.set = set;
        }

        public Object next() {
            this.last = this.iterator.next();
            return this.last;
        }

        public void remove() {
            this.set.remove(this.last);
            this.iterator.remove();
            this.last = null;
        }

        OrderedSetIterator(Iterator x0, Collection x1, 1 x2) {
            this(x0, x1);
        }
    }
}

