/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import org.apache.commons.lang3.CharSet;
import org.apache.commons.lang3.StringUtils;

public class CharSetUtils {
    public static String squeeze(String str, String ... set) {
        if (StringUtils.isEmpty(str) || CharSetUtils.deepEmpty(set)) {
            return str;
        }
        CharSet charSet = CharSet.getInstance(set);
        StringBuilder stringBuilder = new StringBuilder(str.length());
        char[] cArray = str.toCharArray();
        int n2 = cArray.length;
        char c2 = cArray[0];
        Character c3 = null;
        Character c4 = null;
        stringBuilder.append(c2);
        for (int i2 = 1; i2 < n2; ++i2) {
            char c5 = cArray[i2];
            if (c5 == c2) {
                if (c3 != null && c5 == c3.charValue()) continue;
                if (c4 == null || c5 != c4.charValue()) {
                    if (charSet.contains(c5)) {
                        c3 = Character.valueOf(c5);
                        continue;
                    }
                    c4 = Character.valueOf(c5);
                }
            }
            stringBuilder.append(c5);
            c2 = c5;
        }
        return stringBuilder.toString();
    }

    public static boolean containsAny(String str, String ... set) {
        if (StringUtils.isEmpty(str) || CharSetUtils.deepEmpty(set)) {
            return false;
        }
        CharSet charSet = CharSet.getInstance(set);
        for (char c2 : str.toCharArray()) {
            if (!charSet.contains(c2)) continue;
            return true;
        }
        return false;
    }

    public static int count(String str, String ... set) {
        if (StringUtils.isEmpty(str) || CharSetUtils.deepEmpty(set)) {
            return 0;
        }
        CharSet charSet = CharSet.getInstance(set);
        int n2 = 0;
        for (char c2 : str.toCharArray()) {
            if (!charSet.contains(c2)) continue;
            ++n2;
        }
        return n2;
    }

    public static String keep(String str, String ... set) {
        if (str == null) {
            return null;
        }
        if (str.isEmpty() || CharSetUtils.deepEmpty(set)) {
            return "";
        }
        return CharSetUtils.modify(str, set, true);
    }

    public static String delete(String str, String ... set) {
        if (StringUtils.isEmpty(str) || CharSetUtils.deepEmpty(set)) {
            return str;
        }
        return CharSetUtils.modify(str, set, false);
    }

    private static String modify(String str, String[] set, boolean expect) {
        char[] cArray;
        CharSet charSet = CharSet.getInstance(set);
        StringBuilder stringBuilder = new StringBuilder(str.length());
        char[] cArray2 = cArray = str.toCharArray();
        int n2 = cArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = cArray2[i2];
            if (charSet.contains(c2) != expect) continue;
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    private static boolean deepEmpty(String[] strings) {
        if (strings != null) {
            String[] stringArray = strings;
            int n2 = strings.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = stringArray[i2];
                if (!StringUtils.isNotEmpty(string)) continue;
                return false;
            }
        }
        return true;
    }
}

