/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.Builder;
import org.apache.commons.lang3.builder.HashCodeExclude;
import org.apache.commons.lang3.builder.IDKey;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

public class HashCodeBuilder
implements Builder<Integer> {
    private static final int DEFAULT_INITIAL_VALUE = 17;
    private static final int DEFAULT_MULTIPLIER_VALUE = 37;
    private static final ThreadLocal<Set<IDKey>> REGISTRY = new ThreadLocal();
    private final int iConstant;
    private int iTotal = 0;

    static Set<IDKey> getRegistry() {
        return REGISTRY.get();
    }

    static boolean isRegistered(Object value) {
        Set<IDKey> set = HashCodeBuilder.getRegistry();
        return set != null && set.contains(new IDKey(value));
    }

    private static void reflectionAppend(Object object, Class<?> clazz, HashCodeBuilder builder, boolean useTransients, String[] excludeFields) {
        if (HashCodeBuilder.isRegistered(object)) {
            return;
        }
        try {
            HashCodeBuilder.register(object);
            AccessibleObject[] accessibleObjectArray = clazz.getDeclaredFields();
            AccessibleObject.setAccessible(accessibleObjectArray, true);
            AccessibleObject[] accessibleObjectArray2 = accessibleObjectArray;
            int n2 = accessibleObjectArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                AccessibleObject accessibleObject = accessibleObjectArray2[i2];
                if (ArrayUtils.contains(excludeFields, ((Field)accessibleObject).getName()) || ((Field)accessibleObject).getName().contains("$") || !useTransients && Modifier.isTransient(((Field)accessibleObject).getModifiers()) || Modifier.isStatic(((Field)accessibleObject).getModifiers()) || accessibleObject.isAnnotationPresent(HashCodeExclude.class)) continue;
                try {
                    Object object2 = ((Field)accessibleObject).get(object);
                    builder.append(object2);
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new InternalError("Unexpected IllegalAccessException");
                }
            }
            return;
        }
        finally {
            HashCodeBuilder.unregister(object);
        }
    }

    public static int reflectionHashCode(int initialNonZeroOddNumber, int multiplierNonZeroOddNumber, Object object) {
        return HashCodeBuilder.reflectionHashCode(initialNonZeroOddNumber, multiplierNonZeroOddNumber, object, false, null, new String[0]);
    }

    public static int reflectionHashCode(int initialNonZeroOddNumber, int multiplierNonZeroOddNumber, Object object, boolean testTransients) {
        return HashCodeBuilder.reflectionHashCode(initialNonZeroOddNumber, multiplierNonZeroOddNumber, object, testTransients, null, new String[0]);
    }

    public static <T> int reflectionHashCode(int initialNonZeroOddNumber, int multiplierNonZeroOddNumber, T object, boolean testTransients, Class<? super T> reflectUpToClass, String ... excludeFields) {
        Class<?> clazz;
        Validate.isTrue(object != null, "The object to build a hash code for must not be null", new Object[0]);
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder(initialNonZeroOddNumber, multiplierNonZeroOddNumber);
        HashCodeBuilder.reflectionAppend(object, clazz, hashCodeBuilder, testTransients, excludeFields);
        for (clazz = object.getClass(); clazz.getSuperclass() != null && clazz != reflectUpToClass; clazz = clazz.getSuperclass()) {
            HashCodeBuilder.reflectionAppend(object, clazz, hashCodeBuilder, testTransients, excludeFields);
        }
        return hashCodeBuilder.toHashCode();
    }

    public static int reflectionHashCode(Object object, boolean testTransients) {
        return HashCodeBuilder.reflectionHashCode(17, 37, object, testTransients, null, new String[0]);
    }

    public static int reflectionHashCode(Object object, Collection<String> excludeFields) {
        return HashCodeBuilder.reflectionHashCode(object, ReflectionToStringBuilder.toNoNullStringArray(excludeFields));
    }

    public static int reflectionHashCode(Object object, String ... excludeFields) {
        return HashCodeBuilder.reflectionHashCode(17, 37, object, false, null, excludeFields);
    }

    private static void register(Object value) {
        Set<IDKey> set = HashCodeBuilder.getRegistry();
        if (set == null) {
            set = new HashSet<IDKey>();
            REGISTRY.set(set);
        }
        set.add(new IDKey(value));
    }

    private static void unregister(Object value) {
        Set<IDKey> set = HashCodeBuilder.getRegistry();
        if (set != null) {
            set.remove(new IDKey(value));
            if (set.isEmpty()) {
                REGISTRY.remove();
            }
        }
    }

    public HashCodeBuilder() {
        this.iConstant = 37;
        this.iTotal = 17;
    }

    public HashCodeBuilder(int initialOddNumber, int multiplierOddNumber) {
        Validate.isTrue(initialOddNumber % 2 != 0, "HashCodeBuilder requires an odd initial value", new Object[0]);
        Validate.isTrue(multiplierOddNumber % 2 != 0, "HashCodeBuilder requires an odd multiplier", new Object[0]);
        this.iConstant = multiplierOddNumber;
        this.iTotal = initialOddNumber;
    }

    public HashCodeBuilder append(boolean value) {
        this.iTotal = this.iTotal * this.iConstant + (value ? 0 : 1);
        return this;
    }

    public HashCodeBuilder append(boolean[] array) {
        if (array == null) {
            this.iTotal *= this.iConstant;
        } else {
            boolean[] blArray = array;
            int n2 = array.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                boolean bl = blArray[i2];
                this.append(bl);
            }
        }
        return this;
    }

    public HashCodeBuilder append(byte value) {
        this.iTotal = this.iTotal * this.iConstant + value;
        return this;
    }

    public HashCodeBuilder append(byte[] array) {
        if (array == null) {
            this.iTotal *= this.iConstant;
        } else {
            byte[] byArray = array;
            int n2 = array.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                byte by = byArray[i2];
                this.append(by);
            }
        }
        return this;
    }

    public HashCodeBuilder append(char value) {
        this.iTotal = this.iTotal * this.iConstant + value;
        return this;
    }

    public HashCodeBuilder append(char[] array) {
        if (array == null) {
            this.iTotal *= this.iConstant;
        } else {
            char[] cArray = array;
            int n2 = array.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                char c2 = cArray[i2];
                this.append(c2);
            }
        }
        return this;
    }

    public HashCodeBuilder append(double value) {
        return this.append(Double.doubleToLongBits(value));
    }

    public HashCodeBuilder append(double[] array) {
        if (array == null) {
            this.iTotal *= this.iConstant;
        } else {
            double[] dArray = array;
            int n2 = array.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                double d2 = dArray[i2];
                this.append(d2);
            }
        }
        return this;
    }

    public HashCodeBuilder append(float value) {
        this.iTotal = this.iTotal * this.iConstant + Float.floatToIntBits(value);
        return this;
    }

    public HashCodeBuilder append(float[] array) {
        if (array == null) {
            this.iTotal *= this.iConstant;
        } else {
            float[] fArray = array;
            int n2 = array.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                float f2 = fArray[i2];
                this.append(f2);
            }
        }
        return this;
    }

    public HashCodeBuilder append(int value) {
        this.iTotal = this.iTotal * this.iConstant + value;
        return this;
    }

    public HashCodeBuilder append(int[] array) {
        if (array == null) {
            this.iTotal *= this.iConstant;
        } else {
            int[] nArray = array;
            int n2 = array.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = nArray[i2];
                this.append(n3);
            }
        }
        return this;
    }

    public HashCodeBuilder append(long value) {
        long l2 = value;
        this.iTotal = this.iTotal * this.iConstant + (int)(l2 ^ l2 >> 32);
        return this;
    }

    public HashCodeBuilder append(long[] array) {
        if (array == null) {
            this.iTotal *= this.iConstant;
        } else {
            long[] lArray = array;
            int n2 = array.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                long l2 = lArray[i2];
                this.append(l2);
            }
        }
        return this;
    }

    public HashCodeBuilder append(Object object) {
        if (object == null) {
            this.iTotal *= this.iConstant;
        } else if (object.getClass().isArray()) {
            this.appendArray(object);
        } else {
            this.iTotal = this.iTotal * this.iConstant + object.hashCode();
        }
        return this;
    }

    private void appendArray(Object object) {
        if (object instanceof long[]) {
            this.append((long[])object);
            return;
        }
        if (object instanceof int[]) {
            this.append((int[])object);
            return;
        }
        if (object instanceof short[]) {
            this.append((short[])object);
            return;
        }
        if (object instanceof char[]) {
            this.append((char[])object);
            return;
        }
        if (object instanceof byte[]) {
            this.append((byte[])object);
            return;
        }
        if (object instanceof double[]) {
            this.append((double[])object);
            return;
        }
        if (object instanceof float[]) {
            this.append((float[])object);
            return;
        }
        if (object instanceof boolean[]) {
            this.append((boolean[])object);
            return;
        }
        this.append((Object[])object);
    }

    public HashCodeBuilder append(Object[] array) {
        if (array == null) {
            this.iTotal *= this.iConstant;
        } else {
            Object[] objectArray = array;
            int n2 = array.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object = objectArray[i2];
                this.append(object);
            }
        }
        return this;
    }

    public HashCodeBuilder append(short value) {
        this.iTotal = this.iTotal * this.iConstant + value;
        return this;
    }

    public HashCodeBuilder append(short[] array) {
        if (array == null) {
            this.iTotal *= this.iConstant;
        } else {
            short[] sArray = array;
            int n2 = array.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                short s2 = sArray[i2];
                this.append(s2);
            }
        }
        return this;
    }

    public HashCodeBuilder appendSuper(int superHashCode) {
        this.iTotal = this.iTotal * this.iConstant + superHashCode;
        return this;
    }

    public int toHashCode() {
        return this.iTotal;
    }

    @Override
    public Integer build() {
        return this.toHashCode();
    }

    public int hashCode() {
        return this.toHashCode();
    }
}

