/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.math;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.Validate;

public class NumberUtils {
    public static final Long LONG_ZERO = 0L;
    public static final Long LONG_ONE = 1L;
    public static final Long LONG_MINUS_ONE = -1L;
    public static final Integer INTEGER_ZERO = 0;
    public static final Integer INTEGER_ONE = 1;
    public static final Integer INTEGER_MINUS_ONE = -1;
    public static final Short SHORT_ZERO = 0;
    public static final Short SHORT_ONE = 1;
    public static final Short SHORT_MINUS_ONE = -1;
    public static final Byte BYTE_ZERO = 0;
    public static final Byte BYTE_ONE = 1;
    public static final Byte BYTE_MINUS_ONE = -1;
    public static final Double DOUBLE_ZERO = 0.0;
    public static final Double DOUBLE_ONE = 1.0;
    public static final Double DOUBLE_MINUS_ONE = -1.0;
    public static final Float FLOAT_ZERO = Float.valueOf(0.0f);
    public static final Float FLOAT_ONE = Float.valueOf(1.0f);
    public static final Float FLOAT_MINUS_ONE = Float.valueOf(-1.0f);

    public static int toInt(String str) {
        return NumberUtils.toInt(str, 0);
    }

    public static int toInt(String str, int defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public static long toLong(String str) {
        return NumberUtils.toLong(str, 0L);
    }

    public static long toLong(String str, long defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public static float toFloat(String str) {
        return NumberUtils.toFloat(str, 0.0f);
    }

    public static float toFloat(String str, float defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(str);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public static double toDouble(String str) {
        return NumberUtils.toDouble(str, 0.0);
    }

    public static double toDouble(String str, double defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(str);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public static byte toByte(String str) {
        return NumberUtils.toByte(str, (byte)0);
    }

    public static byte toByte(String str, byte defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Byte.parseByte(str);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public static short toShort(String str) {
        return NumberUtils.toShort(str, (short)0);
    }

    public static short toShort(String str, short defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Short.parseShort(str);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public static Number createNumber(String str) throws NumberFormatException {
        String string;
        String string2;
        String string3;
        if (str == null) {
            return null;
        }
        if (StringUtils.isBlank(str)) {
            throw new NumberFormatException("A blank string is not a valid number");
        }
        String[] stringArray = new String[]{"0x", "0X", "-0x", "-0X", "#", "-#"};
        int n2 = 0;
        String[] stringArray2 = stringArray;
        for (int i2 = 0; i2 < 6; ++i2) {
            string3 = stringArray2[i2];
            if (!str.startsWith(string3)) continue;
            n2 = 0 + string3.length();
            break;
        }
        if (n2 > 0) {
            int n3;
            char c2 = '\u0000';
            for (n3 = n2; n3 < str.length() && (c2 = str.charAt(n3)) == '0'; ++n3) {
                ++n2;
            }
            n3 = str.length() - n2;
            if (n3 > 16 || n3 == 16 && c2 > '7') {
                return NumberUtils.createBigInteger(str);
            }
            if (n3 > 8 || n3 == 8 && c2 > '7') {
                return NumberUtils.createLong(str);
            }
            return NumberUtils.createInteger(str);
        }
        String string4 = str;
        char c3 = string4.charAt(string4.length() - 1);
        int n4 = str.indexOf(46);
        int n5 = str.indexOf(101) + str.indexOf(69) + 1;
        if (n4 >= 0) {
            if (n5 >= 0) {
                if (n5 < n4 || n5 > str.length()) {
                    throw new NumberFormatException(str + " is not a valid number.");
                }
                string2 = str.substring(n4 + 1, n5);
            } else {
                string2 = str.substring(n4 + 1);
            }
            string = NumberUtils.getMantissa(str, n4);
        } else {
            if (n5 >= 0) {
                if (n5 > str.length()) {
                    throw new NumberFormatException(str + " is not a valid number.");
                }
                string = NumberUtils.getMantissa(str, n5);
            } else {
                string = NumberUtils.getMantissa(str);
            }
            string2 = null;
        }
        if (!Character.isDigit(c3) && c3 != '.') {
            string3 = n5 >= 0 && n5 < str.length() - 1 ? str.substring(n5 + 1, str.length() - 1) : null;
            String string5 = str.substring(0, str.length() - 1);
            boolean bl = NumberUtils.isAllZeros(string) && NumberUtils.isAllZeros(string3);
            switch (c3) {
                case 'L': 
                case 'l': {
                    if (string2 == null && string3 == null && (string5.charAt(0) == '-' && NumberUtils.isDigits(string5.substring(1)) || NumberUtils.isDigits(string5))) {
                        try {
                            return NumberUtils.createLong(string5);
                        }
                        catch (NumberFormatException numberFormatException) {
                            return NumberUtils.createBigInteger(string5);
                        }
                    }
                    throw new NumberFormatException(str + " is not a valid number.");
                }
                case 'F': 
                case 'f': {
                    Number number;
                    try {
                        number = NumberUtils.createFloat(str);
                        if (!((Float)number).isInfinite() && (((Float)number).floatValue() != 0.0f || bl)) {
                            return number;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                case 'D': 
                case 'd': {
                    Number number;
                    try {
                        number = NumberUtils.createDouble(str);
                        if (!((Double)number).isInfinite() && ((double)((Double)number).floatValue() != 0.0 || bl)) {
                            return number;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                    try {
                        return NumberUtils.createBigDecimal(string5);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            throw new NumberFormatException(str + " is not a valid number.");
        }
        string3 = n5 >= 0 && n5 < str.length() - 1 ? str.substring(n5 + 1, str.length()) : null;
        if (string2 == null && string3 == null) {
            try {
                return NumberUtils.createInteger(str);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    return NumberUtils.createLong(str);
                }
                catch (NumberFormatException numberFormatException2) {
                    return NumberUtils.createBigInteger(str);
                }
            }
        }
        boolean bl = NumberUtils.isAllZeros(string) && NumberUtils.isAllZeros(string3);
        try {
            Float f2 = NumberUtils.createFloat(str);
            Double d2 = NumberUtils.createDouble(str);
            if (!f2.isInfinite() && (f2.floatValue() != 0.0f || bl) && f2.toString().equals(d2.toString())) {
                return f2;
            }
            if (!d2.isInfinite() && (d2 != 0.0 || bl)) {
                BigDecimal bigDecimal = NumberUtils.createBigDecimal(str);
                if (bigDecimal.compareTo(BigDecimal.valueOf(d2)) == 0) {
                    return d2;
                }
                return bigDecimal;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return NumberUtils.createBigDecimal(str);
    }

    private static String getMantissa(String str) {
        String string = str;
        return NumberUtils.getMantissa(string, string.length());
    }

    private static String getMantissa(String str, int stopPos) {
        char c2 = str.charAt(0);
        boolean bl = c2 == '-' || c2 == '+';
        if (bl) {
            return str.substring(1, stopPos);
        }
        return str.substring(0, stopPos);
    }

    private static boolean isAllZeros(String str) {
        if (str == null) {
            return true;
        }
        for (int i2 = str.length() - 1; i2 >= 0; --i2) {
            if (str.charAt(i2) == '0') continue;
            return false;
        }
        return str.length() > 0;
    }

    public static Float createFloat(String str) {
        if (str == null) {
            return null;
        }
        return Float.valueOf(str);
    }

    public static Double createDouble(String str) {
        if (str == null) {
            return null;
        }
        return Double.valueOf(str);
    }

    public static Integer createInteger(String str) {
        if (str == null) {
            return null;
        }
        return Integer.decode(str);
    }

    public static Long createLong(String str) {
        if (str == null) {
            return null;
        }
        return Long.decode(str);
    }

    public static BigInteger createBigInteger(String str) {
        if (str == null) {
            return null;
        }
        int n2 = 0;
        int n3 = 10;
        boolean bl = false;
        if (str.startsWith("-")) {
            bl = true;
            n2 = 1;
        }
        if (str.startsWith("0x", n2) || str.startsWith("0X", n2)) {
            n3 = 16;
            n2 += 2;
        } else if (str.startsWith("#", n2)) {
            n3 = 16;
            ++n2;
        } else if (str.startsWith("0", n2) && str.length() > n2 + 1) {
            n3 = 8;
            ++n2;
        }
        BigInteger bigInteger = new BigInteger(str.substring(n2), n3);
        if (bl) {
            return bigInteger.negate();
        }
        return bigInteger;
    }

    public static BigDecimal createBigDecimal(String str) {
        if (str == null) {
            return null;
        }
        if (StringUtils.isBlank(str)) {
            throw new NumberFormatException("A blank string is not a valid number");
        }
        if (str.trim().startsWith("--")) {
            throw new NumberFormatException(str + " is not a valid number.");
        }
        return new BigDecimal(str);
    }

    public static long min(long ... array) {
        NumberUtils.validateArray(array);
        long l2 = array[0];
        for (int i2 = 1; i2 < array.length; ++i2) {
            if (array[i2] >= l2) continue;
            l2 = array[i2];
        }
        return l2;
    }

    public static int min(int ... array) {
        NumberUtils.validateArray(array);
        int n2 = array[0];
        for (int i2 = 1; i2 < array.length; ++i2) {
            if (array[i2] >= n2) continue;
            n2 = array[i2];
        }
        return n2;
    }

    public static short min(short ... array) {
        NumberUtils.validateArray(array);
        short s2 = array[0];
        for (int i2 = 1; i2 < array.length; ++i2) {
            if (array[i2] >= s2) continue;
            s2 = array[i2];
        }
        return s2;
    }

    public static byte min(byte ... array) {
        NumberUtils.validateArray(array);
        byte by = array[0];
        for (int i2 = 1; i2 < array.length; ++i2) {
            if (array[i2] >= by) continue;
            by = array[i2];
        }
        return by;
    }

    public static double min(double ... array) {
        NumberUtils.validateArray(array);
        double d2 = array[0];
        for (int i2 = 1; i2 < array.length; ++i2) {
            if (Double.isNaN(array[i2])) {
                return Double.NaN;
            }
            if (!(array[i2] < d2)) continue;
            d2 = array[i2];
        }
        return d2;
    }

    public static float min(float ... array) {
        NumberUtils.validateArray(array);
        float f2 = array[0];
        for (int i2 = 1; i2 < array.length; ++i2) {
            if (Float.isNaN(array[i2])) {
                return Float.NaN;
            }
            if (!(array[i2] < f2)) continue;
            f2 = array[i2];
        }
        return f2;
    }

    public static long max(long ... array) {
        NumberUtils.validateArray(array);
        long l2 = array[0];
        for (int i2 = 1; i2 < array.length; ++i2) {
            if (array[i2] <= l2) continue;
            l2 = array[i2];
        }
        return l2;
    }

    public static int max(int ... array) {
        NumberUtils.validateArray(array);
        int n2 = array[0];
        for (int i2 = 1; i2 < array.length; ++i2) {
            if (array[i2] <= n2) continue;
            n2 = array[i2];
        }
        return n2;
    }

    public static short max(short ... array) {
        NumberUtils.validateArray(array);
        short s2 = array[0];
        for (int i2 = 1; i2 < array.length; ++i2) {
            if (array[i2] <= s2) continue;
            s2 = array[i2];
        }
        return s2;
    }

    public static byte max(byte ... array) {
        NumberUtils.validateArray(array);
        byte by = array[0];
        for (int i2 = 1; i2 < array.length; ++i2) {
            if (array[i2] <= by) continue;
            by = array[i2];
        }
        return by;
    }

    public static double max(double ... array) {
        NumberUtils.validateArray(array);
        double d2 = array[0];
        for (int i2 = 1; i2 < array.length; ++i2) {
            if (Double.isNaN(array[i2])) {
                return Double.NaN;
            }
            if (!(array[i2] > d2)) continue;
            d2 = array[i2];
        }
        return d2;
    }

    public static float max(float ... array) {
        NumberUtils.validateArray(array);
        float f2 = array[0];
        for (int i2 = 1; i2 < array.length; ++i2) {
            if (Float.isNaN(array[i2])) {
                return Float.NaN;
            }
            if (!(array[i2] > f2)) continue;
            f2 = array[i2];
        }
        return f2;
    }

    private static void validateArray(Object array) {
        Validate.isTrue(array != null, "The Array must not be null", new Object[0]);
        Validate.isTrue(Array.getLength(array) != 0, "Array cannot be empty.", new Object[0]);
    }

    public static long min(long a2, long b2, long c2) {
        if (b2 < a2) {
            a2 = b2;
        }
        if (c2 < a2) {
            a2 = c2;
        }
        return a2;
    }

    public static int min(int a2, int b2, int c2) {
        if (b2 < a2) {
            a2 = b2;
        }
        if (c2 < a2) {
            a2 = c2;
        }
        return a2;
    }

    public static short min(short a2, short b2, short c2) {
        if (b2 < a2) {
            a2 = b2;
        }
        if (c2 < a2) {
            a2 = c2;
        }
        return a2;
    }

    public static byte min(byte a2, byte b2, byte c2) {
        if (b2 < a2) {
            a2 = b2;
        }
        if (c2 < a2) {
            a2 = c2;
        }
        return a2;
    }

    public static double min(double a2, double b2, double c2) {
        return Math.min(Math.min(a2, b2), c2);
    }

    public static float min(float a2, float b2, float c2) {
        return Math.min(Math.min(a2, b2), c2);
    }

    public static long max(long a2, long b2, long c2) {
        if (b2 > a2) {
            a2 = b2;
        }
        if (c2 > a2) {
            a2 = c2;
        }
        return a2;
    }

    public static int max(int a2, int b2, int c2) {
        if (b2 > a2) {
            a2 = b2;
        }
        if (c2 > a2) {
            a2 = c2;
        }
        return a2;
    }

    public static short max(short a2, short b2, short c2) {
        if (b2 > a2) {
            a2 = b2;
        }
        if (c2 > a2) {
            a2 = c2;
        }
        return a2;
    }

    public static byte max(byte a2, byte b2, byte c2) {
        if (b2 > a2) {
            a2 = b2;
        }
        if (c2 > a2) {
            a2 = c2;
        }
        return a2;
    }

    public static double max(double a2, double b2, double c2) {
        return Math.max(Math.max(a2, b2), c2);
    }

    public static float max(float a2, float b2, float c2) {
        return Math.max(Math.max(a2, b2), c2);
    }

    public static boolean isDigits(String str) {
        return StringUtils.isNumeric(str);
    }

    @Deprecated
    public static boolean isNumber(String str) {
        return NumberUtils.isCreatable(str);
    }

    public static boolean isCreatable(String str) {
        int n2;
        boolean bl;
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        char[] cArray = str.toCharArray();
        int n3 = cArray.length;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n4 = cArray[0] == '-' || cArray[0] == '+' ? 1 : 0;
        boolean bl6 = bl = n4 == 1 && cArray[0] == '+';
        if (n3 > n4 + 1 && cArray[n4] == '0') {
            if (cArray[n4 + 1] == 'x' || cArray[n4 + 1] == 'X') {
                int n5 = n4 + 2;
                if (n5 == n3) {
                    return false;
                }
                while (n5 < cArray.length) {
                    if (!(cArray[n5] >= '0' && cArray[n5] <= '9' || cArray[n5] >= 'a' && cArray[n5] <= 'f' || cArray[n5] >= 'A' && cArray[n5] <= 'F')) {
                        return false;
                    }
                    ++n5;
                }
                return true;
            }
            if (Character.isDigit(cArray[n4 + 1])) {
                for (int i2 = n4 + 1; i2 < cArray.length; ++i2) {
                    if (cArray[i2] >= '0' && cArray[i2] <= '7') continue;
                    return false;
                }
                return true;
            }
        }
        --n3;
        for (n2 = n4; n2 < n3 || n2 < n3 + 1 && bl4 && !bl5; ++n2) {
            if (cArray[n2] >= '0' && cArray[n2] <= '9') {
                bl5 = true;
                bl4 = false;
                continue;
            }
            if (cArray[n2] == '.') {
                if (bl3 || bl2) {
                    return false;
                }
                bl3 = true;
                continue;
            }
            if (cArray[n2] == 'e' || cArray[n2] == 'E') {
                if (bl2) {
                    return false;
                }
                if (!bl5) {
                    return false;
                }
                bl2 = true;
                bl4 = true;
                continue;
            }
            if (cArray[n2] == '+' || cArray[n2] == '-') {
                if (!bl4) {
                    return false;
                }
                bl4 = false;
                bl5 = false;
                continue;
            }
            return false;
        }
        if (n2 < cArray.length) {
            if (cArray[n2] >= '0' && cArray[n2] <= '9') {
                return !SystemUtils.IS_JAVA_1_6 || !bl || bl3;
            }
            if (cArray[n2] == 'e' || cArray[n2] == 'E') {
                return false;
            }
            if (cArray[n2] == '.') {
                if (bl3 || bl2) {
                    return false;
                }
                return bl5;
            }
            if (!(bl4 || cArray[n2] != 'd' && cArray[n2] != 'D' && cArray[n2] != 'f' && cArray[n2] != 'F')) {
                return bl5;
            }
            if (cArray[n2] == 'l' || cArray[n2] == 'L') {
                return bl5 && !bl2 && !bl3;
            }
            return false;
        }
        return !bl4 && bl5;
    }

    public static boolean isParsable(String str) {
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        String string = str;
        if (string.charAt(string.length() - 1) == '.') {
            return false;
        }
        if (str.charAt(0) == '-') {
            if (str.length() == 1) {
                return false;
            }
            return NumberUtils.withDecimalsParsing(str, 1);
        }
        return NumberUtils.withDecimalsParsing(str, 0);
    }

    private static boolean withDecimalsParsing(String str, int beginIdx) {
        int n2 = 0;
        for (int i2 = beginIdx; i2 < str.length(); ++i2) {
            boolean bl = str.charAt(i2) == '.';
            if (bl) {
                ++n2;
            }
            if (n2 > 1) {
                return false;
            }
            if (bl || Character.isDigit(str.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static int compare(int x2, int y2) {
        if (x2 == y2) {
            return 0;
        }
        if (x2 < y2) {
            return -1;
        }
        return 1;
    }

    public static int compare(long x2, long y2) {
        if (x2 == y2) {
            return 0;
        }
        if (x2 < y2) {
            return -1;
        }
        return 1;
    }

    public static int compare(short x2, short y2) {
        if (x2 == y2) {
            return 0;
        }
        if (x2 < y2) {
            return -1;
        }
        return 1;
    }

    public static int compare(byte x2, byte y2) {
        return x2 - y2;
    }
}

