/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.commons.lang3.ClassUtils;

abstract class MemberUtils {
    private static final int ACCESS_TEST = 7;
    private static final Class<?>[] ORDERED_PRIMITIVE_TYPES = new Class[]{Byte.TYPE, Short.TYPE, Character.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};

    MemberUtils() {
    }

    static boolean setAccessibleWorkaround(AccessibleObject o2) {
        if (o2 == null || o2.isAccessible()) {
            return false;
        }
        Member member = (Member)((Object)o2);
        if (!o2.isAccessible() && Modifier.isPublic(member.getModifiers()) && MemberUtils.isPackageAccess(member.getDeclaringClass().getModifiers())) {
            try {
                o2.setAccessible(true);
                return true;
            }
            catch (SecurityException securityException) {}
        }
        return false;
    }

    static boolean isPackageAccess(int modifiers) {
        return (modifiers & 7) == 0;
    }

    static boolean isAccessible(Member m2) {
        return m2 != null && Modifier.isPublic(m2.getModifiers()) && !m2.isSynthetic();
    }

    static int compareConstructorFit(Constructor<?> left, Constructor<?> right, Class<?>[] actual) {
        return MemberUtils.compareParameterTypes(Executable.of(left), Executable.of(right), actual);
    }

    static int compareMethodFit(Method left, Method right, Class<?>[] actual) {
        return MemberUtils.compareParameterTypes(Executable.of(left), Executable.of(right), actual);
    }

    private static int compareParameterTypes(Executable left, Executable right, Class<?>[] actual) {
        float f2;
        float f3 = MemberUtils.getTotalTransformationCost(actual, left);
        if (f3 < (f2 = MemberUtils.getTotalTransformationCost(actual, right))) {
            return -1;
        }
        if (f2 < f3) {
            return 1;
        }
        return 0;
    }

    private static float getTotalTransformationCost(Class<?>[] srcArgs, Executable executable) {
        long l2;
        Class<?>[] classArray = executable.getParameterTypes();
        boolean bl = executable.isVarArgs();
        float f2 = 0.0f;
        long l3 = l2 = bl ? (long)(classArray.length - 1) : (long)classArray.length;
        if ((long)srcArgs.length < l2) {
            return Float.MAX_VALUE;
        }
        int n2 = 0;
        while ((long)n2 < l2) {
            f2 += MemberUtils.getObjectTransformationCost(srcArgs[n2], classArray[n2]);
            ++n2;
        }
        if (bl) {
            n2 = srcArgs.length < classArray.length ? 1 : 0;
            boolean bl2 = srcArgs.length == classArray.length && srcArgs[srcArgs.length - 1].isArray();
            Class<?> clazz = classArray[classArray.length - 1].getComponentType();
            if (n2 != 0) {
                f2 += MemberUtils.getObjectTransformationCost(clazz, Object.class) + 0.001f;
            } else if (bl2) {
                Class<?> clazz2 = srcArgs[srcArgs.length - 1].getComponentType();
                f2 += MemberUtils.getObjectTransformationCost(clazz2, clazz) + 0.001f;
            } else {
                for (int i2 = classArray.length - 1; i2 < srcArgs.length; ++i2) {
                    Class<?> clazz3 = srcArgs[i2];
                    f2 += MemberUtils.getObjectTransformationCost(clazz3, clazz) + 0.001f;
                }
            }
        }
        return f2;
    }

    private static float getObjectTransformationCost(Class<?> srcClass, Class<?> destClass) {
        if (destClass.isPrimitive()) {
            return MemberUtils.getPrimitivePromotionCost(srcClass, destClass);
        }
        float f2 = 0.0f;
        while (srcClass != null && !destClass.equals(srcClass)) {
            if (destClass.isInterface() && ClassUtils.isAssignable(srcClass, destClass)) {
                f2 += 0.25f;
                break;
            }
            f2 += 1.0f;
            srcClass = srcClass.getSuperclass();
        }
        if (srcClass == null) {
            f2 += 1.5f;
        }
        return f2;
    }

    private static float getPrimitivePromotionCost(Class<?> srcClass, Class<?> destClass) {
        float f2 = 0.0f;
        Class<?> clazz = srcClass;
        if (!clazz.isPrimitive()) {
            f2 = 0.1f;
            clazz = ClassUtils.wrapperToPrimitive(clazz);
        }
        for (int i2 = 0; clazz != destClass && i2 < ORDERED_PRIMITIVE_TYPES.length; ++i2) {
            if (clazz != ORDERED_PRIMITIVE_TYPES[i2]) continue;
            f2 += 0.1f;
            if (i2 >= ORDERED_PRIMITIVE_TYPES.length - 1) continue;
            clazz = ORDERED_PRIMITIVE_TYPES[i2 + 1];
        }
        return f2;
    }

    static boolean isMatchingMethod(Method method, Class<?>[] parameterTypes) {
        return MemberUtils.isMatchingExecutable(Executable.of(method), parameterTypes);
    }

    static boolean isMatchingConstructor(Constructor<?> method, Class<?>[] parameterTypes) {
        return MemberUtils.isMatchingExecutable(Executable.of(method), parameterTypes);
    }

    private static boolean isMatchingExecutable(Executable method, Class<?>[] parameterTypes) {
        Class<?>[] classArray = method.getParameterTypes();
        if (method.isVarArgs()) {
            int n2;
            for (n2 = 0; n2 < classArray.length - 1 && n2 < parameterTypes.length; ++n2) {
                if (ClassUtils.isAssignable(parameterTypes[n2], classArray[n2], true)) continue;
                return false;
            }
            Class<?> clazz = classArray[classArray.length - 1].getComponentType();
            while (n2 < parameterTypes.length) {
                if (!ClassUtils.isAssignable(parameterTypes[n2], clazz, true)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return ClassUtils.isAssignable(parameterTypes, classArray, true);
    }

    private static final class Executable {
        private final Class<?>[] parameterTypes;
        private final boolean isVarArgs;

        private static Executable of(Method method) {
            return new Executable(method);
        }

        private static Executable of(Constructor<?> constructor) {
            return new Executable(constructor);
        }

        private Executable(Method method) {
            this.parameterTypes = method.getParameterTypes();
            this.isVarArgs = method.isVarArgs();
        }

        private Executable(Constructor<?> constructor) {
            this.parameterTypes = constructor.getParameterTypes();
            this.isVarArgs = constructor.isVarArgs();
        }

        public final Class<?>[] getParameterTypes() {
            return this.parameterTypes;
        }

        public final boolean isVarArgs() {
            return this.isVarArgs;
        }
    }
}

