/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.reflect.MemberUtils;
import org.apache.commons.lang3.reflect.TypeUtils;

public class MethodUtils {
    public static Object invokeMethod(Object object, String methodName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return MethodUtils.invokeMethod(object, methodName, ArrayUtils.EMPTY_OBJECT_ARRAY, null);
    }

    public static Object invokeMethod(Object object, boolean forceAccess, String methodName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return MethodUtils.invokeMethod(object, forceAccess, methodName, ArrayUtils.EMPTY_OBJECT_ARRAY, null);
    }

    public static Object invokeMethod(Object object, String methodName, Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        args = ArrayUtils.nullToEmpty(args);
        Class<?>[] classArray = ClassUtils.toClass(args);
        return MethodUtils.invokeMethod(object, methodName, args, classArray);
    }

    public static Object invokeMethod(Object object, boolean forceAccess, String methodName, Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        args = ArrayUtils.nullToEmpty(args);
        Class<?>[] classArray = ClassUtils.toClass(args);
        return MethodUtils.invokeMethod(object, forceAccess, methodName, args, classArray);
    }

    public static Object invokeMethod(Object object, boolean forceAccess, String methodName, Object[] args, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        String string;
        parameterTypes = ArrayUtils.nullToEmpty(parameterTypes);
        args = ArrayUtils.nullToEmpty(args);
        if (forceAccess) {
            string = "No such method: ";
            method = MethodUtils.getMatchingMethod(object.getClass(), methodName, parameterTypes);
            if (method != null && !method.isAccessible()) {
                method.setAccessible(true);
            }
        } else {
            string = "No such accessible method: ";
            method = MethodUtils.getMatchingAccessibleMethod(object.getClass(), methodName, parameterTypes);
        }
        if (method == null) {
            throw new NoSuchMethodException(string + methodName + "() on object: " + object.getClass().getName());
        }
        args = MethodUtils.toVarArgs(method, args);
        return method.invoke(object, args);
    }

    public static Object invokeMethod(Object object, String methodName, Object[] args, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return MethodUtils.invokeMethod(object, false, methodName, args, parameterTypes);
    }

    public static Object invokeExactMethod(Object object, String methodName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return MethodUtils.invokeExactMethod(object, methodName, ArrayUtils.EMPTY_OBJECT_ARRAY, null);
    }

    public static Object invokeExactMethod(Object object, String methodName, Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        args = ArrayUtils.nullToEmpty(args);
        Class<?>[] classArray = ClassUtils.toClass(args);
        return MethodUtils.invokeExactMethod(object, methodName, args, classArray);
    }

    public static Object invokeExactMethod(Object object, String methodName, Object[] args, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        args = ArrayUtils.nullToEmpty(args);
        parameterTypes = ArrayUtils.nullToEmpty(parameterTypes);
        Method method = MethodUtils.getAccessibleMethod(object.getClass(), methodName, parameterTypes);
        if (method == null) {
            throw new NoSuchMethodException("No such accessible method: " + methodName + "() on object: " + object.getClass().getName());
        }
        return method.invoke(object, args);
    }

    public static Object invokeExactStaticMethod(Class<?> cls, String methodName, Object[] args, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        args = ArrayUtils.nullToEmpty(args);
        Method method = MethodUtils.getAccessibleMethod(cls, methodName, parameterTypes = ArrayUtils.nullToEmpty(parameterTypes));
        if (method == null) {
            throw new NoSuchMethodException("No such accessible method: " + methodName + "() on class: " + cls.getName());
        }
        return method.invoke(null, args);
    }

    public static Object invokeStaticMethod(Class<?> cls, String methodName, Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        args = ArrayUtils.nullToEmpty(args);
        Class<?>[] classArray = ClassUtils.toClass(args);
        return MethodUtils.invokeStaticMethod(cls, methodName, args, classArray);
    }

    public static Object invokeStaticMethod(Class<?> cls, String methodName, Object[] args, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        args = ArrayUtils.nullToEmpty(args);
        Method method = MethodUtils.getMatchingAccessibleMethod(cls, methodName, parameterTypes = ArrayUtils.nullToEmpty(parameterTypes));
        if (method == null) {
            throw new NoSuchMethodException("No such accessible method: " + methodName + "() on class: " + cls.getName());
        }
        args = MethodUtils.toVarArgs(method, args);
        return method.invoke(null, args);
    }

    private static Object[] toVarArgs(Method method, Object[] args) {
        if (method.isVarArgs()) {
            Class<?>[] classArray = method.getParameterTypes();
            args = MethodUtils.getVarArgs(args, classArray);
        }
        return args;
    }

    static Object[] getVarArgs(Object[] args, Class<?>[] methodParameterTypes) {
        if (args.length == methodParameterTypes.length && args[args.length - 1].getClass().equals(methodParameterTypes[methodParameterTypes.length - 1])) {
            return args;
        }
        Object[] objectArray = new Object[methodParameterTypes.length];
        System.arraycopy(args, 0, objectArray, 0, methodParameterTypes.length - 1);
        Class<?> clazz = methodParameterTypes[methodParameterTypes.length - 1].getComponentType();
        int n2 = args.length - methodParameterTypes.length + 1;
        Object object = Array.newInstance(ClassUtils.primitiveToWrapper(clazz), n2);
        System.arraycopy(args, methodParameterTypes.length - 1, object, 0, n2);
        if (clazz.isPrimitive()) {
            object = ArrayUtils.toPrimitive(object);
        }
        objectArray[methodParameterTypes.length - 1] = object;
        return objectArray;
    }

    public static Object invokeExactStaticMethod(Class<?> cls, String methodName, Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        args = ArrayUtils.nullToEmpty(args);
        Class<?>[] classArray = ClassUtils.toClass(args);
        return MethodUtils.invokeExactStaticMethod(cls, methodName, args, classArray);
    }

    public static Method getAccessibleMethod(Class<?> cls, String methodName, Class<?> ... parameterTypes) {
        try {
            return MethodUtils.getAccessibleMethod(cls.getMethod(methodName, parameterTypes));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static Method getAccessibleMethod(Method method) {
        Class<?>[] classArray;
        if (!MemberUtils.isAccessible(method)) {
            return null;
        }
        Class<?> clazz = method.getDeclaringClass();
        if (Modifier.isPublic(clazz.getModifiers())) {
            return method;
        }
        String string = method.getName();
        if ((method = MethodUtils.getAccessibleMethodFromInterfaceNest(clazz, string, classArray = method.getParameterTypes())) == null) {
            method = MethodUtils.getAccessibleMethodFromSuperclass(clazz, string, classArray);
        }
        return method;
    }

    private static Method getAccessibleMethodFromSuperclass(Class<?> cls, String methodName, Class<?> ... parameterTypes) {
        for (Class<?> clazz = cls.getSuperclass(); clazz != null; clazz = clazz.getSuperclass()) {
            if (!Modifier.isPublic(clazz.getModifiers())) continue;
            try {
                return clazz.getMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
        }
        return null;
    }

    private static Method getAccessibleMethodFromInterfaceNest(Class<?> cls, String methodName, Class<?> ... parameterTypes) {
        while (cls != null) {
            Class<?>[] classArray;
            Class<?>[] classArray2 = classArray = cls.getInterfaces();
            int n2 = classArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Class<?> clazz = classArray2[i2];
                if (!Modifier.isPublic(clazz.getModifiers())) continue;
                try {
                    return clazz.getDeclaredMethod(methodName, parameterTypes);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    Method method = MethodUtils.getAccessibleMethodFromInterfaceNest(clazz, methodName, parameterTypes);
                    if (method == null) continue;
                    return method;
                }
            }
            cls = cls.getSuperclass();
        }
        return null;
    }

    public static Method getMatchingAccessibleMethod(Class<?> cls, String methodName, Class<?> ... parameterTypes) {
        try {
            Method method = cls.getMethod(methodName, parameterTypes);
            MemberUtils.setAccessibleWorkaround(method);
            return method;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Object object;
            Object object2;
            Method method = null;
            Method[] methodArray = cls.getMethods();
            GenericDeclaration[] genericDeclarationArray = methodArray;
            int n2 = methodArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                object2 = genericDeclarationArray[i2];
                if (!((Method)object2).getName().equals(methodName) || !MemberUtils.isMatchingMethod((Method)object2, parameterTypes) || (object = MethodUtils.getAccessibleMethod((Method)object2)) == null || method != null && MemberUtils.compareMethodFit((Method)object, method, parameterTypes) >= 0) continue;
                method = object;
            }
            if (method != null) {
                MemberUtils.setAccessibleWorkaround(method);
            }
            if (method != null && method.isVarArgs() && method.getParameterTypes().length > 0 && parameterTypes.length > 0) {
                genericDeclarationArray = method.getParameterTypes();
                Class<?> clazz = genericDeclarationArray[genericDeclarationArray.length - 1].getComponentType();
                String string = ClassUtils.primitiveToWrapper(clazz).getName();
                object2 = parameterTypes[parameterTypes.length - 1].getName();
                object = parameterTypes[parameterTypes.length - 1].getSuperclass().getName();
                if (!string.equals(object2) && !string.equals(object)) {
                    return null;
                }
            }
            return method;
        }
    }

    public static Method getMatchingMethod(Class<?> cls, String methodName, Class<?> ... parameterTypes) {
        Validate.notNull(cls, "Null class not allowed.", new Object[0]);
        Validate.notEmpty(methodName, "Null or blank methodName not allowed.", new Object[0]);
        Method[] methodArray2 = cls.getDeclaredMethods();
        List<Class<?>> list = ClassUtils.getAllSuperclasses(cls);
        for (Class<?> methodArray3 : list) {
            methodArray2 = ArrayUtils.addAll(methodArray2, methodArray3.getDeclaredMethods());
        }
        Object object = null;
        Method[] methodArray = methodArray2;
        int n2 = methodArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Method method = methodArray[i2];
            if (methodName.equals(method.getName()) && Objects.deepEquals(parameterTypes, method.getParameterTypes())) {
                return method;
            }
            if (!methodName.equals(method.getName()) || !ClassUtils.isAssignable(parameterTypes, method.getParameterTypes(), true)) continue;
            if (object == null) {
                object = method;
                continue;
            }
            if (MethodUtils.distance(parameterTypes, method.getParameterTypes()) >= MethodUtils.distance(parameterTypes, ((Method)object).getParameterTypes())) continue;
            object = method;
        }
        return object;
    }

    private static int distance(Class<?>[] classArray, Class<?>[] toClassArray) {
        int n2 = 0;
        if (!ClassUtils.isAssignable(classArray, toClassArray, true)) {
            return -1;
        }
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            if (classArray[i2].equals(toClassArray[i2])) continue;
            if (ClassUtils.isAssignable(classArray[i2], toClassArray[i2], true) && !ClassUtils.isAssignable(classArray[i2], toClassArray[i2], false)) {
                ++n2;
                continue;
            }
            n2 += 2;
        }
        return n2;
    }

    public static Set<Method> getOverrideHierarchy(Method method, ClassUtils.Interfaces interfacesBehavior) {
        Validate.notNull(method);
        LinkedHashSet<Method> linkedHashSet = new LinkedHashSet<Method>();
        linkedHashSet.add(method);
        Object[] objectArray = method.getParameterTypes();
        Class<?> clazz = method.getDeclaringClass();
        Iterator<Class<?>> iterator = ClassUtils.hierarchy(clazz, interfacesBehavior).iterator();
        iterator.next();
        block0: while (iterator.hasNext()) {
            Class<?> clazz2 = iterator.next();
            Method method2 = MethodUtils.getMatchingAccessibleMethod(clazz2, method.getName(), objectArray);
            if (method2 == null) continue;
            if (Arrays.equals(method2.getParameterTypes(), objectArray)) {
                linkedHashSet.add(method2);
                continue;
            }
            Map<TypeVariable<?>, Type> map = TypeUtils.getTypeArguments(clazz, method2.getDeclaringClass());
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                Type type;
                Type type2 = TypeUtils.unrollVariables(map, method.getGenericParameterTypes()[i2]);
                if (!TypeUtils.equals(type2, type = TypeUtils.unrollVariables(map, method2.getGenericParameterTypes()[i2]))) continue block0;
            }
            linkedHashSet.add(method2);
        }
        return linkedHashSet;
    }

    public static Method[] getMethodsWithAnnotation(Class<?> cls, Class<? extends Annotation> annotationCls) {
        return MethodUtils.getMethodsWithAnnotation(cls, annotationCls, false, false);
    }

    public static List<Method> getMethodsListWithAnnotation(Class<?> cls, Class<? extends Annotation> annotationCls) {
        return MethodUtils.getMethodsListWithAnnotation(cls, annotationCls, false, false);
    }

    public static Method[] getMethodsWithAnnotation(Class<?> cls, Class<? extends Annotation> annotationCls, boolean searchSupers, boolean ignoreAccess) {
        List<Method> list = MethodUtils.getMethodsListWithAnnotation(cls, annotationCls, searchSupers, ignoreAccess);
        return list.toArray(new Method[list.size()]);
    }

    public static List<Method> getMethodsListWithAnnotation(Class<?> cls, Class<? extends Annotation> annotationCls, boolean searchSupers, boolean ignoreAccess) {
        Validate.isTrue(cls != null, "The class must not be null", new Object[0]);
        Validate.isTrue(annotationCls != null, "The annotation class must not be null", new Object[0]);
        ArrayList arrayList = searchSupers ? MethodUtils.getAllSuperclassesAndInterfaces(cls) : new ArrayList();
        arrayList.add(0, cls);
        ArrayList<Method> arrayList2 = new ArrayList<Method>();
        for (Class clazz : arrayList) {
            Method[] methodArray = ignoreAccess ? clazz.getDeclaredMethods() : clazz.getMethods();
            Method[] methodArray2 = methodArray;
            int n2 = methodArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Method method = methodArray2[i2];
                if (method.getAnnotation(annotationCls) == null) continue;
                arrayList2.add(method);
            }
        }
        return arrayList2;
    }

    public static <A extends Annotation> A getAnnotation(Method method, Class<A> annotationCls, boolean searchSupers, boolean ignoreAccess) {
        Validate.isTrue(method != null, "The method must not be null", new Object[0]);
        Validate.isTrue(annotationCls != null, "The annotation class must not be null", new Object[0]);
        if (!ignoreAccess && !MemberUtils.isAccessible(method)) {
            return null;
        }
        A a2 = method.getAnnotation(annotationCls);
        if (a2 == null && searchSupers) {
            Class<?> clazz = method.getDeclaringClass();
            List<Class<?>> list = MethodUtils.getAllSuperclassesAndInterfaces(clazz);
            for (Class<?> clazz2 : list) {
                Method method2;
                try {
                    method2 = ignoreAccess ? clazz2.getDeclaredMethod(method.getName(), method.getParameterTypes()) : clazz2.getMethod(method.getName(), method.getParameterTypes());
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    continue;
                }
                a2 = method2.getAnnotation(annotationCls);
                if (a2 == null) continue;
            }
        }
        return a2;
    }

    private static List<Class<?>> getAllSuperclassesAndInterfaces(Class<?> cls) {
        if (cls == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        List<Class<?>> list = ClassUtils.getAllSuperclasses(cls);
        int n2 = 0;
        List<Class<?>> list2 = ClassUtils.getAllInterfaces(cls);
        int n3 = 0;
        while (n3 < list2.size() || n2 < list.size()) {
            Class<?> clazz = n3 >= list2.size() ? list.get(n2++) : (n2 < list.size() && n3 >= n2 && n2 < n3 ? list.get(n2++) : list2.get(n3++));
            arrayList.add(clazz);
        }
        return arrayList;
    }
}

