/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.lang3.Validate;
import org.apache.commons.text.CharacterPredicate;
import org.apache.commons.text.TextRandomProvider;

public final class RandomStringGenerator {
    private final int minimumCodePoint;
    private final int maximumCodePoint;
    private final Set<CharacterPredicate> inclusivePredicates;
    private final TextRandomProvider random;

    private RandomStringGenerator(int minimumCodePoint, int maximumCodePoint, Set<CharacterPredicate> inclusivePredicates, TextRandomProvider random) {
        this.minimumCodePoint = minimumCodePoint;
        this.maximumCodePoint = maximumCodePoint;
        this.inclusivePredicates = inclusivePredicates;
        this.random = random;
    }

    private int generateRandomNumber(int minInclusive, int maxInclusive) {
        if (this.random != null) {
            return this.random.nextInt(maxInclusive - minInclusive + 1) + minInclusive;
        }
        return ThreadLocalRandom.current().nextInt(minInclusive, maxInclusive + 1);
    }

    public final String generate(int length) {
        if (length == 0) {
            return "";
        }
        Validate.isTrue(length > 0, "Length %d is smaller than zero.", length);
        StringBuilder stringBuilder = new StringBuilder(length);
        long l2 = length;
        block3: do {
            RandomStringGenerator randomStringGenerator = this;
            int n2 = randomStringGenerator.generateRandomNumber(randomStringGenerator.minimumCodePoint, this.maximumCodePoint);
            switch (Character.getType(n2)) {
                case 0: 
                case 18: 
                case 19: {
                    break;
                }
                default: {
                    if (this.inclusivePredicates != null) {
                        boolean bl = false;
                        for (CharacterPredicate characterPredicate : this.inclusivePredicates) {
                            if (!characterPredicate.test(n2)) continue;
                            bl = true;
                            break;
                        }
                        if (!bl) continue block3;
                    }
                    stringBuilder.appendCodePoint(n2);
                    --l2;
                }
            }
        } while (l2 != 0L);
        return stringBuilder.toString();
    }

    public static class Builder
    implements org.apache.commons.text.Builder<RandomStringGenerator> {
        public static final int DEFAULT_MAXIMUM_CODE_POINT = 0x10FFFF;
        public static final int DEFAULT_LENGTH = 0;
        public static final int DEFAULT_MINIMUM_CODE_POINT = 0;
        private int minimumCodePoint = 0;
        private int maximumCodePoint = 0x10FFFF;
        private Set<CharacterPredicate> inclusivePredicates;
        private TextRandomProvider random;

        public Builder withinRange(int minimumCodePoint, int maximumCodePoint) {
            Validate.isTrue(minimumCodePoint <= maximumCodePoint, "Minimum code point %d is larger than maximum code point %d", minimumCodePoint, maximumCodePoint);
            Validate.isTrue(minimumCodePoint >= 0, "Minimum code point %d is negative", minimumCodePoint);
            Validate.isTrue(maximumCodePoint <= 0x10FFFF, "Value %d is larger than Character.MAX_CODE_POINT.", maximumCodePoint);
            this.minimumCodePoint = minimumCodePoint;
            this.maximumCodePoint = maximumCodePoint;
            return this;
        }

        public Builder filteredBy(CharacterPredicate ... predicates) {
            if (predicates == null || predicates.length == 0) {
                this.inclusivePredicates = null;
                return this;
            }
            if (this.inclusivePredicates == null) {
                this.inclusivePredicates = new HashSet<CharacterPredicate>();
            } else {
                this.inclusivePredicates.clear();
            }
            CharacterPredicate[] characterPredicateArray = predicates;
            int n2 = predicates.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                CharacterPredicate characterPredicate = characterPredicateArray[i2];
                this.inclusivePredicates.add(characterPredicate);
            }
            return this;
        }

        public Builder usingRandom(TextRandomProvider random) {
            this.random = random;
            return this;
        }

        @Override
        public RandomStringGenerator build() {
            return new RandomStringGenerator(this.minimumCodePoint, this.maximumCodePoint, this.inclusivePredicates, this.random);
        }
    }
}

