/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.Validate;
import org.apache.commons.text.StrBuilder;
import org.apache.commons.text.StrLookup;
import org.apache.commons.text.StrMatcher;

public class StrSubstitutor {
    public static final char DEFAULT_ESCAPE = '$';
    public static final StrMatcher DEFAULT_PREFIX = StrMatcher.stringMatcher("${");
    public static final StrMatcher DEFAULT_SUFFIX = StrMatcher.stringMatcher("}");
    public static final StrMatcher DEFAULT_VALUE_DELIMITER = StrMatcher.stringMatcher(":-");
    private char escapeChar;
    private StrMatcher prefixMatcher;
    private StrMatcher suffixMatcher;
    private StrMatcher valueDelimiterMatcher;
    private StrLookup<?> variableResolver;
    private boolean enableSubstitutionInVariables;
    private boolean preserveEscapes = false;

    public static <V> String replace(Object source, Map<String, V> valueMap) {
        return new StrSubstitutor(valueMap).replace(source);
    }

    public static <V> String replace(Object source, Map<String, V> valueMap, String prefix, String suffix) {
        return new StrSubstitutor(valueMap, prefix, suffix).replace(source);
    }

    public static String replace(Object source, Properties valueProperties) {
        if (valueProperties == null) {
            return source.toString();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Enumeration<?> enumeration = valueProperties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = valueProperties.getProperty(string);
            hashMap.put(string, string2);
        }
        return StrSubstitutor.replace(source, hashMap);
    }

    public static String replaceSystemProperties(Object source) {
        return new StrSubstitutor(StrLookup.systemPropertiesLookup()).replace(source);
    }

    public StrSubstitutor() {
        this(null, DEFAULT_PREFIX, DEFAULT_SUFFIX, '$');
    }

    public <V> StrSubstitutor(Map<String, V> valueMap) {
        this(StrLookup.mapLookup(valueMap), DEFAULT_PREFIX, DEFAULT_SUFFIX, '$');
    }

    public <V> StrSubstitutor(Map<String, V> valueMap, String prefix, String suffix) {
        this(StrLookup.mapLookup(valueMap), prefix, suffix, '$');
    }

    public <V> StrSubstitutor(Map<String, V> valueMap, String prefix, String suffix, char escape) {
        this(StrLookup.mapLookup(valueMap), prefix, suffix, escape);
    }

    public <V> StrSubstitutor(Map<String, V> valueMap, String prefix, String suffix, char escape, String valueDelimiter) {
        this(StrLookup.mapLookup(valueMap), prefix, suffix, escape, valueDelimiter);
    }

    public StrSubstitutor(StrLookup<?> variableResolver) {
        this(variableResolver, DEFAULT_PREFIX, DEFAULT_SUFFIX, '$');
    }

    public StrSubstitutor(StrLookup<?> variableResolver, String prefix, String suffix, char escape) {
        this.setVariableResolver(variableResolver);
        this.setVariablePrefix(prefix);
        this.setVariableSuffix(suffix);
        this.setEscapeChar(escape);
        this.setValueDelimiterMatcher(DEFAULT_VALUE_DELIMITER);
    }

    public StrSubstitutor(StrLookup<?> variableResolver, String prefix, String suffix, char escape, String valueDelimiter) {
        this.setVariableResolver(variableResolver);
        this.setVariablePrefix(prefix);
        this.setVariableSuffix(suffix);
        this.setEscapeChar(escape);
        this.setValueDelimiter(valueDelimiter);
    }

    public StrSubstitutor(StrLookup<?> variableResolver, StrMatcher prefixMatcher, StrMatcher suffixMatcher, char escape) {
        this(variableResolver, prefixMatcher, suffixMatcher, escape, DEFAULT_VALUE_DELIMITER);
    }

    public StrSubstitutor(StrLookup<?> variableResolver, StrMatcher prefixMatcher, StrMatcher suffixMatcher, char escape, StrMatcher valueDelimiterMatcher) {
        this.setVariableResolver(variableResolver);
        this.setVariablePrefixMatcher(prefixMatcher);
        this.setVariableSuffixMatcher(suffixMatcher);
        this.setEscapeChar(escape);
        this.setValueDelimiterMatcher(valueDelimiterMatcher);
    }

    public String replace(String source) {
        if (source == null) {
            return null;
        }
        StrBuilder strBuilder = new StrBuilder(source);
        if (!this.substitute(strBuilder, 0, source.length())) {
            return source;
        }
        return strBuilder.toString();
    }

    public String replace(String source, int offset, int length) {
        if (source == null) {
            return null;
        }
        StrBuilder strBuilder = new StrBuilder(length).append(source, offset, length);
        if (!this.substitute(strBuilder, 0, length)) {
            int n2 = offset;
            return source.substring(n2, n2 + length);
        }
        return strBuilder.toString();
    }

    public String replace(char[] source) {
        if (source == null) {
            return null;
        }
        StrBuilder strBuilder = new StrBuilder(source.length).append(source);
        this.substitute(strBuilder, 0, source.length);
        return strBuilder.toString();
    }

    public String replace(char[] source, int offset, int length) {
        if (source == null) {
            return null;
        }
        StrBuilder strBuilder = new StrBuilder(length).append(source, offset, length);
        this.substitute(strBuilder, 0, length);
        return strBuilder.toString();
    }

    public String replace(StringBuffer source) {
        if (source == null) {
            return null;
        }
        StrBuilder strBuilder = new StrBuilder(source.length()).append(source);
        this.substitute(strBuilder, 0, strBuilder.length());
        return strBuilder.toString();
    }

    public String replace(StringBuffer source, int offset, int length) {
        if (source == null) {
            return null;
        }
        StrBuilder strBuilder = new StrBuilder(length).append(source, offset, length);
        this.substitute(strBuilder, 0, length);
        return strBuilder.toString();
    }

    public String replace(CharSequence source) {
        if (source == null) {
            return null;
        }
        return this.replace(source, 0, source.length());
    }

    public String replace(CharSequence source, int offset, int length) {
        if (source == null) {
            return null;
        }
        StrBuilder strBuilder = new StrBuilder(length).append(source, offset, length);
        this.substitute(strBuilder, 0, length);
        return strBuilder.toString();
    }

    public String replace(StrBuilder source) {
        if (source == null) {
            return null;
        }
        StrBuilder strBuilder = new StrBuilder(source.length()).append(source);
        this.substitute(strBuilder, 0, strBuilder.length());
        return strBuilder.toString();
    }

    public String replace(StrBuilder source, int offset, int length) {
        if (source == null) {
            return null;
        }
        StrBuilder strBuilder = new StrBuilder(length).append(source, offset, length);
        this.substitute(strBuilder, 0, length);
        return strBuilder.toString();
    }

    public String replace(Object source) {
        if (source == null) {
            return null;
        }
        StrBuilder strBuilder = new StrBuilder().append(source);
        this.substitute(strBuilder, 0, strBuilder.length());
        return strBuilder.toString();
    }

    public boolean replaceIn(StringBuffer source) {
        if (source == null) {
            return false;
        }
        return this.replaceIn(source, 0, source.length());
    }

    public boolean replaceIn(StringBuffer source, int offset, int length) {
        if (source == null) {
            return false;
        }
        StrBuilder strBuilder = new StrBuilder(length).append(source, offset, length);
        if (!this.substitute(strBuilder, 0, length)) {
            return false;
        }
        int n2 = offset;
        source.replace(n2, n2 + length, strBuilder.toString());
        return true;
    }

    public boolean replaceIn(StringBuilder source) {
        if (source == null) {
            return false;
        }
        return this.replaceIn(source, 0, source.length());
    }

    public boolean replaceIn(StringBuilder source, int offset, int length) {
        if (source == null) {
            return false;
        }
        StrBuilder strBuilder = new StrBuilder(length).append(source, offset, length);
        if (!this.substitute(strBuilder, 0, length)) {
            return false;
        }
        int n2 = offset;
        source.replace(n2, n2 + length, strBuilder.toString());
        return true;
    }

    public boolean replaceIn(StrBuilder source) {
        if (source == null) {
            return false;
        }
        return this.substitute(source, 0, source.length());
    }

    public boolean replaceIn(StrBuilder source, int offset, int length) {
        if (source == null) {
            return false;
        }
        return this.substitute(source, offset, length);
    }

    protected boolean substitute(StrBuilder buf, int offset, int length) {
        return this.substitute(buf, offset, length, null) > 0;
    }

    private int substitute(StrBuilder buf, int offset, int length, List<String> priorVariables) {
        StrMatcher strMatcher = this.getVariablePrefixMatcher();
        StrMatcher strMatcher2 = this.getVariableSuffixMatcher();
        char c2 = this.getEscapeChar();
        StrMatcher strMatcher3 = this.getValueDelimiterMatcher();
        boolean bl = this.isEnableSubstitutionInVariables();
        boolean bl2 = priorVariables == null;
        boolean bl3 = false;
        int n2 = 0;
        char[] cArray = buf.buffer;
        int n3 = offset + length;
        int n4 = offset;
        block0: while (n4 < n3) {
            int n5 = strMatcher.isMatch(cArray, n4, offset, n3);
            if (n5 == 0) {
                ++n4;
                continue;
            }
            if (n4 > offset && cArray[n4 - 1] == c2) {
                if (this.preserveEscapes) {
                    ++n4;
                    continue;
                }
                buf.deleteCharAt(n4 - 1);
                cArray = buf.buffer;
                --n2;
                bl3 = true;
                --n3;
                continue;
            }
            int n6 = n4;
            n4 += n5;
            int n7 = 0;
            while (n4 < n3) {
                int n8;
                if (bl && strMatcher.isMatch(cArray, n4, offset, n3) != 0) {
                    n8 = strMatcher.isMatch(cArray, n4, offset, n3);
                    ++n7;
                    n4 += n8;
                    continue;
                }
                n8 = strMatcher2.isMatch(cArray, n4, offset, n3);
                if (n8 == 0) {
                    ++n4;
                    continue;
                }
                if (n7 == 0) {
                    int n9;
                    int n10;
                    Object object;
                    String string = new String(cArray, n6 + n5, n4 - n6 - n5);
                    if (bl) {
                        StrBuilder strBuilder = new StrBuilder(string);
                        this.substitute(strBuilder, 0, strBuilder.length());
                        string = strBuilder.toString();
                    }
                    int n11 = n4 += n8;
                    String string2 = string;
                    String string3 = null;
                    if (strMatcher3 != null) {
                        object = string.toCharArray();
                        for (n10 = 0; n10 < ((char[])object).length; ++n10) {
                            if (!bl) {
                                int n12 = n10;
                                if (strMatcher.isMatch((char[])object, n12, n12, ((char[])object).length) != 0) break;
                            }
                            if (strMatcher3.isMatch((char[])object, n10) == 0) continue;
                            n9 = strMatcher3.isMatch((char[])object, n10);
                            string2 = string.substring(0, n10);
                            string3 = string.substring(n10 + n9);
                            break;
                        }
                    }
                    if (priorVariables == null) {
                        priorVariables = new ArrayList<String>();
                        priorVariables.add(new String(cArray, offset, length));
                    }
                    this.checkCyclicSubstitution(string2, priorVariables);
                    priorVariables.add(string2);
                    String string4 = this.resolveVariable(string2, buf, n6, n11);
                    object = string4;
                    if (string4 == null) {
                        object = string3;
                    }
                    if (object != null) {
                        n9 = ((String)object).length();
                        buf.replace(n6, n11, (String)object);
                        bl3 = true;
                        n10 = this.substitute(buf, n6, n9, priorVariables);
                        n10 = n10 + n9 - (n11 - n6);
                        n4 += n10;
                        n3 += n10;
                        n2 += n10;
                        cArray = buf.buffer;
                    }
                    List<String> list = priorVariables;
                    list.remove(list.size() - 1);
                    continue block0;
                }
                --n7;
                n4 += n8;
            }
        }
        if (bl2) {
            if (bl3) {
                return 1;
            }
            return 0;
        }
        return n2;
    }

    private void checkCyclicSubstitution(String varName, List<String> priorVariables) {
        if (!priorVariables.contains(varName)) {
            return;
        }
        StrBuilder strBuilder = new StrBuilder(256);
        strBuilder.append("Infinite loop in property interpolation of ");
        strBuilder.append(priorVariables.remove(0));
        strBuilder.append(": ");
        strBuilder.appendWithSeparators(priorVariables, "->");
        throw new IllegalStateException(strBuilder.toString());
    }

    protected String resolveVariable(String variableName, StrBuilder buf, int startPos, int endPos) {
        StrLookup<?> strLookup = this.getVariableResolver();
        if (strLookup == null) {
            return null;
        }
        return strLookup.lookup(variableName);
    }

    public char getEscapeChar() {
        return this.escapeChar;
    }

    public void setEscapeChar(char escapeCharacter) {
        this.escapeChar = escapeCharacter;
    }

    public StrMatcher getVariablePrefixMatcher() {
        return this.prefixMatcher;
    }

    public StrSubstitutor setVariablePrefixMatcher(StrMatcher prefixMatcher) {
        Validate.isTrue(prefixMatcher != null, "Variable prefix matcher must not be null!", new Object[0]);
        this.prefixMatcher = prefixMatcher;
        return this;
    }

    public StrSubstitutor setVariablePrefix(char prefix) {
        return this.setVariablePrefixMatcher(StrMatcher.charMatcher(prefix));
    }

    public StrSubstitutor setVariablePrefix(String prefix) {
        Validate.isTrue(prefix != null, "Variable prefix must not be null!", new Object[0]);
        return this.setVariablePrefixMatcher(StrMatcher.stringMatcher(prefix));
    }

    public StrMatcher getVariableSuffixMatcher() {
        return this.suffixMatcher;
    }

    public StrSubstitutor setVariableSuffixMatcher(StrMatcher suffixMatcher) {
        Validate.isTrue(suffixMatcher != null, "Variable suffix matcher must not be null!", new Object[0]);
        this.suffixMatcher = suffixMatcher;
        return this;
    }

    public StrSubstitutor setVariableSuffix(char suffix) {
        return this.setVariableSuffixMatcher(StrMatcher.charMatcher(suffix));
    }

    public StrSubstitutor setVariableSuffix(String suffix) {
        Validate.isTrue(suffix != null, "Variable suffix must not be null!", new Object[0]);
        return this.setVariableSuffixMatcher(StrMatcher.stringMatcher(suffix));
    }

    public StrMatcher getValueDelimiterMatcher() {
        return this.valueDelimiterMatcher;
    }

    public StrSubstitutor setValueDelimiterMatcher(StrMatcher valueDelimiterMatcher) {
        this.valueDelimiterMatcher = valueDelimiterMatcher;
        return this;
    }

    public StrSubstitutor setValueDelimiter(char valueDelimiter) {
        return this.setValueDelimiterMatcher(StrMatcher.charMatcher(valueDelimiter));
    }

    public StrSubstitutor setValueDelimiter(String valueDelimiter) {
        if (valueDelimiter == null || valueDelimiter.length() == 0) {
            this.setValueDelimiterMatcher(null);
            return this;
        }
        return this.setValueDelimiterMatcher(StrMatcher.stringMatcher(valueDelimiter));
    }

    public StrLookup<?> getVariableResolver() {
        return this.variableResolver;
    }

    public void setVariableResolver(StrLookup<?> variableResolver) {
        this.variableResolver = variableResolver;
    }

    public boolean isEnableSubstitutionInVariables() {
        return this.enableSubstitutionInVariables;
    }

    public void setEnableSubstitutionInVariables(boolean enableSubstitutionInVariables) {
        this.enableSubstitutionInVariables = enableSubstitutionInVariables;
    }

    public boolean isPreserveEscapes() {
        return this.preserveEscapes;
    }

    public void setPreserveEscapes(boolean preserveEscapes) {
        this.preserveEscapes = preserveEscapes;
    }
}

