/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.translate;

import java.io.IOException;
import java.io.Writer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.translate.SinglePassTranslator;

public final class CsvTranslators {
    private static final char CSV_DELIMITER = ',';
    private static final char CSV_QUOTE = '\"';
    private static final String CSV_QUOTE_STR = "\"";
    private static final String CSV_ESCAPED_QUOTE_STR = CSV_QUOTE_STR + CSV_QUOTE_STR;
    private static final char[] CSV_SEARCH_CHARS = new char[]{',', '\"', '\r', '\n'};

    private CsvTranslators() {
    }

    public static class CsvUnescaper
    extends SinglePassTranslator {
        @Override
        void translateWhole(CharSequence input, Writer out) throws IOException {
            block5: {
                block4: {
                    if (input.charAt(0) != '\"') break block4;
                    CharSequence charSequence = input;
                    if (charSequence.charAt(charSequence.length() - 1) == '\"') break block5;
                }
                out.write(input.toString());
                return;
            }
            String string = input.subSequence(1, input.length() - 1).toString();
            if (StringUtils.containsAny((CharSequence)string, CSV_SEARCH_CHARS)) {
                out.write(StringUtils.replace(string, CSV_ESCAPED_QUOTE_STR, CSV_QUOTE_STR));
                return;
            }
            out.write(input.toString());
        }
    }

    public static class CsvEscaper
    extends SinglePassTranslator {
        @Override
        void translateWhole(CharSequence input, Writer out) throws IOException {
            String string = input.toString();
            if (StringUtils.containsNone((CharSequence)string, CSV_SEARCH_CHARS)) {
                out.write(string);
                return;
            }
            out.write(34);
            out.write(StringUtils.replace(string, CSV_QUOTE_STR, CSV_ESCAPED_QUOTE_STR));
            out.write(34);
        }
    }
}

