/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Locale;
import org.joda.convert.FromString;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationFieldType;
import org.joda.time.Interval;
import org.joda.time.LocalDate;
import org.joda.time.ReadableDateTime;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.YearMonthDay;
import org.joda.time.base.BaseDateTime;
import org.joda.time.field.AbstractReadableInstantFieldProperty;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

@Deprecated
public final class DateMidnight
extends BaseDateTime
implements Serializable,
ReadableDateTime {
    private static final long serialVersionUID = 156371964018738L;

    public static DateMidnight now() {
        return new DateMidnight();
    }

    public static DateMidnight now(DateTimeZone dateTimeZone) {
        if (dateTimeZone == null) {
            throw new NullPointerException("Zone must not be null");
        }
        return new DateMidnight(dateTimeZone);
    }

    public static DateMidnight now(Chronology chronology) {
        if (chronology == null) {
            throw new NullPointerException("Chronology must not be null");
        }
        return new DateMidnight(chronology);
    }

    @FromString
    public static DateMidnight parse(String string) {
        return DateMidnight.parse(string, ISODateTimeFormat.dateTimeParser().withOffsetParsed());
    }

    public static DateMidnight parse(String string, DateTimeFormatter dateTimeFormatter) {
        return dateTimeFormatter.parseDateTime(string).toDateMidnight();
    }

    public DateMidnight() {
    }

    public DateMidnight(DateTimeZone dateTimeZone) {
        super(dateTimeZone);
    }

    public DateMidnight(Chronology chronology) {
        super(chronology);
    }

    public DateMidnight(long l2) {
        super(l2);
    }

    public DateMidnight(long l2, DateTimeZone dateTimeZone) {
        super(l2, dateTimeZone);
    }

    public DateMidnight(long l2, Chronology chronology) {
        super(l2, chronology);
    }

    public DateMidnight(Object object) {
        super(object, (Chronology)null);
    }

    public DateMidnight(Object object, DateTimeZone dateTimeZone) {
        super(object, dateTimeZone);
    }

    public DateMidnight(Object object, Chronology chronology) {
        super(object, DateTimeUtils.getChronology(chronology));
    }

    public DateMidnight(int n2, int n3, int n4) {
        super(n2, n3, n4, 0, 0, 0, 0);
    }

    public DateMidnight(int n2, int n3, int n4, DateTimeZone dateTimeZone) {
        super(n2, n3, n4, 0, 0, 0, 0, dateTimeZone);
    }

    public DateMidnight(int n2, int n3, int n4, Chronology chronology) {
        super(n2, n3, n4, 0, 0, 0, 0, chronology);
    }

    protected final long checkInstant(long l2, Chronology chronology) {
        return chronology.dayOfMonth().roundFloor(l2);
    }

    public final DateMidnight withMillis(long l2) {
        Chronology chronology = this.getChronology();
        if ((l2 = this.checkInstant(l2, chronology)) == this.getMillis()) {
            return this;
        }
        return new DateMidnight(l2, chronology);
    }

    public final DateMidnight withChronology(Chronology chronology) {
        if (chronology == this.getChronology()) {
            return this;
        }
        return new DateMidnight(this.getMillis(), chronology);
    }

    public final DateMidnight withZoneRetainFields(DateTimeZone dateTimeZone) {
        DateTimeZone dateTimeZone2;
        if ((dateTimeZone = DateTimeUtils.getZone(dateTimeZone)) == (dateTimeZone2 = DateTimeUtils.getZone(this.getZone()))) {
            return this;
        }
        long l2 = dateTimeZone2.getMillisKeepLocal(dateTimeZone, this.getMillis());
        return new DateMidnight(l2, this.getChronology().withZone(dateTimeZone));
    }

    public final DateMidnight withFields(ReadablePartial readablePartial) {
        if (readablePartial == null) {
            return this;
        }
        DateMidnight dateMidnight = this;
        return dateMidnight.withMillis(dateMidnight.getChronology().set(readablePartial, this.getMillis()));
    }

    public final DateMidnight withField(DateTimeFieldType dateTimeFieldType, int n2) {
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("Field must not be null");
        }
        long l2 = dateTimeFieldType.getField(this.getChronology()).set(this.getMillis(), n2);
        return this.withMillis(l2);
    }

    public final DateMidnight withFieldAdded(DurationFieldType durationFieldType, int n2) {
        if (durationFieldType == null) {
            throw new IllegalArgumentException("Field must not be null");
        }
        if (n2 == 0) {
            return this;
        }
        long l2 = durationFieldType.getField(this.getChronology()).add(this.getMillis(), n2);
        return this.withMillis(l2);
    }

    public final DateMidnight withDurationAdded(long l2, int n2) {
        if (l2 == 0L || n2 == 0) {
            return this;
        }
        long l3 = this.getChronology().add(this.getMillis(), l2, n2);
        return this.withMillis(l3);
    }

    public final DateMidnight withDurationAdded(ReadableDuration readableDuration, int n2) {
        if (readableDuration == null || n2 == 0) {
            return this;
        }
        return this.withDurationAdded(readableDuration.getMillis(), n2);
    }

    public final DateMidnight withPeriodAdded(ReadablePeriod readablePeriod, int n2) {
        if (readablePeriod == null || n2 == 0) {
            return this;
        }
        long l2 = this.getChronology().add(readablePeriod, this.getMillis(), n2);
        return this.withMillis(l2);
    }

    public final DateMidnight plus(long l2) {
        return this.withDurationAdded(l2, 1);
    }

    public final DateMidnight plus(ReadableDuration readableDuration) {
        return this.withDurationAdded(readableDuration, 1);
    }

    public final DateMidnight plus(ReadablePeriod readablePeriod) {
        return this.withPeriodAdded(readablePeriod, 1);
    }

    public final DateMidnight plusYears(int n2) {
        if (n2 == 0) {
            return this;
        }
        long l2 = this.getChronology().years().add(this.getMillis(), n2);
        return this.withMillis(l2);
    }

    public final DateMidnight plusMonths(int n2) {
        if (n2 == 0) {
            return this;
        }
        long l2 = this.getChronology().months().add(this.getMillis(), n2);
        return this.withMillis(l2);
    }

    public final DateMidnight plusWeeks(int n2) {
        if (n2 == 0) {
            return this;
        }
        long l2 = this.getChronology().weeks().add(this.getMillis(), n2);
        return this.withMillis(l2);
    }

    public final DateMidnight plusDays(int n2) {
        if (n2 == 0) {
            return this;
        }
        long l2 = this.getChronology().days().add(this.getMillis(), n2);
        return this.withMillis(l2);
    }

    public final DateMidnight minus(long l2) {
        return this.withDurationAdded(l2, -1);
    }

    public final DateMidnight minus(ReadableDuration readableDuration) {
        return this.withDurationAdded(readableDuration, -1);
    }

    public final DateMidnight minus(ReadablePeriod readablePeriod) {
        return this.withPeriodAdded(readablePeriod, -1);
    }

    public final DateMidnight minusYears(int n2) {
        if (n2 == 0) {
            return this;
        }
        long l2 = this.getChronology().years().subtract(this.getMillis(), n2);
        return this.withMillis(l2);
    }

    public final DateMidnight minusMonths(int n2) {
        if (n2 == 0) {
            return this;
        }
        long l2 = this.getChronology().months().subtract(this.getMillis(), n2);
        return this.withMillis(l2);
    }

    public final DateMidnight minusWeeks(int n2) {
        if (n2 == 0) {
            return this;
        }
        long l2 = this.getChronology().weeks().subtract(this.getMillis(), n2);
        return this.withMillis(l2);
    }

    public final DateMidnight minusDays(int n2) {
        if (n2 == 0) {
            return this;
        }
        long l2 = this.getChronology().days().subtract(this.getMillis(), n2);
        return this.withMillis(l2);
    }

    public final Property property(DateTimeFieldType dateTimeFieldType) {
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("The DateTimeFieldType must not be null");
        }
        DateTimeField dateTimeField = dateTimeFieldType.getField(this.getChronology());
        if (!dateTimeField.isSupported()) {
            throw new IllegalArgumentException("Field '" + dateTimeFieldType + "' is not supported");
        }
        return new Property(this, dateTimeField);
    }

    @Deprecated
    public final YearMonthDay toYearMonthDay() {
        return new YearMonthDay(this.getMillis(), this.getChronology());
    }

    public final LocalDate toLocalDate() {
        return new LocalDate(this.getMillis(), this.getChronology());
    }

    public final Interval toInterval() {
        Chronology chronology = this.getChronology();
        long l2 = this.getMillis();
        long l3 = DurationFieldType.days().getField(chronology).add(l2, 1);
        return new Interval(l2, l3, chronology);
    }

    public final DateMidnight withEra(int n2) {
        DateMidnight dateMidnight = this;
        return dateMidnight.withMillis(dateMidnight.getChronology().era().set(this.getMillis(), n2));
    }

    public final DateMidnight withCenturyOfEra(int n2) {
        DateMidnight dateMidnight = this;
        return dateMidnight.withMillis(dateMidnight.getChronology().centuryOfEra().set(this.getMillis(), n2));
    }

    public final DateMidnight withYearOfEra(int n2) {
        DateMidnight dateMidnight = this;
        return dateMidnight.withMillis(dateMidnight.getChronology().yearOfEra().set(this.getMillis(), n2));
    }

    public final DateMidnight withYearOfCentury(int n2) {
        DateMidnight dateMidnight = this;
        return dateMidnight.withMillis(dateMidnight.getChronology().yearOfCentury().set(this.getMillis(), n2));
    }

    public final DateMidnight withYear(int n2) {
        DateMidnight dateMidnight = this;
        return dateMidnight.withMillis(dateMidnight.getChronology().year().set(this.getMillis(), n2));
    }

    public final DateMidnight withWeekyear(int n2) {
        DateMidnight dateMidnight = this;
        return dateMidnight.withMillis(dateMidnight.getChronology().weekyear().set(this.getMillis(), n2));
    }

    public final DateMidnight withMonthOfYear(int n2) {
        DateMidnight dateMidnight = this;
        return dateMidnight.withMillis(dateMidnight.getChronology().monthOfYear().set(this.getMillis(), n2));
    }

    public final DateMidnight withWeekOfWeekyear(int n2) {
        DateMidnight dateMidnight = this;
        return dateMidnight.withMillis(dateMidnight.getChronology().weekOfWeekyear().set(this.getMillis(), n2));
    }

    public final DateMidnight withDayOfYear(int n2) {
        DateMidnight dateMidnight = this;
        return dateMidnight.withMillis(dateMidnight.getChronology().dayOfYear().set(this.getMillis(), n2));
    }

    public final DateMidnight withDayOfMonth(int n2) {
        DateMidnight dateMidnight = this;
        return dateMidnight.withMillis(dateMidnight.getChronology().dayOfMonth().set(this.getMillis(), n2));
    }

    public final DateMidnight withDayOfWeek(int n2) {
        DateMidnight dateMidnight = this;
        return dateMidnight.withMillis(dateMidnight.getChronology().dayOfWeek().set(this.getMillis(), n2));
    }

    public final Property era() {
        DateMidnight dateMidnight = this;
        return new Property(dateMidnight, dateMidnight.getChronology().era());
    }

    public final Property centuryOfEra() {
        DateMidnight dateMidnight = this;
        return new Property(dateMidnight, dateMidnight.getChronology().centuryOfEra());
    }

    public final Property yearOfCentury() {
        DateMidnight dateMidnight = this;
        return new Property(dateMidnight, dateMidnight.getChronology().yearOfCentury());
    }

    public final Property yearOfEra() {
        DateMidnight dateMidnight = this;
        return new Property(dateMidnight, dateMidnight.getChronology().yearOfEra());
    }

    public final Property year() {
        DateMidnight dateMidnight = this;
        return new Property(dateMidnight, dateMidnight.getChronology().year());
    }

    public final Property weekyear() {
        DateMidnight dateMidnight = this;
        return new Property(dateMidnight, dateMidnight.getChronology().weekyear());
    }

    public final Property monthOfYear() {
        DateMidnight dateMidnight = this;
        return new Property(dateMidnight, dateMidnight.getChronology().monthOfYear());
    }

    public final Property weekOfWeekyear() {
        DateMidnight dateMidnight = this;
        return new Property(dateMidnight, dateMidnight.getChronology().weekOfWeekyear());
    }

    public final Property dayOfYear() {
        DateMidnight dateMidnight = this;
        return new Property(dateMidnight, dateMidnight.getChronology().dayOfYear());
    }

    public final Property dayOfMonth() {
        DateMidnight dateMidnight = this;
        return new Property(dateMidnight, dateMidnight.getChronology().dayOfMonth());
    }

    public final Property dayOfWeek() {
        DateMidnight dateMidnight = this;
        return new Property(dateMidnight, dateMidnight.getChronology().dayOfWeek());
    }

    public static final class Property
    extends AbstractReadableInstantFieldProperty {
        private static final long serialVersionUID = 257629620L;
        private DateMidnight iInstant;
        private DateTimeField iField;

        Property(DateMidnight dateMidnight, DateTimeField dateTimeField) {
            this.iInstant = dateMidnight;
            this.iField = dateTimeField;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.writeObject(this.iInstant);
            objectOutputStream.writeObject(this.iField.getType());
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            this.iInstant = (DateMidnight)objectInputStream.readObject();
            DateTimeFieldType dateTimeFieldType = (DateTimeFieldType)objectInputStream.readObject();
            this.iField = dateTimeFieldType.getField(this.iInstant.getChronology());
        }

        public final DateTimeField getField() {
            return this.iField;
        }

        protected final long getMillis() {
            return this.iInstant.getMillis();
        }

        protected final Chronology getChronology() {
            return this.iInstant.getChronology();
        }

        public final DateMidnight getDateMidnight() {
            return this.iInstant;
        }

        public final DateMidnight addToCopy(int n2) {
            return this.iInstant.withMillis(this.iField.add(this.iInstant.getMillis(), n2));
        }

        public final DateMidnight addToCopy(long l2) {
            return this.iInstant.withMillis(this.iField.add(this.iInstant.getMillis(), l2));
        }

        public final DateMidnight addWrapFieldToCopy(int n2) {
            return this.iInstant.withMillis(this.iField.addWrapField(this.iInstant.getMillis(), n2));
        }

        public final DateMidnight setCopy(int n2) {
            return this.iInstant.withMillis(this.iField.set(this.iInstant.getMillis(), n2));
        }

        public final DateMidnight setCopy(String string, Locale locale) {
            return this.iInstant.withMillis(this.iField.set(this.iInstant.getMillis(), string, locale));
        }

        public final DateMidnight setCopy(String string) {
            return this.setCopy(string, null);
        }

        public final DateMidnight withMaximumValue() {
            Property property = this;
            return property.setCopy(property.getMaximumValue());
        }

        public final DateMidnight withMinimumValue() {
            Property property = this;
            return property.setCopy(property.getMinimumValue());
        }

        public final DateMidnight roundFloorCopy() {
            return this.iInstant.withMillis(this.iField.roundFloor(this.iInstant.getMillis()));
        }

        public final DateMidnight roundCeilingCopy() {
            return this.iInstant.withMillis(this.iField.roundCeiling(this.iInstant.getMillis()));
        }

        public final DateMidnight roundHalfFloorCopy() {
            return this.iInstant.withMillis(this.iField.roundHalfFloor(this.iInstant.getMillis()));
        }

        public final DateMidnight roundHalfCeilingCopy() {
            return this.iInstant.withMillis(this.iField.roundHalfCeiling(this.iInstant.getMillis()));
        }

        public final DateMidnight roundHalfEvenCopy() {
            return this.iInstant.withMillis(this.iField.roundHalfEven(this.iInstant.getMillis()));
        }
    }
}

