/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.Serializable;
import org.joda.convert.FromString;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.joda.time.MutableDateTime;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.base.AbstractInstant;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.convert.ConverterManager;
import org.joda.time.convert.InstantConverter;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public final class Instant
extends AbstractInstant
implements Serializable,
ReadableInstant {
    private static final long serialVersionUID = 3299096530934209741L;
    private final long iMillis;

    public static Instant now() {
        return new Instant();
    }

    @FromString
    public static Instant parse(String string) {
        return Instant.parse(string, ISODateTimeFormat.dateTimeParser());
    }

    public static Instant parse(String string, DateTimeFormatter dateTimeFormatter) {
        return dateTimeFormatter.parseDateTime(string).toInstant();
    }

    public Instant() {
        this.iMillis = DateTimeUtils.currentTimeMillis();
    }

    public Instant(long l2) {
        this.iMillis = l2;
    }

    public Instant(Object object) {
        InstantConverter instantConverter = ConverterManager.getInstance().getInstantConverter(object);
        this.iMillis = instantConverter.getInstantMillis(object, ISOChronology.getInstanceUTC());
    }

    public final Instant toInstant() {
        return this;
    }

    public final Instant withMillis(long l2) {
        if (l2 == this.iMillis) {
            return this;
        }
        return new Instant(l2);
    }

    public final Instant withDurationAdded(long l2, int n2) {
        if (l2 == 0L || n2 == 0) {
            return this;
        }
        long l3 = this.getChronology().add(this.getMillis(), l2, n2);
        return this.withMillis(l3);
    }

    public final Instant withDurationAdded(ReadableDuration readableDuration, int n2) {
        if (readableDuration == null || n2 == 0) {
            return this;
        }
        return this.withDurationAdded(readableDuration.getMillis(), n2);
    }

    public final Instant plus(long l2) {
        return this.withDurationAdded(l2, 1);
    }

    public final Instant plus(ReadableDuration readableDuration) {
        return this.withDurationAdded(readableDuration, 1);
    }

    public final Instant minus(long l2) {
        return this.withDurationAdded(l2, -1);
    }

    public final Instant minus(ReadableDuration readableDuration) {
        return this.withDurationAdded(readableDuration, -1);
    }

    public final long getMillis() {
        return this.iMillis;
    }

    public final Chronology getChronology() {
        return ISOChronology.getInstanceUTC();
    }

    public final DateTime toDateTime() {
        return new DateTime(this.getMillis(), (Chronology)ISOChronology.getInstance());
    }

    @Deprecated
    public final DateTime toDateTimeISO() {
        return this.toDateTime();
    }

    public final MutableDateTime toMutableDateTime() {
        return new MutableDateTime(this.getMillis(), (Chronology)ISOChronology.getInstance());
    }

    @Deprecated
    public final MutableDateTime toMutableDateTimeISO() {
        return this.toMutableDateTime();
    }
}

