/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.joda.convert.FromString;
import org.joda.convert.ToString;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationFieldType;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.base.BaseLocal;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.convert.ConverterManager;
import org.joda.time.convert.PartialConverter;
import org.joda.time.field.AbstractReadableInstantFieldProperty;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public final class LocalDateTime
extends BaseLocal
implements Serializable,
ReadablePartial {
    private static final long serialVersionUID = -268716875315837168L;
    private static final int YEAR = 0;
    private static final int MONTH_OF_YEAR = 1;
    private static final int DAY_OF_MONTH = 2;
    private static final int MILLIS_OF_DAY = 3;
    private final long iLocalMillis;
    private final Chronology iChronology;

    public static LocalDateTime now() {
        return new LocalDateTime();
    }

    public static LocalDateTime now(DateTimeZone dateTimeZone) {
        if (dateTimeZone == null) {
            throw new NullPointerException("Zone must not be null");
        }
        return new LocalDateTime(dateTimeZone);
    }

    public static LocalDateTime now(Chronology chronology) {
        if (chronology == null) {
            throw new NullPointerException("Chronology must not be null");
        }
        return new LocalDateTime(chronology);
    }

    @FromString
    public static LocalDateTime parse(String string) {
        return LocalDateTime.parse(string, ISODateTimeFormat.localDateOptionalTimeParser());
    }

    public static LocalDateTime parse(String string, DateTimeFormatter dateTimeFormatter) {
        return dateTimeFormatter.parseLocalDateTime(string);
    }

    public static LocalDateTime fromCalendarFields(Calendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException("The calendar must not be null");
        }
        int n2 = calendar.get(0);
        int n3 = calendar.get(1);
        return new LocalDateTime(n2 == 1 ? n3 : 1 - n3, calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14));
    }

    public static LocalDateTime fromDateFields(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        if (date.getTime() < 0L) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(date);
            return LocalDateTime.fromCalendarFields(gregorianCalendar);
        }
        return new LocalDateTime(date.getYear() + 1900, date.getMonth() + 1, date.getDate(), date.getHours(), date.getMinutes(), date.getSeconds(), ((int)(date.getTime() % 1000L) + 1000) % 1000);
    }

    public LocalDateTime() {
        this(DateTimeUtils.currentTimeMillis(), (Chronology)ISOChronology.getInstance());
    }

    public LocalDateTime(DateTimeZone dateTimeZone) {
        this(DateTimeUtils.currentTimeMillis(), (Chronology)ISOChronology.getInstance(dateTimeZone));
    }

    public LocalDateTime(Chronology chronology) {
        this(DateTimeUtils.currentTimeMillis(), chronology);
    }

    public LocalDateTime(long l2) {
        this(l2, (Chronology)ISOChronology.getInstance());
    }

    public LocalDateTime(long l2, DateTimeZone dateTimeZone) {
        this(l2, (Chronology)ISOChronology.getInstance(dateTimeZone));
    }

    public LocalDateTime(long l2, Chronology chronology) {
        long l3;
        chronology = DateTimeUtils.getChronology(chronology);
        this.iLocalMillis = l3 = chronology.getZone().getMillisKeepLocal(DateTimeZone.UTC, l2);
        this.iChronology = chronology.withUTC();
    }

    public LocalDateTime(Object object) {
        this(object, (Chronology)null);
    }

    public LocalDateTime(Object object, DateTimeZone dateTimeZone) {
        PartialConverter partialConverter = ConverterManager.getInstance().getPartialConverter(object);
        Chronology chronology = partialConverter.getChronology(object, dateTimeZone);
        chronology = DateTimeUtils.getChronology(chronology);
        this.iChronology = chronology.withUTC();
        int[] nArray = partialConverter.getPartialValues(this, object, chronology, ISODateTimeFormat.localDateOptionalTimeParser());
        this.iLocalMillis = this.iChronology.getDateTimeMillis(nArray[0], nArray[1], nArray[2], nArray[3]);
    }

    public LocalDateTime(Object object, Chronology chronology) {
        PartialConverter partialConverter = ConverterManager.getInstance().getPartialConverter(object);
        chronology = partialConverter.getChronology(object, chronology);
        chronology = DateTimeUtils.getChronology(chronology);
        this.iChronology = chronology.withUTC();
        int[] nArray = partialConverter.getPartialValues(this, object, chronology, ISODateTimeFormat.localDateOptionalTimeParser());
        this.iLocalMillis = this.iChronology.getDateTimeMillis(nArray[0], nArray[1], nArray[2], nArray[3]);
    }

    public LocalDateTime(int n2, int n3, int n4, int n5, int n6) {
        this(n2, n3, n4, n5, n6, 0, 0, ISOChronology.getInstanceUTC());
    }

    public LocalDateTime(int n2, int n3, int n4, int n5, int n6, int n7) {
        this(n2, n3, n4, n5, n6, n7, 0, ISOChronology.getInstanceUTC());
    }

    public LocalDateTime(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this(n2, n3, n4, n5, n6, n7, n8, ISOChronology.getInstanceUTC());
    }

    public LocalDateTime(int n2, int n3, int n4, int n5, int n6, int n7, int n8, Chronology chronology) {
        chronology = DateTimeUtils.getChronology(chronology).withUTC();
        long l2 = chronology.getDateTimeMillis(n2, n3, n4, n5, n6, n7, n8);
        this.iChronology = chronology;
        this.iLocalMillis = l2;
    }

    private Object readResolve() {
        if (this.iChronology == null) {
            return new LocalDateTime(this.iLocalMillis, (Chronology)ISOChronology.getInstanceUTC());
        }
        if (!DateTimeZone.UTC.equals(this.iChronology.getZone())) {
            return new LocalDateTime(this.iLocalMillis, this.iChronology.withUTC());
        }
        return this;
    }

    public final int size() {
        return 4;
    }

    protected final DateTimeField getField(int n2, Chronology chronology) {
        switch (n2) {
            case 0: {
                return chronology.year();
            }
            case 1: {
                return chronology.monthOfYear();
            }
            case 2: {
                return chronology.dayOfMonth();
            }
            case 3: {
                return chronology.millisOfDay();
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + n2);
    }

    public final int getValue(int n2) {
        switch (n2) {
            case 0: {
                return this.getChronology().year().get(this.getLocalMillis());
            }
            case 1: {
                return this.getChronology().monthOfYear().get(this.getLocalMillis());
            }
            case 2: {
                return this.getChronology().dayOfMonth().get(this.getLocalMillis());
            }
            case 3: {
                return this.getChronology().millisOfDay().get(this.getLocalMillis());
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + n2);
    }

    public final int get(DateTimeFieldType dateTimeFieldType) {
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("The DateTimeFieldType must not be null");
        }
        return dateTimeFieldType.getField(this.getChronology()).get(this.getLocalMillis());
    }

    public final boolean isSupported(DateTimeFieldType dateTimeFieldType) {
        if (dateTimeFieldType == null) {
            return false;
        }
        return dateTimeFieldType.getField(this.getChronology()).isSupported();
    }

    public final boolean isSupported(DurationFieldType durationFieldType) {
        if (durationFieldType == null) {
            return false;
        }
        return durationFieldType.getField(this.getChronology()).isSupported();
    }

    protected final long getLocalMillis() {
        return this.iLocalMillis;
    }

    public final Chronology getChronology() {
        return this.iChronology;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)object;
            if (this.iChronology.equals(localDateTime.iChronology)) {
                return this.iLocalMillis == localDateTime.iLocalMillis;
            }
        }
        return super.equals(object);
    }

    public final int compareTo(ReadablePartial readablePartial) {
        if (this == readablePartial) {
            return 0;
        }
        if (readablePartial instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)readablePartial;
            if (this.iChronology.equals(localDateTime.iChronology)) {
                if (this.iLocalMillis < localDateTime.iLocalMillis) {
                    return -1;
                }
                if (this.iLocalMillis == localDateTime.iLocalMillis) {
                    return 0;
                }
                return 1;
            }
        }
        return super.compareTo(readablePartial);
    }

    public final DateTime toDateTime() {
        return this.toDateTime((DateTimeZone)null);
    }

    public final DateTime toDateTime(DateTimeZone dateTimeZone) {
        dateTimeZone = DateTimeUtils.getZone(dateTimeZone);
        Chronology chronology = this.iChronology.withZone(dateTimeZone);
        return new DateTime(this.getYear(), this.getMonthOfYear(), this.getDayOfMonth(), this.getHourOfDay(), this.getMinuteOfHour(), this.getSecondOfMinute(), this.getMillisOfSecond(), chronology);
    }

    public final LocalDate toLocalDate() {
        return new LocalDate(this.getLocalMillis(), this.getChronology());
    }

    public final LocalTime toLocalTime() {
        return new LocalTime(this.getLocalMillis(), this.getChronology());
    }

    public final Date toDate() {
        int n2 = this.getDayOfMonth();
        Date date = new Date(this.getYear() - 1900, this.getMonthOfYear() - 1, n2, this.getHourOfDay(), this.getMinuteOfHour(), this.getSecondOfMinute());
        date.setTime(date.getTime() + (long)this.getMillisOfSecond());
        return this.correctDstTransition(date, TimeZone.getDefault());
    }

    public final Date toDate(TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.clear();
        calendar.set(this.getYear(), this.getMonthOfYear() - 1, this.getDayOfMonth(), this.getHourOfDay(), this.getMinuteOfHour(), this.getSecondOfMinute());
        Date date = calendar.getTime();
        date.setTime(date.getTime() + (long)this.getMillisOfSecond());
        return this.correctDstTransition(date, timeZone);
    }

    private Date correctDstTransition(Date date, TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(date);
        LocalDateTime localDateTime = LocalDateTime.fromCalendarFields(calendar);
        if (localDateTime.isBefore(this)) {
            while (localDateTime.isBefore(this)) {
                Calendar calendar2 = calendar;
                calendar2.setTimeInMillis(calendar2.getTimeInMillis() + 60000L);
                localDateTime = LocalDateTime.fromCalendarFields(calendar);
            }
            while (!localDateTime.isBefore(this)) {
                Calendar calendar3 = calendar;
                calendar3.setTimeInMillis(calendar3.getTimeInMillis() - 1000L);
                localDateTime = LocalDateTime.fromCalendarFields(calendar);
            }
            Calendar calendar4 = calendar;
            calendar4.setTimeInMillis(calendar4.getTimeInMillis() + 1000L);
        } else if (localDateTime.equals(this)) {
            Calendar calendar5 = Calendar.getInstance(timeZone);
            calendar5.setTimeInMillis(calendar.getTimeInMillis() - (long)timeZone.getDSTSavings());
            localDateTime = LocalDateTime.fromCalendarFields(calendar5);
            if (localDateTime.equals(this)) {
                calendar = calendar5;
            }
        }
        return calendar.getTime();
    }

    final LocalDateTime withLocalMillis(long l2) {
        if (l2 == this.getLocalMillis()) {
            return this;
        }
        return new LocalDateTime(l2, this.getChronology());
    }

    public final LocalDateTime withDate(int n2, int n3, int n4) {
        Chronology chronology = this.getChronology();
        long l2 = this.getLocalMillis();
        l2 = chronology.year().set(l2, n2);
        l2 = chronology.monthOfYear().set(l2, n3);
        l2 = chronology.dayOfMonth().set(l2, n4);
        return this.withLocalMillis(l2);
    }

    public final LocalDateTime withTime(int n2, int n3, int n4, int n5) {
        Chronology chronology = this.getChronology();
        long l2 = this.getLocalMillis();
        l2 = chronology.hourOfDay().set(l2, n2);
        l2 = chronology.minuteOfHour().set(l2, n3);
        l2 = chronology.secondOfMinute().set(l2, n4);
        l2 = chronology.millisOfSecond().set(l2, n5);
        return this.withLocalMillis(l2);
    }

    public final LocalDateTime withFields(ReadablePartial readablePartial) {
        if (readablePartial == null) {
            return this;
        }
        LocalDateTime localDateTime = this;
        return localDateTime.withLocalMillis(localDateTime.getChronology().set(readablePartial, this.getLocalMillis()));
    }

    public final LocalDateTime withField(DateTimeFieldType dateTimeFieldType, int n2) {
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("Field must not be null");
        }
        long l2 = dateTimeFieldType.getField(this.getChronology()).set(this.getLocalMillis(), n2);
        return this.withLocalMillis(l2);
    }

    public final LocalDateTime withFieldAdded(DurationFieldType durationFieldType, int n2) {
        if (durationFieldType == null) {
            throw new IllegalArgumentException("Field must not be null");
        }
        if (n2 == 0) {
            return this;
        }
        long l2 = durationFieldType.getField(this.getChronology()).add(this.getLocalMillis(), n2);
        return this.withLocalMillis(l2);
    }

    public final LocalDateTime withDurationAdded(ReadableDuration readableDuration, int n2) {
        if (readableDuration == null || n2 == 0) {
            return this;
        }
        long l2 = this.getChronology().add(this.getLocalMillis(), readableDuration.getMillis(), n2);
        return this.withLocalMillis(l2);
    }

    public final LocalDateTime withPeriodAdded(ReadablePeriod readablePeriod, int n2) {
        if (readablePeriod == null || n2 == 0) {
            return this;
        }
        long l2 = this.getChronology().add(readablePeriod, this.getLocalMillis(), n2);
        return this.withLocalMillis(l2);
    }

    public final LocalDateTime plus(ReadableDuration readableDuration) {
        return this.withDurationAdded(readableDuration, 1);
    }

    public final LocalDateTime plus(ReadablePeriod readablePeriod) {
        return this.withPeriodAdded(readablePeriod, 1);
    }

    public final LocalDateTime plusYears(int n2) {
        if (n2 == 0) {
            return this;
        }
        long l2 = this.getChronology().years().add(this.getLocalMillis(), n2);
        return this.withLocalMillis(l2);
    }

    public final LocalDateTime plusMonths(int n2) {
        if (n2 == 0) {
            return this;
        }
        long l2 = this.getChronology().months().add(this.getLocalMillis(), n2);
        return this.withLocalMillis(l2);
    }

    public final LocalDateTime plusWeeks(int n2) {
        if (n2 == 0) {
            return this;
        }
        long l2 = this.getChronology().weeks().add(this.getLocalMillis(), n2);
        return this.withLocalMillis(l2);
    }

    public final LocalDateTime plusDays(int n2) {
        if (n2 == 0) {
            return this;
        }
        long l2 = this.getChronology().days().add(this.getLocalMillis(), n2);
        return this.withLocalMillis(l2);
    }

    public final LocalDateTime plusHours(int n2) {
        if (n2 == 0) {
            return this;
        }
        long l2 = this.getChronology().hours().add(this.getLocalMillis(), n2);
        return this.withLocalMillis(l2);
    }

    public final LocalDateTime plusMinutes(int n2) {
        if (n2 == 0) {
            return this;
        }
        long l2 = this.getChronology().minutes().add(this.getLocalMillis(), n2);
        return this.withLocalMillis(l2);
    }

    public final LocalDateTime plusSeconds(int n2) {
        if (n2 == 0) {
            return this;
        }
        long l2 = this.getChronology().seconds().add(this.getLocalMillis(), n2);
        return this.withLocalMillis(l2);
    }

    public final LocalDateTime plusMillis(int n2) {
        if (n2 == 0) {
            return this;
        }
        long l2 = this.getChronology().millis().add(this.getLocalMillis(), n2);
        return this.withLocalMillis(l2);
    }

    public final LocalDateTime minus(ReadableDuration readableDuration) {
        return this.withDurationAdded(readableDuration, -1);
    }

    public final LocalDateTime minus(ReadablePeriod readablePeriod) {
        return this.withPeriodAdded(readablePeriod, -1);
    }

    public final LocalDateTime minusYears(int n2) {
        if (n2 == 0) {
            return this;
        }
        long l2 = this.getChronology().years().subtract(this.getLocalMillis(), n2);
        return this.withLocalMillis(l2);
    }

    public final LocalDateTime minusMonths(int n2) {
        if (n2 == 0) {
            return this;
        }
        long l2 = this.getChronology().months().subtract(this.getLocalMillis(), n2);
        return this.withLocalMillis(l2);
    }

    public final LocalDateTime minusWeeks(int n2) {
        if (n2 == 0) {
            return this;
        }
        long l2 = this.getChronology().weeks().subtract(this.getLocalMillis(), n2);
        return this.withLocalMillis(l2);
    }

    public final LocalDateTime minusDays(int n2) {
        if (n2 == 0) {
            return this;
        }
        long l2 = this.getChronology().days().subtract(this.getLocalMillis(), n2);
        return this.withLocalMillis(l2);
    }

    public final LocalDateTime minusHours(int n2) {
        if (n2 == 0) {
            return this;
        }
        long l2 = this.getChronology().hours().subtract(this.getLocalMillis(), n2);
        return this.withLocalMillis(l2);
    }

    public final LocalDateTime minusMinutes(int n2) {
        if (n2 == 0) {
            return this;
        }
        long l2 = this.getChronology().minutes().subtract(this.getLocalMillis(), n2);
        return this.withLocalMillis(l2);
    }

    public final LocalDateTime minusSeconds(int n2) {
        if (n2 == 0) {
            return this;
        }
        long l2 = this.getChronology().seconds().subtract(this.getLocalMillis(), n2);
        return this.withLocalMillis(l2);
    }

    public final LocalDateTime minusMillis(int n2) {
        if (n2 == 0) {
            return this;
        }
        long l2 = this.getChronology().millis().subtract(this.getLocalMillis(), n2);
        return this.withLocalMillis(l2);
    }

    public final Property property(DateTimeFieldType dateTimeFieldType) {
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("The DateTimeFieldType must not be null");
        }
        if (!this.isSupported(dateTimeFieldType)) {
            throw new IllegalArgumentException("Field '" + dateTimeFieldType + "' is not supported");
        }
        return new Property(this, dateTimeFieldType.getField(this.getChronology()));
    }

    public final int getEra() {
        return this.getChronology().era().get(this.getLocalMillis());
    }

    public final int getCenturyOfEra() {
        return this.getChronology().centuryOfEra().get(this.getLocalMillis());
    }

    public final int getYearOfEra() {
        return this.getChronology().yearOfEra().get(this.getLocalMillis());
    }

    public final int getYearOfCentury() {
        return this.getChronology().yearOfCentury().get(this.getLocalMillis());
    }

    public final int getYear() {
        return this.getChronology().year().get(this.getLocalMillis());
    }

    public final int getWeekyear() {
        return this.getChronology().weekyear().get(this.getLocalMillis());
    }

    public final int getMonthOfYear() {
        return this.getChronology().monthOfYear().get(this.getLocalMillis());
    }

    public final int getWeekOfWeekyear() {
        return this.getChronology().weekOfWeekyear().get(this.getLocalMillis());
    }

    public final int getDayOfYear() {
        return this.getChronology().dayOfYear().get(this.getLocalMillis());
    }

    public final int getDayOfMonth() {
        return this.getChronology().dayOfMonth().get(this.getLocalMillis());
    }

    public final int getDayOfWeek() {
        return this.getChronology().dayOfWeek().get(this.getLocalMillis());
    }

    public final int getHourOfDay() {
        return this.getChronology().hourOfDay().get(this.getLocalMillis());
    }

    public final int getMinuteOfHour() {
        return this.getChronology().minuteOfHour().get(this.getLocalMillis());
    }

    public final int getSecondOfMinute() {
        return this.getChronology().secondOfMinute().get(this.getLocalMillis());
    }

    public final int getMillisOfSecond() {
        return this.getChronology().millisOfSecond().get(this.getLocalMillis());
    }

    public final int getMillisOfDay() {
        return this.getChronology().millisOfDay().get(this.getLocalMillis());
    }

    public final LocalDateTime withEra(int n2) {
        LocalDateTime localDateTime = this;
        return localDateTime.withLocalMillis(localDateTime.getChronology().era().set(this.getLocalMillis(), n2));
    }

    public final LocalDateTime withCenturyOfEra(int n2) {
        LocalDateTime localDateTime = this;
        return localDateTime.withLocalMillis(localDateTime.getChronology().centuryOfEra().set(this.getLocalMillis(), n2));
    }

    public final LocalDateTime withYearOfEra(int n2) {
        LocalDateTime localDateTime = this;
        return localDateTime.withLocalMillis(localDateTime.getChronology().yearOfEra().set(this.getLocalMillis(), n2));
    }

    public final LocalDateTime withYearOfCentury(int n2) {
        LocalDateTime localDateTime = this;
        return localDateTime.withLocalMillis(localDateTime.getChronology().yearOfCentury().set(this.getLocalMillis(), n2));
    }

    public final LocalDateTime withYear(int n2) {
        LocalDateTime localDateTime = this;
        return localDateTime.withLocalMillis(localDateTime.getChronology().year().set(this.getLocalMillis(), n2));
    }

    public final LocalDateTime withWeekyear(int n2) {
        LocalDateTime localDateTime = this;
        return localDateTime.withLocalMillis(localDateTime.getChronology().weekyear().set(this.getLocalMillis(), n2));
    }

    public final LocalDateTime withMonthOfYear(int n2) {
        LocalDateTime localDateTime = this;
        return localDateTime.withLocalMillis(localDateTime.getChronology().monthOfYear().set(this.getLocalMillis(), n2));
    }

    public final LocalDateTime withWeekOfWeekyear(int n2) {
        LocalDateTime localDateTime = this;
        return localDateTime.withLocalMillis(localDateTime.getChronology().weekOfWeekyear().set(this.getLocalMillis(), n2));
    }

    public final LocalDateTime withDayOfYear(int n2) {
        LocalDateTime localDateTime = this;
        return localDateTime.withLocalMillis(localDateTime.getChronology().dayOfYear().set(this.getLocalMillis(), n2));
    }

    public final LocalDateTime withDayOfMonth(int n2) {
        LocalDateTime localDateTime = this;
        return localDateTime.withLocalMillis(localDateTime.getChronology().dayOfMonth().set(this.getLocalMillis(), n2));
    }

    public final LocalDateTime withDayOfWeek(int n2) {
        LocalDateTime localDateTime = this;
        return localDateTime.withLocalMillis(localDateTime.getChronology().dayOfWeek().set(this.getLocalMillis(), n2));
    }

    public final LocalDateTime withHourOfDay(int n2) {
        LocalDateTime localDateTime = this;
        return localDateTime.withLocalMillis(localDateTime.getChronology().hourOfDay().set(this.getLocalMillis(), n2));
    }

    public final LocalDateTime withMinuteOfHour(int n2) {
        LocalDateTime localDateTime = this;
        return localDateTime.withLocalMillis(localDateTime.getChronology().minuteOfHour().set(this.getLocalMillis(), n2));
    }

    public final LocalDateTime withSecondOfMinute(int n2) {
        LocalDateTime localDateTime = this;
        return localDateTime.withLocalMillis(localDateTime.getChronology().secondOfMinute().set(this.getLocalMillis(), n2));
    }

    public final LocalDateTime withMillisOfSecond(int n2) {
        LocalDateTime localDateTime = this;
        return localDateTime.withLocalMillis(localDateTime.getChronology().millisOfSecond().set(this.getLocalMillis(), n2));
    }

    public final LocalDateTime withMillisOfDay(int n2) {
        LocalDateTime localDateTime = this;
        return localDateTime.withLocalMillis(localDateTime.getChronology().millisOfDay().set(this.getLocalMillis(), n2));
    }

    public final Property era() {
        LocalDateTime localDateTime = this;
        return new Property(localDateTime, localDateTime.getChronology().era());
    }

    public final Property centuryOfEra() {
        LocalDateTime localDateTime = this;
        return new Property(localDateTime, localDateTime.getChronology().centuryOfEra());
    }

    public final Property yearOfCentury() {
        LocalDateTime localDateTime = this;
        return new Property(localDateTime, localDateTime.getChronology().yearOfCentury());
    }

    public final Property yearOfEra() {
        LocalDateTime localDateTime = this;
        return new Property(localDateTime, localDateTime.getChronology().yearOfEra());
    }

    public final Property year() {
        LocalDateTime localDateTime = this;
        return new Property(localDateTime, localDateTime.getChronology().year());
    }

    public final Property weekyear() {
        LocalDateTime localDateTime = this;
        return new Property(localDateTime, localDateTime.getChronology().weekyear());
    }

    public final Property monthOfYear() {
        LocalDateTime localDateTime = this;
        return new Property(localDateTime, localDateTime.getChronology().monthOfYear());
    }

    public final Property weekOfWeekyear() {
        LocalDateTime localDateTime = this;
        return new Property(localDateTime, localDateTime.getChronology().weekOfWeekyear());
    }

    public final Property dayOfYear() {
        LocalDateTime localDateTime = this;
        return new Property(localDateTime, localDateTime.getChronology().dayOfYear());
    }

    public final Property dayOfMonth() {
        LocalDateTime localDateTime = this;
        return new Property(localDateTime, localDateTime.getChronology().dayOfMonth());
    }

    public final Property dayOfWeek() {
        LocalDateTime localDateTime = this;
        return new Property(localDateTime, localDateTime.getChronology().dayOfWeek());
    }

    public final Property hourOfDay() {
        LocalDateTime localDateTime = this;
        return new Property(localDateTime, localDateTime.getChronology().hourOfDay());
    }

    public final Property minuteOfHour() {
        LocalDateTime localDateTime = this;
        return new Property(localDateTime, localDateTime.getChronology().minuteOfHour());
    }

    public final Property secondOfMinute() {
        LocalDateTime localDateTime = this;
        return new Property(localDateTime, localDateTime.getChronology().secondOfMinute());
    }

    public final Property millisOfSecond() {
        LocalDateTime localDateTime = this;
        return new Property(localDateTime, localDateTime.getChronology().millisOfSecond());
    }

    public final Property millisOfDay() {
        LocalDateTime localDateTime = this;
        return new Property(localDateTime, localDateTime.getChronology().millisOfDay());
    }

    @ToString
    public final String toString() {
        return ISODateTimeFormat.dateTime().print(this);
    }

    public final String toString(String string) {
        if (string == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern(string).print(this);
    }

    public final String toString(String string, Locale locale) throws IllegalArgumentException {
        if (string == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern(string).withLocale(locale).print(this);
    }

    public static final class Property
    extends AbstractReadableInstantFieldProperty {
        private static final long serialVersionUID = -358138762846288L;
        private transient LocalDateTime iInstant;
        private transient DateTimeField iField;

        Property(LocalDateTime localDateTime, DateTimeField dateTimeField) {
            this.iInstant = localDateTime;
            this.iField = dateTimeField;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.writeObject(this.iInstant);
            objectOutputStream.writeObject(this.iField.getType());
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            this.iInstant = (LocalDateTime)objectInputStream.readObject();
            DateTimeFieldType dateTimeFieldType = (DateTimeFieldType)objectInputStream.readObject();
            this.iField = dateTimeFieldType.getField(this.iInstant.getChronology());
        }

        public final DateTimeField getField() {
            return this.iField;
        }

        protected final long getMillis() {
            return this.iInstant.getLocalMillis();
        }

        protected final Chronology getChronology() {
            return this.iInstant.getChronology();
        }

        public final LocalDateTime getLocalDateTime() {
            return this.iInstant;
        }

        public final LocalDateTime addToCopy(int n2) {
            return this.iInstant.withLocalMillis(this.iField.add(this.iInstant.getLocalMillis(), n2));
        }

        public final LocalDateTime addToCopy(long l2) {
            return this.iInstant.withLocalMillis(this.iField.add(this.iInstant.getLocalMillis(), l2));
        }

        public final LocalDateTime addWrapFieldToCopy(int n2) {
            return this.iInstant.withLocalMillis(this.iField.addWrapField(this.iInstant.getLocalMillis(), n2));
        }

        public final LocalDateTime setCopy(int n2) {
            return this.iInstant.withLocalMillis(this.iField.set(this.iInstant.getLocalMillis(), n2));
        }

        public final LocalDateTime setCopy(String string, Locale locale) {
            return this.iInstant.withLocalMillis(this.iField.set(this.iInstant.getLocalMillis(), string, locale));
        }

        public final LocalDateTime setCopy(String string) {
            return this.setCopy(string, null);
        }

        public final LocalDateTime withMaximumValue() {
            Property property = this;
            return property.setCopy(property.getMaximumValue());
        }

        public final LocalDateTime withMinimumValue() {
            Property property = this;
            return property.setCopy(property.getMinimumValue());
        }

        public final LocalDateTime roundFloorCopy() {
            return this.iInstant.withLocalMillis(this.iField.roundFloor(this.iInstant.getLocalMillis()));
        }

        public final LocalDateTime roundCeilingCopy() {
            return this.iInstant.withLocalMillis(this.iField.roundCeiling(this.iInstant.getLocalMillis()));
        }

        public final LocalDateTime roundHalfFloorCopy() {
            return this.iInstant.withLocalMillis(this.iField.roundHalfFloor(this.iInstant.getLocalMillis()));
        }

        public final LocalDateTime roundHalfCeilingCopy() {
            return this.iInstant.withLocalMillis(this.iField.roundHalfCeiling(this.iInstant.getLocalMillis()));
        }

        public final LocalDateTime roundHalfEvenCopy() {
            return this.iInstant.withLocalMillis(this.iField.roundHalfEven(this.iInstant.getLocalMillis()));
        }
    }
}

