/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import org.joda.time.Chronology;
import org.joda.time.chrono.BasicChronology;

abstract class BasicFixedMonthChronology
extends BasicChronology {
    private static final long serialVersionUID = 261387371998L;
    static final int MONTH_LENGTH = 30;
    static final long MILLIS_PER_YEAR = 31557600000L;
    static final long MILLIS_PER_MONTH = 2592000000L;

    BasicFixedMonthChronology(Chronology chronology, Object object, int n2) {
        super(chronology, object, n2);
    }

    long setYear(long l2, int n2) {
        int n3 = this.getYear(l2);
        int n4 = this.getDayOfYear(l2, n3);
        int n5 = this.getMillisOfDay(l2);
        if (n4 > 365 && !this.isLeapYear(n2)) {
            --n4;
        }
        l2 = this.getYearMonthDayMillis(n2, 1, n4);
        return l2 += (long)n5;
    }

    long getYearDifference(long l2, long l3) {
        int n2 = this.getYear(l2);
        int n3 = this.getYear(l3);
        long l4 = l2 - this.getYearMillis(n2);
        long l5 = l3 - this.getYearMillis(n3);
        int n4 = n2 - n3;
        if (l4 < l5) {
            --n4;
        }
        return n4;
    }

    long getTotalMillisByYearMonth(int n2, int n3) {
        return (long)(n3 - 1) * 2592000000L;
    }

    int getDayOfMonth(long l2) {
        return (this.getDayOfYear(l2) - 1) % 30 + 1;
    }

    boolean isLeapYear(int n2) {
        return (n2 & 3) == 3;
    }

    int getDaysInYearMonth(int n2, int n3) {
        if (n3 != 13) {
            return 30;
        }
        if (this.isLeapYear(n2)) {
            return 6;
        }
        return 5;
    }

    int getDaysInMonthMax() {
        return 30;
    }

    int getDaysInMonthMax(int n2) {
        if (n2 != 13) {
            return 30;
        }
        return 6;
    }

    int getMonthOfYear(long l2) {
        return (this.getDayOfYear(l2) - 1) / 30 + 1;
    }

    int getMonthOfYear(long l2, int n2) {
        long l3 = (l2 - this.getYearMillis(n2)) / 2592000000L;
        return (int)l3 + 1;
    }

    int getMaxMonth() {
        return 13;
    }

    long getAverageMillisPerYear() {
        return 31557600000L;
    }

    long getAverageMillisPerYearDividedByTwo() {
        return 15778800000L;
    }

    long getAverageMillisPerMonth() {
        return 2592000000L;
    }
}

