/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.text.DateFormatSymbols;
import java.util.Locale;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.IllegalFieldValueException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GJLocaleSymbols {
    private static ConcurrentMap<Locale, GJLocaleSymbols> cCache = new ConcurrentHashMap<Locale, GJLocaleSymbols>();
    private final String[] iEras;
    private final String[] iDaysOfWeek;
    private final String[] iShortDaysOfWeek;
    private final String[] iMonths;
    private final String[] iShortMonths;
    private final String[] iHalfday;
    private final TreeMap<String, Integer> iParseEras;
    private final TreeMap<String, Integer> iParseDaysOfWeek;
    private final TreeMap<String, Integer> iParseMonths;
    private final int iMaxEraLength;
    private final int iMaxDayOfWeekLength;
    private final int iMaxShortDayOfWeekLength;
    private final int iMaxMonthLength;
    private final int iMaxShortMonthLength;
    private final int iMaxHalfdayLength;

    static GJLocaleSymbols forLocale(Locale locale) {
        GJLocaleSymbols gJLocaleSymbols;
        GJLocaleSymbols gJLocaleSymbols2;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((gJLocaleSymbols2 = (GJLocaleSymbols)cCache.get(locale)) == null && (gJLocaleSymbols = cCache.putIfAbsent(locale, gJLocaleSymbols2 = new GJLocaleSymbols(locale))) != null) {
            gJLocaleSymbols2 = gJLocaleSymbols;
        }
        return gJLocaleSymbols2;
    }

    private static String[] realignMonths(String[] stringArray) {
        String[] stringArray2 = new String[13];
        for (int i2 = 1; i2 < 13; ++i2) {
            stringArray2[i2] = stringArray[i2 - 1];
        }
        return stringArray2;
    }

    private static String[] realignDaysOfWeek(String[] stringArray) {
        String[] stringArray2 = new String[8];
        for (int i2 = 1; i2 < 8; ++i2) {
            stringArray2[i2] = stringArray[i2 < 7 ? i2 + 1 : 1];
        }
        return stringArray2;
    }

    private static void addSymbols(TreeMap<String, Integer> treeMap, String[] stringArray, Integer[] integerArray) {
        int n2 = stringArray.length;
        while (--n2 >= 0) {
            String string = stringArray[n2];
            if (string == null) continue;
            treeMap.put(string, integerArray[n2]);
        }
    }

    private static void addNumerals(TreeMap<String, Integer> treeMap, int n2, int n3, Integer[] integerArray) {
        for (int i2 = n2; i2 <= n3; ++i2) {
            treeMap.put(String.valueOf(i2).intern(), integerArray[i2]);
        }
    }

    private static int maxLength(String[] stringArray) {
        int n2 = 0;
        int n3 = stringArray.length;
        while (--n3 >= 0) {
            int n4;
            String string = stringArray[n3];
            if (string == null || (n4 = string.length()) <= n2) continue;
            n2 = n4;
        }
        return n2;
    }

    private GJLocaleSymbols(Locale locale) {
        DateFormatSymbols dateFormatSymbols = DateTimeUtils.getDateFormatSymbols(locale);
        this.iEras = dateFormatSymbols.getEras();
        this.iDaysOfWeek = GJLocaleSymbols.realignDaysOfWeek(dateFormatSymbols.getWeekdays());
        this.iShortDaysOfWeek = GJLocaleSymbols.realignDaysOfWeek(dateFormatSymbols.getShortWeekdays());
        this.iMonths = GJLocaleSymbols.realignMonths(dateFormatSymbols.getMonths());
        this.iShortMonths = GJLocaleSymbols.realignMonths(dateFormatSymbols.getShortMonths());
        this.iHalfday = dateFormatSymbols.getAmPmStrings();
        Integer[] integerArray = new Integer[13];
        int n2 = 0;
        while (n2 < 13) {
            int n3 = n2++;
            integerArray[n3] = n3;
        }
        this.iParseEras = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        GJLocaleSymbols.addSymbols(this.iParseEras, this.iEras, integerArray);
        if ("en".equals(locale.getLanguage())) {
            this.iParseEras.put("BCE", integerArray[0]);
            this.iParseEras.put("CE", integerArray[1]);
        }
        this.iParseDaysOfWeek = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        GJLocaleSymbols.addSymbols(this.iParseDaysOfWeek, this.iDaysOfWeek, integerArray);
        GJLocaleSymbols.addSymbols(this.iParseDaysOfWeek, this.iShortDaysOfWeek, integerArray);
        GJLocaleSymbols.addNumerals(this.iParseDaysOfWeek, 1, 7, integerArray);
        this.iParseMonths = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        GJLocaleSymbols.addSymbols(this.iParseMonths, this.iMonths, integerArray);
        GJLocaleSymbols.addSymbols(this.iParseMonths, this.iShortMonths, integerArray);
        GJLocaleSymbols.addNumerals(this.iParseMonths, 1, 12, integerArray);
        this.iMaxEraLength = GJLocaleSymbols.maxLength(this.iEras);
        this.iMaxDayOfWeekLength = GJLocaleSymbols.maxLength(this.iDaysOfWeek);
        this.iMaxShortDayOfWeekLength = GJLocaleSymbols.maxLength(this.iShortDaysOfWeek);
        this.iMaxMonthLength = GJLocaleSymbols.maxLength(this.iMonths);
        this.iMaxShortMonthLength = GJLocaleSymbols.maxLength(this.iShortMonths);
        this.iMaxHalfdayLength = GJLocaleSymbols.maxLength(this.iHalfday);
    }

    public String eraValueToText(int n2) {
        return this.iEras[n2];
    }

    public int eraTextToValue(String string) {
        Integer n2 = this.iParseEras.get(string);
        if (n2 != null) {
            return n2;
        }
        throw new IllegalFieldValueException(DateTimeFieldType.era(), string);
    }

    public int getEraMaxTextLength() {
        return this.iMaxEraLength;
    }

    public String monthOfYearValueToText(int n2) {
        return this.iMonths[n2];
    }

    public String monthOfYearValueToShortText(int n2) {
        return this.iShortMonths[n2];
    }

    public int monthOfYearTextToValue(String string) {
        Integer n2 = this.iParseMonths.get(string);
        if (n2 != null) {
            return n2;
        }
        throw new IllegalFieldValueException(DateTimeFieldType.monthOfYear(), string);
    }

    public int getMonthMaxTextLength() {
        return this.iMaxMonthLength;
    }

    public int getMonthMaxShortTextLength() {
        return this.iMaxShortMonthLength;
    }

    public String dayOfWeekValueToText(int n2) {
        return this.iDaysOfWeek[n2];
    }

    public String dayOfWeekValueToShortText(int n2) {
        return this.iShortDaysOfWeek[n2];
    }

    public int dayOfWeekTextToValue(String string) {
        Integer n2 = this.iParseDaysOfWeek.get(string);
        if (n2 != null) {
            return n2;
        }
        throw new IllegalFieldValueException(DateTimeFieldType.dayOfWeek(), string);
    }

    public int getDayOfWeekMaxTextLength() {
        return this.iMaxDayOfWeekLength;
    }

    public int getDayOfWeekMaxShortTextLength() {
        return this.iMaxShortDayOfWeekLength;
    }

    public String halfdayValueToText(int n2) {
        return this.iHalfday[n2];
    }

    public int halfdayTextToValue(String string) {
        String[] stringArray = this.iHalfday;
        int n2 = this.iHalfday.length;
        while (--n2 >= 0) {
            if (!stringArray[n2].equalsIgnoreCase(string)) continue;
            return n2;
        }
        throw new IllegalFieldValueException(DateTimeFieldType.halfdayOfDay(), string);
    }

    public int getHalfdayMaxTextLength() {
        return this.iMaxHalfdayLength;
    }
}

