/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import java.nio.charset.Charset;
import org.tensorflow.DataType;
import org.tensorflow.Graph;
import org.tensorflow.Operation;
import org.tensorflow.Output;
import org.tensorflow.Shape;
import org.tensorflow.Tensor;

public final class OperationBuilder {
    private long unsafeNativeHandle;
    private Graph graph;

    OperationBuilder(Graph graph, String type, String name) {
        this.graph = graph;
        try (Graph.Reference reference = graph.ref();){
            this.unsafeNativeHandle = OperationBuilder.allocate(reference.nativeHandle(), type, name);
            return;
        }
    }

    public final Operation build() {
        try (Graph.Reference reference = this.graph.ref();){
            Operation operation = new Operation(this.graph, OperationBuilder.finish(this.unsafeNativeHandle));
            this.unsafeNativeHandle = 0L;
            Operation operation2 = operation;
            return operation2;
        }
    }

    public final OperationBuilder addInput(Output<?> input) {
        try (Graph.Reference reference = this.graph.ref();){
            OperationBuilder.addInput(this.unsafeNativeHandle, input.op().getUnsafeNativeHandle(), input.index());
        }
        return this;
    }

    public final OperationBuilder addControlInput(Operation control) {
        try (Graph.Reference reference = this.graph.ref();){
            OperationBuilder.addControlInput(this.unsafeNativeHandle, control.getUnsafeNativeHandle());
        }
        return this;
    }

    public final OperationBuilder addInputList(Output<?>[] inputs) {
        try (Graph.Reference reference = this.graph.ref();){
            long[] lArray = new long[inputs.length];
            int[] nArray = new int[inputs.length];
            for (int i2 = 0; i2 < inputs.length; ++i2) {
                lArray[i2] = inputs[i2].op().getUnsafeNativeHandle();
                nArray[i2] = inputs[i2].index();
            }
            OperationBuilder.addInputList(this.unsafeNativeHandle, lArray, nArray);
        }
        return this;
    }

    public final OperationBuilder setDevice(String device) {
        try (Graph.Reference reference = this.graph.ref();){
            OperationBuilder.setDevice(this.unsafeNativeHandle, device);
        }
        return this;
    }

    public final OperationBuilder setAttr(String name, String value) {
        this.setAttr(name, value.getBytes(Charset.forName("UTF-8")));
        return this;
    }

    public final OperationBuilder setAttr(String name, byte[] value) {
        try (Graph.Reference reference = this.graph.ref();){
            OperationBuilder.setAttrString(this.unsafeNativeHandle, name, value);
        }
        return this;
    }

    public final OperationBuilder setAttr(String name, long value) {
        try (Graph.Reference reference = this.graph.ref();){
            OperationBuilder.setAttrInt(this.unsafeNativeHandle, name, value);
        }
        return this;
    }

    public final OperationBuilder setAttr(String name, long[] value) {
        try (Graph.Reference reference = this.graph.ref();){
            OperationBuilder.setAttrIntList(this.unsafeNativeHandle, name, value);
        }
        return this;
    }

    public final OperationBuilder setAttr(String name, float value) {
        try (Graph.Reference reference = this.graph.ref();){
            OperationBuilder.setAttrFloat(this.unsafeNativeHandle, name, value);
        }
        return this;
    }

    public final OperationBuilder setAttr(String name, float[] value) {
        try (Graph.Reference reference = this.graph.ref();){
            OperationBuilder.setAttrFloatList(this.unsafeNativeHandle, name, value);
        }
        return this;
    }

    public final OperationBuilder setAttr(String name, boolean value) {
        try (Graph.Reference reference = this.graph.ref();){
            OperationBuilder.setAttrBool(this.unsafeNativeHandle, name, value);
        }
        return this;
    }

    public final OperationBuilder setAttr(String name, boolean[] value) {
        try (Graph.Reference reference = this.graph.ref();){
            OperationBuilder.setAttrBoolList(this.unsafeNativeHandle, name, value);
        }
        return this;
    }

    public final OperationBuilder setAttr(String name, DataType value) {
        try (Graph.Reference reference = this.graph.ref();){
            OperationBuilder.setAttrType(this.unsafeNativeHandle, name, value.c());
        }
        return this;
    }

    public final OperationBuilder setAttr(String name, DataType[] value) {
        int[] nArray = new int[value.length];
        for (int i2 = 0; i2 < value.length; ++i2) {
            nArray[i2] = value[i2].c();
        }
        try (Graph.Reference reference = this.graph.ref();){
            OperationBuilder.setAttrTypeList(this.unsafeNativeHandle, name, nArray);
        }
        return this;
    }

    public final OperationBuilder setAttr(String name, Tensor<?> value) {
        try (Graph.Reference reference = this.graph.ref();){
            OperationBuilder.setAttrTensor(this.unsafeNativeHandle, name, value.getNativeHandle());
        }
        return this;
    }

    public final OperationBuilder setAttr(String name, Tensor<?>[] value) {
        long[] lArray = new long[value.length];
        int n2 = 0;
        Object object = value;
        int n3 = value.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            Tensor<?> tensor = object[i2];
            lArray[n2++] = tensor.getNativeHandle();
        }
        object = this.graph.ref();
        try {
            OperationBuilder.setAttrTensorList(this.unsafeNativeHandle, name, lArray);
        }
        finally {
            ((Graph.Reference)object).close();
        }
        return this;
    }

    public final OperationBuilder setAttr(String name, Shape value) {
        try (Graph.Reference reference = this.graph.ref();){
            OperationBuilder.setAttrShape(this.unsafeNativeHandle, name, value.asArray(), value.numDimensions());
        }
        return this;
    }

    public final OperationBuilder setAttr(String name, Shape[] value) {
        int n2;
        int[] nArray = new int[value.length];
        int n3 = 0;
        for (int i2 = 0; i2 < value.length; ++i2) {
            nArray[i2] = n2 = value[i2].numDimensions();
            if (n2 <= 0) continue;
            n3 += n2;
        }
        long[] lArray = new long[n3];
        n2 = 0;
        Object object = value;
        int n4 = value.length;
        for (int i3 = 0; i3 < n4; ++i3) {
            Shape shape = object[i3];
            if (shape.numDimensions() <= 0) continue;
            for (long l2 : shape.asArray()) {
                lArray[n2++] = l2;
            }
        }
        object = this.graph.ref();
        try {
            OperationBuilder.setAttrShapeList(this.unsafeNativeHandle, name, lArray, nArray);
        }
        finally {
            ((Graph.Reference)object).close();
        }
        return this;
    }

    public final OperationBuilder setAttr(String name, String[] value) {
        Charset charset = Charset.forName("UTF-8");
        Object[] objectArray = new Object[value.length];
        for (int i2 = 0; i2 < value.length; ++i2) {
            objectArray[i2] = value[i2].getBytes(charset);
        }
        try (Graph.Reference reference = this.graph.ref();){
            OperationBuilder.setAttrStringList(this.unsafeNativeHandle, name, objectArray);
        }
        return this;
    }

    private static native long allocate(long var0, String var2, String var3);

    private static native long finish(long var0);

    private static native void addInput(long var0, long var2, int var4);

    private static native void addInputList(long var0, long[] var2, int[] var3);

    private static native void addControlInput(long var0, long var2);

    private static native void setDevice(long var0, String var2);

    private static native void setAttrString(long var0, String var2, byte[] var3);

    private static native void setAttrInt(long var0, String var2, long var3);

    private static native void setAttrIntList(long var0, String var2, long[] var3);

    private static native void setAttrFloat(long var0, String var2, float var3);

    private static native void setAttrFloatList(long var0, String var2, float[] var3);

    private static native void setAttrBool(long var0, String var2, boolean var3);

    private static native void setAttrBoolList(long var0, String var2, boolean[] var3);

    private static native void setAttrType(long var0, String var2, int var3);

    private static native void setAttrTypeList(long var0, String var2, int[] var3);

    private static native void setAttrTensor(long var0, String var2, long var3);

    private static native void setAttrTensorList(long var0, String var2, long[] var3);

    private static native void setAttrShape(long var0, String var2, long[] var3, int var4);

    private static native void setAttrShapeList(long var0, String var2, long[] var3, int[] var4);

    private static native void setAttrStringList(long var0, String var2, Object[] var3);
}

