/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import java.util.ArrayList;
import java.util.List;
import org.tensorflow.Graph;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.Output;
import org.tensorflow.Tensor;

public final class Session
implements AutoCloseable {
    private final Graph graph;
    private final Graph.Reference graphRef;
    private final Object nativeHandleLock = new Object();
    private long nativeHandle;
    private int numActiveRuns;

    public Session(Graph g2) {
        this(g2, null);
    }

    public Session(Graph g2, byte[] config) {
        this.graph = g2;
        try (Graph.Reference reference = g2.ref();){
            this.nativeHandle = config == null ? Session.allocate(reference.nativeHandle()) : Session.allocate2(reference.nativeHandle(), null, config);
            this.graphRef = g2.ref();
            return;
        }
    }

    Session(Graph g2, long nativeHandle) {
        this.graph = g2;
        this.nativeHandle = nativeHandle;
        this.graphRef = g2.ref();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        this.graphRef.close();
        Object object = this.nativeHandleLock;
        synchronized (object) {
            if (this.nativeHandle == 0L) {
                return;
            }
            while (this.numActiveRuns > 0) {
                try {
                    this.nativeHandleLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            Session.delete(this.nativeHandle);
            this.nativeHandle = 0L;
            return;
        }
    }

    public final Runner runner() {
        return new Runner();
    }

    private static native long allocate(long var0);

    private static native long allocate2(long var0, String var2, byte[] var3);

    private static native void delete(long var0);

    private static native byte[] run(long var0, byte[] var2, long[] var3, long[] var4, int[] var5, long[] var6, int[] var7, long[] var8, boolean var9, long[] var10);

    public static final class Run {
        public List<Tensor<?>> outputs;
        public byte[] metadata;
    }

    public final class Runner {
        private ArrayList<Output<?>> inputs = new ArrayList();
        private ArrayList<Tensor<?>> inputTensors = new ArrayList();
        private ArrayList<Output<?>> outputs = new ArrayList();
        private ArrayList<Operation> targets = new ArrayList();
        private byte[] runOptions = null;

        public final Runner feed(String operation, Tensor<?> t2) {
            Runner runner = this;
            return runner.feed(runner.parseOutput(operation), t2);
        }

        public final Runner feed(String operation, int index, Tensor<?> t2) {
            Operation operation2 = this.operationByName(operation);
            if (operation2 != null) {
                this.inputs.add(operation2.output(index));
                this.inputTensors.add(t2);
            }
            return this;
        }

        public final Runner feed(Output<?> o2, Tensor<?> t2) {
            this.inputs.add(o2);
            this.inputTensors.add(t2);
            return this;
        }

        public final Runner fetch(String operation) {
            Runner runner = this;
            return runner.fetch(runner.parseOutput(operation));
        }

        public final Runner fetch(String operation, int index) {
            Operation operation2 = this.operationByName(operation);
            if (operation2 != null) {
                this.outputs.add(operation2.output(index));
            }
            return this;
        }

        public final Runner fetch(Output<?> output) {
            this.outputs.add(output);
            return this;
        }

        public final Runner fetch(Operand<?> operand) {
            return this.fetch(operand.asOutput());
        }

        public final Runner addTarget(String operation) {
            Operation operation2 = this.operationByName(operation);
            if (operation2 != null) {
                this.targets.add(operation2);
            }
            return this;
        }

        public final Runner addTarget(Operation operation) {
            this.targets.add(operation);
            return this;
        }

        public final Runner addTarget(Operand<?> operand) {
            return this.addTarget(operand.asOutput().op());
        }

        public final Runner setOptions(byte[] options) {
            this.runOptions = options;
            return this;
        }

        public final List<Tensor<?>> run() {
            return this.runHelper((boolean)false).outputs;
        }

        public final Run runAndFetchMetadata() {
            return this.runHelper(true);
        }

        private Run runHelper(boolean wantMetadata) {
            byte[] byArray;
            long[] lArray = new long[this.inputTensors.size()];
            long[] lArray2 = new long[this.inputs.size()];
            int[] nArray = new int[this.inputs.size()];
            long[] lArray3 = new long[this.outputs.size()];
            int[] nArray2 = new int[this.outputs.size()];
            long[] lArray4 = new long[this.targets.size()];
            long[] lArray5 = new long[this.outputs.size()];
            int n2 = 0;
            for (Tensor<?> object2 : this.inputTensors) {
                lArray[n2++] = object2.getNativeHandle();
            }
            n2 = 0;
            for (Output output : this.inputs) {
                lArray2[n2] = output.op().getUnsafeNativeHandle();
                nArray[n2] = output.index();
                ++n2;
            }
            n2 = 0;
            for (Output output : this.outputs) {
                lArray3[n2] = output.op().getUnsafeNativeHandle();
                nArray2[n2] = output.index();
                ++n2;
            }
            n2 = 0;
            for (Operation operation : this.targets) {
                lArray4[n2++] = operation.getUnsafeNativeHandle();
            }
            try (Reference reference = new Reference();){
                byArray = Session.run(Session.this.nativeHandle, this.runOptions, lArray, lArray2, nArray, lArray3, nArray2, lArray4, wantMetadata, lArray5);
            }
            ArrayList arrayList = new ArrayList();
            Object object = lArray5;
            int n3 = lArray5.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                long l2 = object[i2];
                try {
                    arrayList.add(Tensor.fromHandle(l2));
                    continue;
                }
                catch (Exception exception) {
                    for (Tensor tensor : arrayList) {
                        tensor.close();
                    }
                    arrayList.clear();
                    throw exception;
                }
            }
            object = new Run();
            new Run().outputs = arrayList;
            object.metadata = byArray;
            return object;
        }

        private Operation operationByName(String opName) {
            Operation operation = Session.this.graph.operation(opName);
            if (operation == null) {
                throw new IllegalArgumentException("No Operation named [" + opName + "] in the Graph");
            }
            return operation;
        }

        private Output<?> parseOutput(String opName) {
            int n2 = opName.lastIndexOf(58);
            if (n2 == -1 || n2 == opName.length() - 1) {
                return new Output(this.operationByName(opName), 0);
            }
            try {
                String string = opName.substring(0, n2);
                int n3 = Integer.parseInt(opName.substring(n2 + 1));
                return new Output(this.operationByName(string), n3);
            }
            catch (NumberFormatException numberFormatException) {
                return new Output(this.operationByName(opName), 0);
            }
        }

        private class Reference
        implements AutoCloseable {
            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Reference() {
                Object object = Session.this.nativeHandleLock;
                synchronized (object) {
                    if (Session.this.nativeHandle == 0L) {
                        throw new IllegalStateException("run() cannot be called on the Session after close()");
                    }
                    ++Session.this.numActiveRuns;
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() {
                Object object = Session.this.nativeHandleLock;
                synchronized (object) {
                    if (Session.this.nativeHandle == 0L) {
                        return;
                    }
                    if (--Session.this.numActiveRuns == 0) {
                        Session.this.nativeHandleLock.notifyAll();
                    }
                    return;
                }
            }
        }
    }
}

