/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class ArgMax<V extends Number>
extends PrimitiveOp
implements Operand<V> {
    private Output<V> output;

    public static <V extends Number, T, U extends Number> ArgMax<V> create(Scope scope, Operand<T> input, Operand<U> dimension, Class<V> outputType) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("ArgMax", scope.makeOpName("ArgMax"));
        operationBuilder.addInput(input.asOutput());
        operationBuilder.addInput(dimension.asOutput());
        operationBuilder.setAttr("output_type", DataType.fromClass(outputType));
        return new ArgMax<V>(operationBuilder.build());
    }

    public static <T, U extends Number> ArgMax<Long> create(Scope scope, Operand<T> input, Operand<U> dimension) {
        return ArgMax.create(scope, input, dimension, Long.class);
    }

    public final Output<V> output() {
        return this.output;
    }

    @Override
    public final Output<V> asOutput() {
        return this.output;
    }

    private ArgMax(Operation operation) {
        super(operation);
        this.output = operation.output(0);
    }
}

