/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class BoostedTreesMakeQuantileSummaries
extends PrimitiveOp
implements Iterable<Operand<Float>> {
    private List<Output<Float>> summaries;

    public static BoostedTreesMakeQuantileSummaries create(Scope scope, Iterable<Operand<Float>> floatValues, Operand<Float> exampleWeights, Operand<Float> epsilon) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("BoostedTreesMakeQuantileSummaries", scope.makeOpName("BoostedTreesMakeQuantileSummaries"));
        operationBuilder.addInputList(Operands.asOutputs(floatValues));
        operationBuilder.addInput(exampleWeights.asOutput());
        operationBuilder.addInput(epsilon.asOutput());
        return new BoostedTreesMakeQuantileSummaries(operationBuilder.build());
    }

    public final List<Output<Float>> summaries() {
        return this.summaries;
    }

    @Override
    public final Iterator<Operand<Float>> iterator() {
        return this.summaries.iterator();
    }

    private BoostedTreesMakeQuantileSummaries(Operation operation) {
        super(operation);
        int n2 = operation.outputListLength("summaries");
        this.summaries = Arrays.asList(operation.outputList(0, n2));
    }
}

