/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class CropAndResizeGradBoxes
extends PrimitiveOp
implements Operand<Float> {
    private Output<Float> output;

    public static <T extends Number> CropAndResizeGradBoxes create(Scope scope, Operand<Float> grads, Operand<T> image, Operand<Float> boxes, Operand<Integer> boxInd, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("CropAndResizeGradBoxes", scope.makeOpName("CropAndResizeGradBoxes"));
        operationBuilder.addInput(grads.asOutput());
        operationBuilder.addInput(image.asOutput());
        operationBuilder.addInput(boxes.asOutput());
        operationBuilder.addInput(boxInd.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.method == null) continue;
                operationBuilder.setAttr("method", options2.method);
            }
        }
        return new CropAndResizeGradBoxes(operationBuilder.build());
    }

    public static Options method(String method) {
        return new Options().method(method);
    }

    public final Output<Float> output() {
        return this.output;
    }

    @Override
    public final Output<Float> asOutput() {
        return this.output;
    }

    private CropAndResizeGradBoxes(Operation operation) {
        super(operation);
        this.output = operation.output(0);
    }

    public static class Options {
        private String method;

        public Options method(String method) {
            this.method = method;
            return this;
        }

        private Options() {
        }
    }
}

