/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class CropAndResizeGradImage<T extends Number>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> output;

    public static <T extends Number> CropAndResizeGradImage<T> create(Scope scope, Operand<Float> grads, Operand<Float> boxes, Operand<Integer> boxInd, Operand<Integer> imageSize, Class<T> T, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("CropAndResizeGradImage", scope.makeOpName("CropAndResizeGradImage"));
        operationBuilder.addInput(grads.asOutput());
        operationBuilder.addInput(boxes.asOutput());
        operationBuilder.addInput(boxInd.asOutput());
        operationBuilder.addInput(imageSize.asOutput());
        operationBuilder.setAttr("T", DataType.fromClass(T));
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.method == null) continue;
                operationBuilder.setAttr("method", options2.method);
            }
        }
        return new CropAndResizeGradImage<T>(operationBuilder.build());
    }

    public static Options method(String method) {
        return new Options().method(method);
    }

    public final Output<T> output() {
        return this.output;
    }

    @Override
    public final Output<T> asOutput() {
        return this.output;
    }

    private CropAndResizeGradImage(Operation operation) {
        super(operation);
        this.output = operation.output(0);
    }

    public static class Options {
        private String method;

        public Options method(String method) {
            this.method = method;
            return this;
        }

        private Options() {
        }
    }
}

