/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class CudnnRNN<T extends Number>
extends PrimitiveOp {
    private Output<T> output;
    private Output<T> outputH;
    private Output<T> outputC;
    private Output<T> reserveSpace;

    public static <T extends Number> CudnnRNN<T> create(Scope scope, Operand<T> input, Operand<T> inputH, Operand<T> inputC, Operand<T> params, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("CudnnRNN", scope.makeOpName("CudnnRNN"));
        operationBuilder.addInput(input.asOutput());
        operationBuilder.addInput(inputH.asOutput());
        operationBuilder.addInput(inputC.asOutput());
        operationBuilder.addInput(params.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.rnnMode != null) {
                    operationBuilder.setAttr("rnn_mode", options2.rnnMode);
                }
                if (options2.inputMode != null) {
                    operationBuilder.setAttr("input_mode", options2.inputMode);
                }
                if (options2.direction != null) {
                    operationBuilder.setAttr("direction", options2.direction);
                }
                if (options2.dropout != null) {
                    operationBuilder.setAttr("dropout", options2.dropout.floatValue());
                }
                if (options2.seed != null) {
                    operationBuilder.setAttr("seed", options2.seed);
                }
                if (options2.seed2 != null) {
                    operationBuilder.setAttr("seed2", options2.seed2);
                }
                if (options2.isTraining == null) continue;
                operationBuilder.setAttr("is_training", options2.isTraining);
            }
        }
        return new CudnnRNN<T>(operationBuilder.build());
    }

    public static Options rnnMode(String rnnMode) {
        return new Options().rnnMode(rnnMode);
    }

    public static Options inputMode(String inputMode) {
        return new Options().inputMode(inputMode);
    }

    public static Options direction(String direction) {
        return new Options().direction(direction);
    }

    public static Options dropout(Float dropout) {
        return new Options().dropout(dropout);
    }

    public static Options seed(Long seed) {
        return new Options().seed(seed);
    }

    public static Options seed2(Long seed2) {
        return new Options().seed2(seed2);
    }

    public static Options isTraining(Boolean isTraining) {
        return new Options().isTraining(isTraining);
    }

    public final Output<T> output() {
        return this.output;
    }

    public final Output<T> outputH() {
        return this.outputH;
    }

    public final Output<T> outputC() {
        return this.outputC;
    }

    public final Output<T> reserveSpace() {
        return this.reserveSpace;
    }

    private CudnnRNN(Operation operation) {
        super(operation);
        this.output = operation.output(0);
        this.outputH = operation.output(1);
        this.outputC = operation.output(2);
        this.reserveSpace = operation.output(3);
    }

    public static class Options {
        private String rnnMode;
        private String inputMode;
        private String direction;
        private Float dropout;
        private Long seed;
        private Long seed2;
        private Boolean isTraining;

        public Options rnnMode(String rnnMode) {
            this.rnnMode = rnnMode;
            return this;
        }

        public Options inputMode(String inputMode) {
            this.inputMode = inputMode;
            return this;
        }

        public Options direction(String direction) {
            this.direction = direction;
            return this;
        }

        public Options dropout(Float dropout) {
            this.dropout = dropout;
            return this;
        }

        public Options seed(Long seed) {
            this.seed = seed;
            return this;
        }

        public Options seed2(Long seed2) {
            this.seed2 = seed2;
            return this;
        }

        public Options isTraining(Boolean isTraining) {
            this.isTraining = isTraining;
            return this;
        }

        private Options() {
        }
    }
}

