/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class DataFormatDimMap<T extends Number>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> y;

    public static <T extends Number> DataFormatDimMap<T> create(Scope scope, Operand<T> x2, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("DataFormatDimMap", scope.makeOpName("DataFormatDimMap"));
        operationBuilder.addInput(x2.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.srcFormat != null) {
                    operationBuilder.setAttr("src_format", options2.srcFormat);
                }
                if (options2.dstFormat == null) continue;
                operationBuilder.setAttr("dst_format", options2.dstFormat);
            }
        }
        return new DataFormatDimMap<T>(operationBuilder.build());
    }

    public static Options srcFormat(String srcFormat) {
        return new Options().srcFormat(srcFormat);
    }

    public static Options dstFormat(String dstFormat) {
        return new Options().dstFormat(dstFormat);
    }

    public final Output<T> y() {
        return this.y;
    }

    @Override
    public final Output<T> asOutput() {
        return this.y;
    }

    private DataFormatDimMap(Operation operation) {
        super(operation);
        this.y = operation.output(0);
    }

    public static class Options {
        private String srcFormat;
        private String dstFormat;

        public Options srcFormat(String srcFormat) {
            this.srcFormat = srcFormat;
            return this;
        }

        public Options dstFormat(String dstFormat) {
            this.dstFormat = dstFormat;
            return this;
        }

        private Options() {
        }
    }
}

