/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.UInt8;

public final class DecodePng<T extends Number>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> image;

    public static <T extends Number> DecodePng<T> create(Scope scope, Operand<String> contents, Class<T> dtype, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("DecodePng", scope.makeOpName("DecodePng"));
        operationBuilder.addInput(contents.asOutput());
        operationBuilder.setAttr("dtype", DataType.fromClass(dtype));
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.channels == null) continue;
                operationBuilder.setAttr("channels", options2.channels);
            }
        }
        return new DecodePng<T>(operationBuilder.build());
    }

    public static DecodePng<UInt8> create(Scope scope, Operand<String> contents, Options ... options) {
        return DecodePng.create(scope, contents, UInt8.class, options);
    }

    public static Options channels(Long channels) {
        return new Options().channels(channels);
    }

    public final Output<T> image() {
        return this.image;
    }

    @Override
    public final Output<T> asOutput() {
        return this.image;
    }

    private DecodePng(Operation operation) {
        super(operation);
        this.image = operation.output(0);
    }

    public static class Options {
        private Long channels;

        public Options channels(Long channels) {
            this.channels = channels;
            return this;
        }

        private Options() {
        }
    }
}

