/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class FakeQuantWithMinMaxVarsGradient
extends PrimitiveOp {
    private Output<Float> backpropsWrtInput;
    private Output<Float> backpropWrtMin;
    private Output<Float> backpropWrtMax;

    public static FakeQuantWithMinMaxVarsGradient create(Scope scope, Operand<Float> gradients, Operand<Float> inputs, Operand<Float> min, Operand<Float> max, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("FakeQuantWithMinMaxVarsGradient", scope.makeOpName("FakeQuantWithMinMaxVarsGradient"));
        operationBuilder.addInput(gradients.asOutput());
        operationBuilder.addInput(inputs.asOutput());
        operationBuilder.addInput(min.asOutput());
        operationBuilder.addInput(max.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.numBits != null) {
                    operationBuilder.setAttr("num_bits", options2.numBits);
                }
                if (options2.narrowRange == null) continue;
                operationBuilder.setAttr("narrow_range", options2.narrowRange);
            }
        }
        return new FakeQuantWithMinMaxVarsGradient(operationBuilder.build());
    }

    public static Options numBits(Long numBits) {
        return new Options().numBits(numBits);
    }

    public static Options narrowRange(Boolean narrowRange) {
        return new Options().narrowRange(narrowRange);
    }

    public final Output<Float> backpropsWrtInput() {
        return this.backpropsWrtInput;
    }

    public final Output<Float> backpropWrtMin() {
        return this.backpropWrtMin;
    }

    public final Output<Float> backpropWrtMax() {
        return this.backpropWrtMax;
    }

    private FakeQuantWithMinMaxVarsGradient(Operation operation) {
        super(operation);
        this.backpropsWrtInput = operation.output(0);
        this.backpropWrtMin = operation.output(1);
        this.backpropWrtMax = operation.output(2);
    }

    public static class Options {
        private Long numBits;
        private Boolean narrowRange;

        public Options numBits(Long numBits) {
            this.numBits = numBits;
            return this;
        }

        public Options narrowRange(Boolean narrowRange) {
            this.narrowRange = narrowRange;
            return this;
        }

        private Options() {
        }
    }
}

