/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class FixedLengthRecordReader
extends PrimitiveOp
implements Operand<Object> {
    private Output<?> readerHandle;

    public static FixedLengthRecordReader create(Scope scope, Long recordBytes, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("FixedLengthRecordReaderV2", scope.makeOpName("FixedLengthRecordReader"));
        operationBuilder.setAttr("record_bytes", recordBytes);
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.headerBytes != null) {
                    operationBuilder.setAttr("header_bytes", options2.headerBytes);
                }
                if (options2.footerBytes != null) {
                    operationBuilder.setAttr("footer_bytes", options2.footerBytes);
                }
                if (options2.hopBytes != null) {
                    operationBuilder.setAttr("hop_bytes", options2.hopBytes);
                }
                if (options2.container != null) {
                    operationBuilder.setAttr("container", options2.container);
                }
                if (options2.sharedName != null) {
                    operationBuilder.setAttr("shared_name", options2.sharedName);
                }
                if (options2.encoding == null) continue;
                operationBuilder.setAttr("encoding", options2.encoding);
            }
        }
        return new FixedLengthRecordReader(operationBuilder.build());
    }

    public static Options headerBytes(Long headerBytes) {
        return new Options().headerBytes(headerBytes);
    }

    public static Options footerBytes(Long footerBytes) {
        return new Options().footerBytes(footerBytes);
    }

    public static Options hopBytes(Long hopBytes) {
        return new Options().hopBytes(hopBytes);
    }

    public static Options container(String container) {
        return new Options().container(container);
    }

    public static Options sharedName(String sharedName) {
        return new Options().sharedName(sharedName);
    }

    public static Options encoding(String encoding) {
        return new Options().encoding(encoding);
    }

    public final Output<?> readerHandle() {
        return this.readerHandle;
    }

    @Override
    public final Output<Object> asOutput() {
        return this.readerHandle;
    }

    private FixedLengthRecordReader(Operation operation) {
        super(operation);
        this.readerHandle = operation.output(0);
    }

    public static class Options {
        private Long headerBytes;
        private Long footerBytes;
        private Long hopBytes;
        private String container;
        private String sharedName;
        private String encoding;

        public Options headerBytes(Long headerBytes) {
            this.headerBytes = headerBytes;
            return this;
        }

        public Options footerBytes(Long footerBytes) {
            this.footerBytes = footerBytes;
            return this;
        }

        public Options hopBytes(Long hopBytes) {
            this.hopBytes = hopBytes;
            return this;
        }

        public Options container(String container) {
            this.container = container;
            return this;
        }

        public Options sharedName(String sharedName) {
            this.sharedName = sharedName;
            return this;
        }

        public Options encoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        private Options() {
        }
    }
}

