/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class LoadAndRemapMatrix
extends PrimitiveOp
implements Operand<Float> {
    private Output<Float> outputMatrix;

    public static LoadAndRemapMatrix create(Scope scope, Operand<String> ckptPath, Operand<String> oldTensorName, Operand<Long> rowRemapping, Operand<Long> colRemapping, Operand<Float> initializingValues, Long numRows, Long numCols, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("LoadAndRemapMatrix", scope.makeOpName("LoadAndRemapMatrix"));
        operationBuilder.addInput(ckptPath.asOutput());
        operationBuilder.addInput(oldTensorName.asOutput());
        operationBuilder.addInput(rowRemapping.asOutput());
        operationBuilder.addInput(colRemapping.asOutput());
        operationBuilder.addInput(initializingValues.asOutput());
        operationBuilder.setAttr("num_rows", numRows);
        operationBuilder.setAttr("num_cols", numCols);
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.maxRowsInMemory == null) continue;
                operationBuilder.setAttr("max_rows_in_memory", options2.maxRowsInMemory);
            }
        }
        return new LoadAndRemapMatrix(operationBuilder.build());
    }

    public static Options maxRowsInMemory(Long maxRowsInMemory) {
        return new Options().maxRowsInMemory(maxRowsInMemory);
    }

    public final Output<Float> outputMatrix() {
        return this.outputMatrix;
    }

    @Override
    public final Output<Float> asOutput() {
        return this.outputMatrix;
    }

    private LoadAndRemapMatrix(Operation operation) {
        super(operation);
        this.outputMatrix = operation.output(0);
    }

    public static class Options {
        private Long maxRowsInMemory;

        public Options maxRowsInMemory(Long maxRowsInMemory) {
            this.maxRowsInMemory = maxRowsInMemory;
            return this;
        }

        private Options() {
        }
    }
}

