/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.Shape;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class MultiDeviceIteratorGetNextFromShard
extends PrimitiveOp
implements Iterable<Operand<Object>> {
    private List<Output<?>> components;

    public static MultiDeviceIteratorGetNextFromShard create(Scope scope, Operand<?> multiDeviceIterator, Operand<Integer> shardNum, Operand<Long> incarnationId, List<Class<?>> outputTypes, List<Shape> outputShapes) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("MultiDeviceIteratorGetNextFromShard", scope.makeOpName("MultiDeviceIteratorGetNextFromShard"));
        operationBuilder.addInput(multiDeviceIterator.asOutput());
        operationBuilder.addInput(shardNum.asOutput());
        operationBuilder.addInput(incarnationId.asOutput());
        DataType[] dataTypeArray = new DataType[outputTypes.size()];
        for (int i2 = 0; i2 < dataTypeArray.length; ++i2) {
            dataTypeArray[i2] = DataType.fromClass(outputTypes.get(i2));
        }
        operationBuilder.setAttr("output_types", dataTypeArray);
        Shape[] shapeArray = new Shape[outputShapes.size()];
        for (int i3 = 0; i3 < shapeArray.length; ++i3) {
            shapeArray[i3] = outputShapes.get(i3);
        }
        operationBuilder.setAttr("output_shapes", shapeArray);
        return new MultiDeviceIteratorGetNextFromShard(operationBuilder.build());
    }

    public final List<Output<?>> components() {
        return this.components;
    }

    @Override
    public final Iterator<Operand<Object>> iterator() {
        return this.components.iterator();
    }

    private MultiDeviceIteratorGetNextFromShard(Operation operation) {
        super(operation);
        int n2 = operation.outputListLength("components");
        this.components = Arrays.asList(operation.outputList(0, n2));
    }
}

