/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class QuantizedAvgPool<T>
extends PrimitiveOp {
    private Output<T> output;
    private Output<Float> minOutput;
    private Output<Float> maxOutput;

    public static <T> QuantizedAvgPool<T> create(Scope scope, Operand<T> input, Operand<Float> minInput, Operand<Float> maxInput, List<Long> ksize, List<Long> strides, String padding) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("QuantizedAvgPool", scope.makeOpName("QuantizedAvgPool"));
        operationBuilder.addInput(input.asOutput());
        operationBuilder.addInput(minInput.asOutput());
        operationBuilder.addInput(maxInput.asOutput());
        long[] lArray = new long[ksize.size()];
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            lArray[i2] = ksize.get(i2);
        }
        operationBuilder.setAttr("ksize", lArray);
        long[] lArray2 = new long[strides.size()];
        for (int i3 = 0; i3 < lArray2.length; ++i3) {
            lArray2[i3] = strides.get(i3);
        }
        operationBuilder.setAttr("strides", lArray2);
        operationBuilder.setAttr("padding", padding);
        return new QuantizedAvgPool<T>(operationBuilder.build());
    }

    public final Output<T> output() {
        return this.output;
    }

    public final Output<Float> minOutput() {
        return this.minOutput;
    }

    public final Output<Float> maxOutput() {
        return this.maxOutput;
    }

    private QuantizedAvgPool(Operation operation) {
        super(operation);
        this.output = operation.output(0);
        this.minOutput = operation.output(1);
        this.maxOutput = operation.output(2);
    }
}

