/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class QuantizedConcat<T>
extends PrimitiveOp {
    private Output<T> output;
    private Output<Float> outputMin;
    private Output<Float> outputMax;

    public static <T> QuantizedConcat<T> create(Scope scope, Operand<Integer> concatDim, Operand<T> values, Iterable<Operand<Float>> inputMins, Iterable<Operand<Float>> inputMaxes) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("QuantizedConcat", scope.makeOpName("QuantizedConcat"));
        operationBuilder.addInput(concatDim.asOutput());
        operationBuilder.addInput(values.asOutput());
        operationBuilder.addInputList(Operands.asOutputs(inputMins));
        operationBuilder.addInputList(Operands.asOutputs(inputMaxes));
        return new QuantizedConcat<T>(operationBuilder.build());
    }

    public final Output<T> output() {
        return this.output;
    }

    public final Output<Float> outputMin() {
        return this.outputMin;
    }

    public final Output<Float> outputMax() {
        return this.outputMax;
    }

    private QuantizedConcat(Operation operation) {
        super(operation);
        this.output = operation.output(0);
        this.outputMin = operation.output(1);
        this.outputMax = operation.output(2);
    }
}

