/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class RaggedGather<T>
extends PrimitiveOp {
    private List<Output<Long>> outputNestedSplits;
    private Output<T> outputDenseValues;

    public static <T, U extends Number> RaggedGather<T> create(Scope scope, Iterable<Operand<Long>> paramsNestedSplits, Operand<T> paramsDenseValues, Operand<U> indices, Long OUTPUTRAGGEDRANK) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("RaggedGather", scope.makeOpName("RaggedGather"));
        operationBuilder.addInputList(Operands.asOutputs(paramsNestedSplits));
        operationBuilder.addInput(paramsDenseValues.asOutput());
        operationBuilder.addInput(indices.asOutput());
        operationBuilder.setAttr("OUTPUT_RAGGED_RANK", OUTPUTRAGGEDRANK);
        return new RaggedGather<T>(operationBuilder.build());
    }

    public final List<Output<Long>> outputNestedSplits() {
        return this.outputNestedSplits;
    }

    public final Output<T> outputDenseValues() {
        return this.outputDenseValues;
    }

    private RaggedGather(Operation operation) {
        super(operation);
        int n2 = operation.outputListLength("output_nested_splits");
        this.outputNestedSplits = Arrays.asList(operation.outputList(0, n2));
        int n3 = n2 + 0;
        this.outputDenseValues = operation.output(n3);
    }
}

