/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class ResizeBilinearGrad<T extends Number>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> output;

    public static <T extends Number> ResizeBilinearGrad<T> create(Scope scope, Operand<Float> grads, Operand<T> originalImage, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("ResizeBilinearGrad", scope.makeOpName("ResizeBilinearGrad"));
        operationBuilder.addInput(grads.asOutput());
        operationBuilder.addInput(originalImage.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.alignCorners == null) continue;
                operationBuilder.setAttr("align_corners", options2.alignCorners);
            }
        }
        return new ResizeBilinearGrad<T>(operationBuilder.build());
    }

    public static Options alignCorners(Boolean alignCorners) {
        return new Options().alignCorners(alignCorners);
    }

    public final Output<T> output() {
        return this.output;
    }

    @Override
    public final Output<T> asOutput() {
        return this.output;
    }

    private ResizeBilinearGrad(Operation operation) {
        super(operation);
        this.output = operation.output(0);
    }

    public static class Options {
        private Boolean alignCorners;

        public Options alignCorners(Boolean alignCorners) {
            this.alignCorners = alignCorners;
            return this;
        }

        private Options() {
        }
    }
}

