/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class SetDiff1D<T, U extends Number>
extends PrimitiveOp {
    private Output<T> out;
    private Output<U> idx;

    public static <T, U extends Number> SetDiff1D<T, U> create(Scope scope, Operand<T> x2, Operand<T> y2, Class<U> outIdx) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("ListDiff", scope.makeOpName("SetDiff1D"));
        operationBuilder.addInput(x2.asOutput());
        operationBuilder.addInput(y2.asOutput());
        operationBuilder.setAttr("out_idx", DataType.fromClass(outIdx));
        return new SetDiff1D<T, U>(operationBuilder.build());
    }

    public static <T> SetDiff1D<T, Integer> create(Scope scope, Operand<T> x2, Operand<T> y2) {
        return SetDiff1D.create(scope, x2, y2, Integer.class);
    }

    public final Output<T> out() {
        return this.out;
    }

    public final Output<U> idx() {
        return this.idx;
    }

    private SetDiff1D(Operation operation) {
        super(operation);
        this.out = operation.output(0);
        this.idx = operation.output(1);
    }
}

