/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.Shape;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class ShuffleDataset
extends PrimitiveOp
implements Operand<Object> {
    private Output<?> handle;

    public static ShuffleDataset create(Scope scope, Operand<?> inputDataset, Operand<Long> bufferSize, Operand<Long> seed, Operand<Long> seed2, List<Class<?>> outputTypes, List<Shape> outputShapes, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("ShuffleDataset", scope.makeOpName("ShuffleDataset"));
        operationBuilder.addInput(inputDataset.asOutput());
        operationBuilder.addInput(bufferSize.asOutput());
        operationBuilder.addInput(seed.asOutput());
        operationBuilder.addInput(seed2.asOutput());
        DataType[] dataTypeArray = new DataType[outputTypes.size()];
        for (int i2 = 0; i2 < dataTypeArray.length; ++i2) {
            dataTypeArray[i2] = DataType.fromClass(outputTypes.get(i2));
        }
        operationBuilder.setAttr("output_types", dataTypeArray);
        Shape[] shapeArray = new Shape[outputShapes.size()];
        for (int i3 = 0; i3 < shapeArray.length; ++i3) {
            shapeArray[i3] = outputShapes.get(i3);
        }
        operationBuilder.setAttr("output_shapes", shapeArray);
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i4 = 0; i4 < n2; ++i4) {
                Options options2 = optionsArray[i4];
                if (options2.reshuffleEachIteration == null) continue;
                operationBuilder.setAttr("reshuffle_each_iteration", options2.reshuffleEachIteration);
            }
        }
        return new ShuffleDataset(operationBuilder.build());
    }

    public static Options reshuffleEachIteration(Boolean reshuffleEachIteration) {
        return new Options().reshuffleEachIteration(reshuffleEachIteration);
    }

    public final Output<?> handle() {
        return this.handle;
    }

    @Override
    public final Output<Object> asOutput() {
        return this.handle;
    }

    private ShuffleDataset(Operation operation) {
        super(operation);
        this.handle = operation.output(0);
    }

    public static class Options {
        private Boolean reshuffleEachIteration;

        public Options reshuffleEachIteration(Boolean reshuffleEachIteration) {
            this.reshuffleEachIteration = reshuffleEachIteration;
            return this;
        }

        private Options() {
        }
    }
}

