/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class SparseSlice<T>
extends PrimitiveOp {
    private Output<Long> outputIndices;
    private Output<T> outputValues;
    private Output<Long> outputShape;

    public static <T> SparseSlice<T> create(Scope scope, Operand<Long> indices, Operand<T> values, Operand<Long> shape, Operand<Long> start, Operand<Long> size) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("SparseSlice", scope.makeOpName("SparseSlice"));
        operationBuilder.addInput(indices.asOutput());
        operationBuilder.addInput(values.asOutput());
        operationBuilder.addInput(shape.asOutput());
        operationBuilder.addInput(start.asOutput());
        operationBuilder.addInput(size.asOutput());
        return new SparseSlice<T>(operationBuilder.build());
    }

    public final Output<Long> outputIndices() {
        return this.outputIndices;
    }

    public final Output<T> outputValues() {
        return this.outputValues;
    }

    public final Output<Long> outputShape() {
        return this.outputShape;
    }

    private SparseSlice(Operation operation) {
        super(operation);
        this.outputIndices = operation.output(0);
        this.outputValues = operation.output(1);
        this.outputShape = operation.output(2);
    }
}

