/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class SparseToDense<U>
extends PrimitiveOp
implements Operand<U> {
    private Output<U> dense;

    public static <U, T extends Number> SparseToDense<U> create(Scope scope, Operand<T> sparseIndices, Operand<T> outputShape, Operand<U> sparseValues, Operand<U> defaultValue, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("SparseToDense", scope.makeOpName("SparseToDense"));
        operationBuilder.addInput(sparseIndices.asOutput());
        operationBuilder.addInput(outputShape.asOutput());
        operationBuilder.addInput(sparseValues.asOutput());
        operationBuilder.addInput(defaultValue.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.validateIndices == null) continue;
                operationBuilder.setAttr("validate_indices", options2.validateIndices);
            }
        }
        return new SparseToDense<U>(operationBuilder.build());
    }

    public static Options validateIndices(Boolean validateIndices) {
        return new Options().validateIndices(validateIndices);
    }

    public final Output<U> dense() {
        return this.dense;
    }

    @Override
    public final Output<U> asOutput() {
        return this.dense;
    }

    private SparseToDense(Operation operation) {
        super(operation);
        this.dense = operation.output(0);
    }

    public static class Options {
        private Boolean validateIndices;

        public Options validateIndices(Boolean validateIndices) {
            this.validateIndices = validateIndices;
            return this;
        }

        private Options() {
        }
    }
}

