/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class Split<T>
extends PrimitiveOp
implements Iterable<Operand<T>> {
    private List<Output<T>> output;

    public static <T> Split<T> create(Scope scope, Operand<Integer> axis, Operand<T> value, Long numSplit) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("Split", scope.makeOpName("Split"));
        operationBuilder.addInput(axis.asOutput());
        operationBuilder.addInput(value.asOutput());
        operationBuilder.setAttr("num_split", numSplit);
        return new Split<T>(operationBuilder.build());
    }

    public final List<Output<T>> output() {
        return this.output;
    }

    @Override
    public final Iterator<Operand<T>> iterator() {
        return this.output.iterator();
    }

    private Split(Operation operation) {
        super(operation);
        int n2 = operation.outputListLength("output");
        this.output = Arrays.asList(operation.outputList(0, n2));
    }
}

