/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class Squeeze<T>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> output;

    public static <T> Squeeze<T> create(Scope scope, Operand<T> input, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("Squeeze", scope.makeOpName("Squeeze"));
        operationBuilder.addInput(input.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.axis == null) continue;
                long[] lArray = new long[options2.axis.size()];
                for (int i3 = 0; i3 < lArray.length; ++i3) {
                    lArray[i3] = (Long)options2.axis.get(i3);
                }
                operationBuilder.setAttr("squeeze_dims", lArray);
            }
        }
        return new Squeeze<T>(operationBuilder.build());
    }

    public static Options axis(List<Long> axis) {
        return new Options().axis(axis);
    }

    public final Output<T> output() {
        return this.output;
    }

    @Override
    public final Output<T> asOutput() {
        return this.output;
    }

    private Squeeze(Operation operation) {
        super(operation);
        this.output = operation.output(0);
    }

    public static class Options {
        private List<Long> axis;

        public Options axis(List<Long> axis) {
            this.axis = axis;
            return this;
        }

        private Options() {
        }
    }
}

