/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class Stack<T>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> output;

    public static <T> Stack<T> create(Scope scope, Operand<T> values, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("Pack", scope.makeOpName("Stack"));
        operationBuilder.addInput(values.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.axis == null) continue;
                operationBuilder.setAttr("axis", options2.axis);
            }
        }
        return new Stack<T>(operationBuilder.build());
    }

    public static Options axis(Long axis) {
        return new Options().axis(axis);
    }

    public final Output<T> output() {
        return this.output;
    }

    @Override
    public final Output<T> asOutput() {
        return this.output;
    }

    private Stack(Operation operation) {
        super(operation);
        this.output = operation.output(0);
    }

    public static class Options {
        private Long axis;

        public Options axis(Long axis) {
            this.axis = axis;
            return this;
        }

        private Options() {
        }
    }
}

