/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class TensorListStack<T>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> tensor;

    public static <T> TensorListStack<T> create(Scope scope, Operand<?> inputHandle, Class<T> elementDtype, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("TensorListStack", scope.makeOpName("TensorListStack"));
        operationBuilder.addInput(inputHandle.asOutput());
        operationBuilder.setAttr("element_dtype", DataType.fromClass(elementDtype));
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.numElements == null) continue;
                operationBuilder.setAttr("num_elements", options2.numElements);
            }
        }
        return new TensorListStack<T>(operationBuilder.build());
    }

    public static Options numElements(Long numElements) {
        return new Options().numElements(numElements);
    }

    public final Output<T> tensor() {
        return this.tensor;
    }

    @Override
    public final Output<T> asOutput() {
        return this.tensor;
    }

    private TensorListStack(Operation operation) {
        super(operation);
        this.tensor = operation.output(0);
    }

    public static class Options {
        private Long numElements;

        public Options numElements(Long numElements) {
            this.numElements = numElements;
            return this;
        }

        private Options() {
        }
    }
}

