/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.bytecode.annotation;

import ai.h2o.javassist.ClassPool;
import ai.h2o.javassist.bytecode.ConstPool;
import ai.h2o.javassist.bytecode.annotation.AnnotationsWriter;
import ai.h2o.javassist.bytecode.annotation.MemberValue;
import ai.h2o.javassist.bytecode.annotation.MemberValueVisitor;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;

public class ArrayMemberValue
extends MemberValue {
    MemberValue type;
    MemberValue[] values;

    public ArrayMemberValue(ConstPool cp) {
        super('[', cp);
        this.type = null;
        this.values = null;
    }

    public ArrayMemberValue(MemberValue t2, ConstPool cp) {
        super('[', cp);
        this.type = t2;
        this.values = null;
    }

    @Override
    Object getValue(ClassLoader cl, ClassPool cp, Method method) throws ClassNotFoundException {
        Class<?> clazz;
        if (this.values == null) {
            throw new ClassNotFoundException("no array elements found: " + method.getName());
        }
        int n2 = this.values.length;
        if (this.type == null) {
            clazz = method.getReturnType().getComponentType();
            if (clazz == null || n2 > 0) {
                throw new ClassNotFoundException("broken array type: " + method.getName());
            }
        } else {
            clazz = this.type.getType(cl);
        }
        Object object = Array.newInstance(clazz, n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Array.set(object, i2, this.values[i2].getValue(cl, cp, method));
        }
        return object;
    }

    @Override
    Class<?> getType(ClassLoader cl) throws ClassNotFoundException {
        if (this.type == null) {
            throw new ClassNotFoundException("no array type specified");
        }
        Object object = Array.newInstance(this.type.getType(cl), 0);
        return object.getClass();
    }

    public MemberValue getType() {
        return this.type;
    }

    public MemberValue[] getValue() {
        return this.values;
    }

    public void setValue(MemberValue[] elements) {
        this.values = elements;
        if (elements != null && elements.length > 0) {
            this.type = elements[0];
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{");
        if (this.values != null) {
            for (int i2 = 0; i2 < this.values.length; ++i2) {
                stringBuffer.append(this.values[i2].toString());
                if (i2 + 1 >= this.values.length) continue;
                stringBuffer.append(", ");
            }
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    @Override
    public void write(AnnotationsWriter writer) throws IOException {
        int n2 = this.values == null ? 0 : this.values.length;
        writer.arrayValue(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.values[i2].write(writer);
        }
    }

    @Override
    public void accept(MemberValueVisitor visitor) {
        visitor.visitArrayMemberValue(this);
    }
}

