/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.bytecode.stackmap;

import ai.h2o.javassist.bytecode.BadBytecode;
import ai.h2o.javassist.bytecode.CodeAttribute;
import ai.h2o.javassist.bytecode.CodeIterator;
import ai.h2o.javassist.bytecode.ExceptionTable;
import ai.h2o.javassist.bytecode.MethodInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class BasicBlock {
    protected int position;
    protected int length;
    protected int incoming;
    protected BasicBlock[] exit;
    protected boolean stop;
    protected Catch toCatch;

    protected BasicBlock(int pos) {
        this.position = pos;
        this.length = 0;
        this.incoming = 0;
    }

    public static BasicBlock find(BasicBlock[] blocks, int pos) throws BadBytecode {
        BasicBlock[] basicBlockArray = blocks;
        int n2 = blocks.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            BasicBlock basicBlock = basicBlockArray[i2];
            if (basicBlock.position > pos || pos >= basicBlock.position + basicBlock.length) continue;
            return basicBlock;
        }
        throw new BadBytecode("no basic block at " + pos);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getClass().getName();
        int n2 = string.lastIndexOf(46);
        stringBuffer.append(n2 < 0 ? string : string.substring(n2 + 1));
        stringBuffer.append("[");
        this.toString2(stringBuffer);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected void toString2(StringBuffer sbuf) {
        Object object;
        sbuf.append("pos=").append(this.position).append(", len=").append(this.length).append(", in=").append(this.incoming).append(", exit{");
        if (this.exit != null) {
            object = this.exit;
            int n2 = this.exit.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                BasicBlock basicBlock = object[i2];
                sbuf.append(basicBlock.position).append(",");
            }
        }
        sbuf.append("}, {");
        object = this.toCatch;
        while (object != null) {
            sbuf.append("(").append(object.body.position).append(", ").append(object.typeIndex).append("), ");
            object = object.next;
        }
        sbuf.append("}");
    }

    public static class Maker {
        protected BasicBlock makeBlock(int pos) {
            return new BasicBlock(pos);
        }

        protected BasicBlock[] makeArray(int size) {
            return new BasicBlock[size];
        }

        private BasicBlock[] makeArray(BasicBlock b2) {
            BasicBlock[] basicBlockArray = this.makeArray(1);
            BasicBlock[] basicBlockArray2 = basicBlockArray;
            basicBlockArray[0] = b2;
            return basicBlockArray2;
        }

        private BasicBlock[] makeArray(BasicBlock b1, BasicBlock b2) {
            BasicBlock[] basicBlockArray = this.makeArray(2);
            BasicBlock[] basicBlockArray2 = basicBlockArray;
            basicBlockArray[0] = b1;
            basicBlockArray2[1] = b2;
            return basicBlockArray2;
        }

        public BasicBlock[] make(MethodInfo minfo) throws BadBytecode {
            CodeAttribute codeAttribute = minfo.getCodeAttribute();
            if (codeAttribute == null) {
                return null;
            }
            CodeIterator codeIterator = codeAttribute.iterator();
            return this.make(codeIterator, 0, codeIterator.getCodeLength(), codeAttribute.getExceptionTable());
        }

        public BasicBlock[] make(CodeIterator ci, int begin, int end, ExceptionTable et) throws BadBytecode {
            Map<Integer, Mark> map = this.makeMarks(ci, begin, end, et);
            BasicBlock[] basicBlockArray = this.makeBlocks(map);
            this.addCatchers(basicBlockArray, et);
            return basicBlockArray;
        }

        private Mark makeMark(Map<Integer, Mark> table, int pos) {
            return this.makeMark0(table, pos, true, true);
        }

        private Mark makeMark(Map<Integer, Mark> table, int pos, BasicBlock[] jump, int size, boolean always) {
            Mark mark = this.makeMark0(table, pos, false, false);
            mark.setJump(jump, size, always);
            return mark;
        }

        private Mark makeMark0(Map<Integer, Mark> table, int pos, boolean isBlockBegin, boolean isTarget) {
            Integer n2 = pos;
            Mark mark = table.get(n2);
            if (mark == null) {
                mark = new Mark(pos);
                table.put(n2, mark);
            }
            if (isBlockBegin) {
                if (mark.block == null) {
                    mark.block = this.makeBlock(pos);
                }
                if (isTarget) {
                    ++mark.block.incoming;
                }
            }
            return mark;
        }

        private Map<Integer, Mark> makeMarks(CodeIterator ci, int begin, int end, ExceptionTable et) throws BadBytecode {
            int n2;
            ci.begin();
            ci.move(begin);
            HashMap<Integer, Mark> hashMap = new HashMap<Integer, Mark>();
            block7: while (ci.hasNext() && (n2 = ci.next()) < end) {
                int n3 = ci.byteAt(n2);
                if (153 <= n3 && n3 <= 166 || n3 == 198 || n3 == 199) {
                    Mark mark = this.makeMark(hashMap, n2 + ci.s16bitAt(n2 + 1));
                    Mark mark2 = this.makeMark(hashMap, n2 + 3);
                    this.makeMark(hashMap, n2, this.makeArray(mark.block, mark2.block), 3, false);
                    continue;
                }
                if (167 <= n3 && n3 <= 171) {
                    switch (n3) {
                        case 167: {
                            int n4 = n2;
                            this.makeGoto(hashMap, n4, n4 + ci.s16bitAt(n2 + 1), 3);
                            continue block7;
                        }
                        case 168: {
                            int n5 = n2;
                            this.makeJsr(hashMap, n5, n5 + ci.s16bitAt(n2 + 1), 3);
                            continue block7;
                        }
                        case 169: {
                            this.makeMark(hashMap, n2, null, 2, true);
                            continue block7;
                        }
                        case 170: {
                            int n6;
                            int n7 = (n2 & 0xFFFFFFFC) + 4;
                            int n8 = ci.s32bitAt(n7 + 4);
                            int n9 = ci.s32bitAt(n7 + 8);
                            int n10 = n9 - n8 + 1;
                            BasicBlock[] basicBlockArray = this.makeArray(n10 + 1);
                            BasicBlock[] basicBlockArray2 = basicBlockArray;
                            basicBlockArray[0] = this.makeMark(hashMap, (int)(n2 + ci.s32bitAt((int)n7))).block;
                            int n11 = n6 + (n10 << 2);
                            int n12 = 1;
                            for (n6 = n7 + 12; n6 < n11; n6 += 4) {
                                basicBlockArray2[n12++] = this.makeMark(hashMap, (int)(n2 + ci.s32bitAt((int)n6))).block;
                            }
                            this.makeMark(hashMap, n2, basicBlockArray2, n11 - n2, true);
                            continue block7;
                        }
                        case 171: {
                            int n10;
                            int n13 = (n2 & 0xFFFFFFFC) + 4;
                            int n14 = ci.s32bitAt(n13 + 4);
                            BasicBlock[] basicBlockArray = this.makeArray(n14 + 1);
                            BasicBlock[] basicBlockArray3 = basicBlockArray;
                            basicBlockArray[0] = this.makeMark(hashMap, (int)(n2 + ci.s32bitAt((int)n13))).block;
                            int n15 = n10 + (n14 << 3) - 4;
                            int n6 = 1;
                            for (n10 = n13 + 8 + 4; n10 < n15; n10 += 8) {
                                basicBlockArray3[n6++] = this.makeMark(hashMap, (int)(n2 + ci.s32bitAt((int)n10))).block;
                            }
                            this.makeMark(hashMap, n2, basicBlockArray3, n15 - n2, true);
                        }
                    }
                    continue;
                }
                if (172 <= n3 && n3 <= 177 || n3 == 191) {
                    this.makeMark(hashMap, n2, null, 1, true);
                    continue;
                }
                if (n3 == 200) {
                    int n16 = n2;
                    this.makeGoto(hashMap, n16, n16 + ci.s32bitAt(n2 + 1), 5);
                    continue;
                }
                if (n3 == 201) {
                    int n17 = n2;
                    this.makeJsr(hashMap, n17, n17 + ci.s32bitAt(n2 + 1), 5);
                    continue;
                }
                if (n3 != 196 || ci.byteAt(n2 + 1) != 169) continue;
                this.makeMark(hashMap, n2, null, 4, true);
            }
            if (et != null) {
                n2 = et.size();
                while (--n2 >= 0) {
                    this.makeMark0(hashMap, et.startPc(n2), true, false);
                    this.makeMark(hashMap, et.handlerPc(n2));
                }
            }
            return hashMap;
        }

        private void makeGoto(Map<Integer, Mark> marks, int pos, int target, int size) {
            Mark mark = this.makeMark(marks, target);
            BasicBlock[] basicBlockArray = this.makeArray(mark.block);
            this.makeMark(marks, pos, basicBlockArray, size, true);
        }

        protected void makeJsr(Map<Integer, Mark> marks, int pos, int target, int size) throws BadBytecode {
            throw new JsrBytecode();
        }

        private BasicBlock[] makeBlocks(Map<Integer, Mark> markTable) {
            BasicBlock basicBlock;
            Object[] objectArray = markTable.values().toArray(new Mark[markTable.size()]);
            Arrays.sort(objectArray);
            ArrayList<BasicBlock> arrayList = new ArrayList<BasicBlock>();
            int n2 = 0;
            if (objectArray.length > 0 && ((Mark)objectArray[0]).position == 0 && ((Mark)objectArray[0]).block != null) {
                ++n2;
                basicBlock = Maker.getBBlock((Mark)objectArray[0]);
            } else {
                basicBlock = this.makeBlock(0);
            }
            arrayList.add(basicBlock);
            while (n2 < objectArray.length) {
                Object object;
                BasicBlock basicBlock2;
                if ((basicBlock2 = Maker.getBBlock((Mark)(object = objectArray[n2++]))) == null) {
                    if (basicBlock.length > 0) {
                        basicBlock = this.makeBlock(basicBlock.position + basicBlock.length);
                        arrayList.add(basicBlock);
                    }
                    basicBlock.length = ((Mark)object).position + ((Mark)object).size - basicBlock.position;
                    basicBlock.exit = ((Mark)object).jump;
                    basicBlock.stop = ((Mark)object).alwaysJmp;
                    continue;
                }
                if (basicBlock.length == 0) {
                    basicBlock.length = ((Mark)object).position - basicBlock.position;
                    ++basicBlock2.incoming;
                    basicBlock.exit = this.makeArray(basicBlock2);
                } else if (basicBlock.position + basicBlock.length < ((Mark)object).position) {
                    basicBlock = this.makeBlock(basicBlock.position + basicBlock.length);
                    arrayList.add(basicBlock);
                    basicBlock.length = ((Mark)object).position - basicBlock.position;
                    basicBlock.stop = true;
                    basicBlock.exit = this.makeArray(basicBlock2);
                }
                arrayList.add(basicBlock2);
                basicBlock = basicBlock2;
            }
            return arrayList.toArray(this.makeArray(arrayList.size()));
        }

        private static BasicBlock getBBlock(Mark m2) {
            BasicBlock basicBlock = m2.block;
            if (basicBlock != null && m2.size > 0) {
                basicBlock.exit = m2.jump;
                basicBlock.length = m2.size;
                basicBlock.stop = m2.alwaysJmp;
            }
            return basicBlock;
        }

        private void addCatchers(BasicBlock[] blocks, ExceptionTable et) throws BadBytecode {
            if (et == null) {
                return;
            }
            int n2 = et.size();
            while (--n2 >= 0) {
                BasicBlock basicBlock = BasicBlock.find(blocks, et.handlerPc(n2));
                int n3 = et.startPc(n2);
                int n4 = et.endPc(n2);
                int n5 = et.catchType(n2);
                --basicBlock.incoming;
                for (int i2 = 0; i2 < blocks.length; ++i2) {
                    BasicBlock basicBlock2 = blocks[i2];
                    int n6 = basicBlock2.position;
                    if (n3 > n6 || n6 >= n4) continue;
                    basicBlock2.toCatch = new Catch(basicBlock, n5, basicBlock2.toCatch);
                    ++basicBlock.incoming;
                }
            }
        }
    }

    static class Mark
    implements Comparable<Mark> {
        int position;
        BasicBlock block;
        BasicBlock[] jump;
        boolean alwaysJmp;
        int size;
        Catch catcher;

        Mark(int p2) {
            this.position = p2;
            this.block = null;
            this.jump = null;
            this.alwaysJmp = false;
            this.size = 0;
            this.catcher = null;
        }

        @Override
        public int compareTo(Mark obj) {
            if (obj == null) {
                return -1;
            }
            return this.position - obj.position;
        }

        void setJump(BasicBlock[] bb, int s2, boolean always) {
            this.jump = bb;
            this.size = s2;
            this.alwaysJmp = always;
        }
    }

    public static class Catch {
        public Catch next;
        public BasicBlock body;
        public int typeIndex;

        Catch(BasicBlock b2, int i2, Catch c2) {
            this.body = b2;
            this.typeIndex = i2;
            this.next = c2;
        }
    }

    static class JsrBytecode
    extends BadBytecode {
        private static final long serialVersionUID = 1L;

        JsrBytecode() {
            super("JSR");
        }
    }
}

