/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.bytecode.stackmap;

import ai.h2o.javassist.ClassPool;
import ai.h2o.javassist.CtClass;
import ai.h2o.javassist.NotFoundException;
import ai.h2o.javassist.bytecode.BadBytecode;
import ai.h2o.javassist.bytecode.ConstPool;
import ai.h2o.javassist.bytecode.Descriptor;
import ai.h2o.javassist.bytecode.stackmap.TypeTag;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class TypeData {
    public static TypeData[] make(int size) {
        TypeData[] typeDataArray = new TypeData[size];
        for (int i2 = 0; i2 < size; ++i2) {
            typeDataArray[i2] = TypeTag.TOP;
        }
        return typeDataArray;
    }

    protected TypeData() {
    }

    private static void setType(TypeData td, String className, ClassPool cp) throws BadBytecode {
        td.setType(className, cp);
    }

    public abstract int getTypeTag();

    public abstract int getTypeData(ConstPool var1);

    public TypeData join() {
        return new TypeVar(this);
    }

    public abstract BasicType isBasicType();

    public abstract boolean is2WordType();

    public boolean isNullType() {
        return false;
    }

    public boolean isUninit() {
        return false;
    }

    public abstract boolean eq(TypeData var1);

    public abstract String getName();

    public abstract void setType(String var1, ClassPool var2) throws BadBytecode;

    public abstract TypeData getArrayType(int var1) throws NotFoundException;

    public int dfs(List<TypeData> order, int index, ClassPool cp) throws NotFoundException {
        return index;
    }

    protected TypeVar toTypeVar(int dim) {
        return null;
    }

    public void constructorCalled(int offset) {
    }

    public String toString() {
        return super.toString() + "(" + this.toString2(new HashSet<TypeData>()) + ")";
    }

    abstract String toString2(Set<TypeData> var1);

    public static CtClass commonSuperClassEx(CtClass one, CtClass two) throws NotFoundException {
        if (one == two) {
            return one;
        }
        if (one.isArray() && two.isArray()) {
            CtClass ctClass;
            CtClass ctClass2 = one.getComponentType();
            CtClass ctClass3 = TypeData.commonSuperClassEx(ctClass2, ctClass = two.getComponentType());
            if (ctClass3 == ctClass2) {
                return one;
            }
            if (ctClass3 == ctClass) {
                return two;
            }
            return one.getClassPool().get(ctClass3 == null ? "java.lang.Object" : ctClass3.getName() + "[]");
        }
        if (one.isPrimitive() || two.isPrimitive()) {
            return null;
        }
        if (one.isArray() || two.isArray()) {
            return one.getClassPool().get("java.lang.Object");
        }
        return TypeData.commonSuperClass(one, two);
    }

    public static CtClass commonSuperClass(CtClass one, CtClass two) throws NotFoundException {
        CtClass ctClass;
        CtClass ctClass2 = one;
        CtClass ctClass3 = ctClass = two;
        CtClass ctClass4 = ctClass2;
        while (true) {
            if (TypeData.eq(ctClass2, ctClass) && ctClass2.getSuperclass() != null) {
                return ctClass2;
            }
            CtClass ctClass5 = ctClass2.getSuperclass();
            CtClass ctClass6 = ctClass.getSuperclass();
            if (ctClass6 == null) {
                ctClass = ctClass3;
                break;
            }
            if (ctClass5 == null) {
                ctClass2 = ctClass4;
                ctClass4 = ctClass3;
                ctClass3 = ctClass2;
                ctClass2 = ctClass;
                ctClass = ctClass3;
                break;
            }
            ctClass2 = ctClass5;
            ctClass = ctClass6;
        }
        while ((ctClass2 = ctClass2.getSuperclass()) != null) {
            ctClass4 = ctClass4.getSuperclass();
        }
        ctClass2 = ctClass4;
        while (!TypeData.eq(ctClass2, ctClass)) {
            ctClass2 = ctClass2.getSuperclass();
            ctClass = ctClass.getSuperclass();
        }
        return ctClass2;
    }

    static boolean eq(CtClass one, CtClass two) {
        return one == two || one != null && two != null && one.getName().equals(two.getName());
    }

    public static void aastore(TypeData array, TypeData value, ClassPool cp) throws BadBytecode {
        if (array instanceof AbsTypeVar && !value.isNullType()) {
            ((AbsTypeVar)array).merge(ArrayType.make(value));
        }
        if (value instanceof AbsTypeVar) {
            if (array instanceof AbsTypeVar) {
                ArrayElement.make(array);
                return;
            }
            if (array instanceof ClassName) {
                if (!array.isNullType()) {
                    String string = ArrayElement.typeName(array.getName());
                    value.setType(string, cp);
                    return;
                }
            } else {
                throw new BadBytecode("bad AASTORE: " + array);
            }
        }
    }

    public static class UninitThis
    extends UninitData {
        UninitThis(String className) {
            super(-1, className);
        }

        @Override
        public UninitData copy() {
            return new UninitThis(this.getName());
        }

        @Override
        public int getTypeTag() {
            return 6;
        }

        @Override
        public int getTypeData(ConstPool cp) {
            return 0;
        }

        @Override
        String toString2(Set<TypeData> set) {
            return "uninit:this";
        }
    }

    public static class UninitData
    extends ClassName {
        int offset;
        boolean initialized;

        UninitData(int offset, String className) {
            super(className);
            this.offset = offset;
            this.initialized = false;
        }

        public UninitData copy() {
            return new UninitData(this.offset, this.getName());
        }

        @Override
        public int getTypeTag() {
            return 8;
        }

        @Override
        public int getTypeData(ConstPool cp) {
            return this.offset;
        }

        @Override
        public TypeData join() {
            if (this.initialized) {
                return new TypeVar(new ClassName(this.getName()));
            }
            return new UninitTypeVar(this.copy());
        }

        @Override
        public boolean isUninit() {
            return true;
        }

        @Override
        public boolean eq(TypeData d2) {
            if (d2 instanceof UninitData) {
                UninitData uninitData = (UninitData)d2;
                return this.offset == uninitData.offset && this.getName().equals(uninitData.getName());
            }
            return false;
        }

        public int offset() {
            return this.offset;
        }

        @Override
        public void constructorCalled(int offset) {
            if (offset == this.offset) {
                this.initialized = true;
            }
        }

        @Override
        String toString2(Set<TypeData> set) {
            return this.getName() + "," + this.offset;
        }
    }

    public static class NullType
    extends ClassName {
        public NullType() {
            super("null-type");
        }

        @Override
        public int getTypeTag() {
            return 5;
        }

        @Override
        public boolean isNullType() {
            return true;
        }

        @Override
        public int getTypeData(ConstPool cp) {
            return 0;
        }

        @Override
        public TypeData getArrayType(int dim) {
            return this;
        }
    }

    public static class ClassName
    extends TypeData {
        private String name;

        public ClassName(String n2) {
            this.name = n2;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public BasicType isBasicType() {
            return null;
        }

        @Override
        public boolean is2WordType() {
            return false;
        }

        @Override
        public int getTypeTag() {
            return 7;
        }

        @Override
        public int getTypeData(ConstPool cp) {
            return cp.addClassInfo(this.getName());
        }

        @Override
        public boolean eq(TypeData d2) {
            return this.name.equals(d2.getName());
        }

        @Override
        public void setType(String typeName, ClassPool cp) throws BadBytecode {
        }

        @Override
        public TypeData getArrayType(int dim) throws NotFoundException {
            int n2;
            if (dim == 0) {
                return this;
            }
            if (dim > 0) {
                char[] cArray = new char[dim];
                for (int i2 = 0; i2 < dim; ++i2) {
                    cArray[i2] = 91;
                }
                String string = this.getName();
                if (string.charAt(0) != '[') {
                    string = "L" + string.replace('.', '/') + ";";
                }
                return new ClassName(new String(cArray) + string);
            }
            for (n2 = 0; n2 < -dim; ++n2) {
                if (this.name.charAt(n2) == '[') continue;
                throw new NotFoundException("no " + dim + " dimensional array type: " + this.getName());
            }
            char c2 = this.name.charAt(-dim);
            n2 = c2;
            if (c2 == '[') {
                return new ClassName(this.name.substring(-dim));
            }
            if (n2 == 76) {
                return new ClassName(this.name.substring(-dim + 1, this.name.length() - 1).replace('/', '.'));
            }
            if (n2 == TypeTag.DOUBLE.decodedName) {
                return TypeTag.DOUBLE;
            }
            if (n2 == TypeTag.FLOAT.decodedName) {
                return TypeTag.FLOAT;
            }
            if (n2 == TypeTag.LONG.decodedName) {
                return TypeTag.LONG;
            }
            return TypeTag.INTEGER;
        }

        @Override
        String toString2(Set<TypeData> set) {
            return this.name;
        }
    }

    public static class UninitTypeVar
    extends AbsTypeVar {
        protected TypeData type;

        public UninitTypeVar(UninitData t2) {
            this.type = t2;
        }

        @Override
        public int getTypeTag() {
            return this.type.getTypeTag();
        }

        @Override
        public int getTypeData(ConstPool cp) {
            return this.type.getTypeData(cp);
        }

        @Override
        public BasicType isBasicType() {
            return this.type.isBasicType();
        }

        @Override
        public boolean is2WordType() {
            return this.type.is2WordType();
        }

        @Override
        public boolean isUninit() {
            return this.type.isUninit();
        }

        @Override
        public boolean eq(TypeData d2) {
            return this.type.eq(d2);
        }

        @Override
        public String getName() {
            return this.type.getName();
        }

        @Override
        protected TypeVar toTypeVar(int dim) {
            return null;
        }

        @Override
        public TypeData join() {
            return this.type.join();
        }

        @Override
        public void setType(String s2, ClassPool cp) throws BadBytecode {
            this.type.setType(s2, cp);
        }

        @Override
        public void merge(TypeData t2) {
            if (!t2.eq(this.type)) {
                this.type = TypeTag.TOP;
            }
        }

        @Override
        public void constructorCalled(int offset) {
            this.type.constructorCalled(offset);
        }

        public int offset() {
            if (this.type instanceof UninitData) {
                return ((UninitData)this.type).offset;
            }
            throw new RuntimeException("not available");
        }

        @Override
        public TypeData getArrayType(int dim) throws NotFoundException {
            return this.type.getArrayType(dim);
        }

        @Override
        String toString2(Set<TypeData> set) {
            return "";
        }
    }

    public static class ArrayElement
    extends AbsTypeVar {
        private AbsTypeVar array;

        private ArrayElement(AbsTypeVar a2) {
            this.array = a2;
        }

        public static TypeData make(TypeData array) throws BadBytecode {
            if (array instanceof ArrayType) {
                return ((ArrayType)array).elementType();
            }
            if (array instanceof AbsTypeVar) {
                return new ArrayElement((AbsTypeVar)array);
            }
            if (array instanceof ClassName && !array.isNullType()) {
                return new ClassName(ArrayElement.typeName(array.getName()));
            }
            throw new BadBytecode("bad AASTORE: " + array);
        }

        @Override
        public void merge(TypeData t2) {
            try {
                if (!t2.isNullType()) {
                    this.array.merge(ArrayType.make(t2));
                }
                return;
            }
            catch (BadBytecode badBytecode) {
                throw new RuntimeException("fatal: " + badBytecode);
            }
        }

        @Override
        public String getName() {
            return ArrayElement.typeName(this.array.getName());
        }

        public AbsTypeVar arrayType() {
            return this.array;
        }

        @Override
        public BasicType isBasicType() {
            return null;
        }

        @Override
        public boolean is2WordType() {
            return false;
        }

        private static String typeName(String arrayType) {
            if (arrayType.length() > 1 && arrayType.charAt(0) == '[') {
                char c2 = arrayType.charAt(1);
                if (c2 == 'L') {
                    return arrayType.substring(2, arrayType.length() - 1).replace('/', '.');
                }
                if (c2 == '[') {
                    return arrayType.substring(1);
                }
            }
            return "java.lang.Object";
        }

        @Override
        public void setType(String s2, ClassPool cp) throws BadBytecode {
            this.array.setType(ArrayType.typeName(s2), cp);
        }

        @Override
        protected TypeVar toTypeVar(int dim) {
            return this.array.toTypeVar(dim - 1);
        }

        @Override
        public TypeData getArrayType(int dim) throws NotFoundException {
            return this.array.getArrayType(dim - 1);
        }

        @Override
        public int dfs(List<TypeData> order, int index, ClassPool cp) throws NotFoundException {
            return this.array.dfs(order, index, cp);
        }

        @Override
        String toString2(Set<TypeData> set) {
            return "*" + this.array.toString2(set);
        }
    }

    public static class ArrayType
    extends AbsTypeVar {
        private AbsTypeVar element;

        private ArrayType(AbsTypeVar elementType) {
            this.element = elementType;
        }

        static TypeData make(TypeData element) throws BadBytecode {
            if (element instanceof ArrayElement) {
                return ((ArrayElement)element).arrayType();
            }
            if (element instanceof AbsTypeVar) {
                return new ArrayType((AbsTypeVar)element);
            }
            if (element instanceof ClassName && !element.isNullType()) {
                return new ClassName(ArrayType.typeName(element.getName()));
            }
            throw new BadBytecode("bad AASTORE: " + element);
        }

        @Override
        public void merge(TypeData t2) {
            try {
                if (!t2.isNullType()) {
                    this.element.merge(ArrayElement.make(t2));
                }
                return;
            }
            catch (BadBytecode badBytecode) {
                throw new RuntimeException("fatal: " + badBytecode);
            }
        }

        @Override
        public String getName() {
            return ArrayType.typeName(this.element.getName());
        }

        public AbsTypeVar elementType() {
            return this.element;
        }

        @Override
        public BasicType isBasicType() {
            return null;
        }

        @Override
        public boolean is2WordType() {
            return false;
        }

        public static String typeName(String elementType) {
            if (elementType.charAt(0) == '[') {
                return "[" + elementType;
            }
            return "[L" + elementType.replace('.', '/') + ";";
        }

        @Override
        public void setType(String s2, ClassPool cp) throws BadBytecode {
            this.element.setType(ArrayElement.typeName(s2), cp);
        }

        @Override
        protected TypeVar toTypeVar(int dim) {
            return this.element.toTypeVar(dim + 1);
        }

        @Override
        public TypeData getArrayType(int dim) throws NotFoundException {
            return this.element.getArrayType(dim + 1);
        }

        @Override
        public int dfs(List<TypeData> order, int index, ClassPool cp) throws NotFoundException {
            return this.element.dfs(order, index, cp);
        }

        @Override
        String toString2(Set<TypeData> set) {
            return "[" + this.element.toString2(set);
        }
    }

    public static class TypeVar
    extends AbsTypeVar {
        protected List<TypeData> lowers = new ArrayList<TypeData>(2);
        protected List<TypeData> usedBy = new ArrayList<TypeData>(2);
        protected List<String> uppers = null;
        protected String fixedType;
        private boolean is2WordType;
        private int visited = 0;
        private int smallest = 0;
        private boolean inList = false;
        private int dimension = 0;

        public TypeVar(TypeData t2) {
            this.merge(t2);
            this.fixedType = null;
            this.is2WordType = t2.is2WordType();
        }

        @Override
        public String getName() {
            if (this.fixedType == null) {
                return this.lowers.get(0).getName();
            }
            return this.fixedType;
        }

        @Override
        public BasicType isBasicType() {
            if (this.fixedType == null) {
                return this.lowers.get(0).isBasicType();
            }
            return null;
        }

        @Override
        public boolean is2WordType() {
            if (this.fixedType == null) {
                return this.is2WordType;
            }
            return false;
        }

        @Override
        public boolean isNullType() {
            if (this.fixedType == null) {
                return this.lowers.get(0).isNullType();
            }
            return false;
        }

        @Override
        public boolean isUninit() {
            if (this.fixedType == null) {
                return this.lowers.get(0).isUninit();
            }
            return false;
        }

        @Override
        public void merge(TypeData t2) {
            this.lowers.add(t2);
            if (t2 instanceof TypeVar) {
                ((TypeVar)t2).usedBy.add(this);
            }
        }

        @Override
        public int getTypeTag() {
            if (this.fixedType == null) {
                return this.lowers.get(0).getTypeTag();
            }
            return super.getTypeTag();
        }

        @Override
        public int getTypeData(ConstPool cp) {
            if (this.fixedType == null) {
                return this.lowers.get(0).getTypeData(cp);
            }
            return super.getTypeData(cp);
        }

        @Override
        public void setType(String typeName, ClassPool cp) throws BadBytecode {
            if (this.uppers == null) {
                this.uppers = new ArrayList<String>();
            }
            this.uppers.add(typeName);
        }

        @Override
        protected TypeVar toTypeVar(int dim) {
            this.dimension = dim;
            return this;
        }

        @Override
        public TypeData getArrayType(int dim) throws NotFoundException {
            if (dim == 0) {
                return this;
            }
            BasicType basicType = this.isBasicType();
            if (basicType == null) {
                if (this.isNullType()) {
                    return new NullType();
                }
                return new ClassName(this.getName()).getArrayType(dim);
            }
            return basicType.getArrayType(dim);
        }

        @Override
        public int dfs(List<TypeData> preOrder, int index, ClassPool cp) throws NotFoundException {
            TypeVar typeVar;
            if (this.visited > 0) {
                return index;
            }
            TypeVar typeVar2 = this;
            typeVar2.visited = typeVar2.smallest = ++index;
            preOrder.add(this);
            this.inList = true;
            int n2 = this.lowers.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                typeVar = this.lowers.get(i2).toTypeVar(this.dimension);
                if (typeVar == null) continue;
                if (typeVar.visited == 0) {
                    index = typeVar.dfs(preOrder, index, cp);
                    if (typeVar.smallest >= this.smallest) continue;
                    this.smallest = typeVar.smallest;
                    continue;
                }
                if (!typeVar.inList || typeVar.visited >= this.smallest) continue;
                this.smallest = typeVar.visited;
            }
            if (this.visited == this.smallest) {
                ArrayList<TypeData> arrayList = new ArrayList<TypeData>();
                do {
                    List<TypeData> list = preOrder;
                    typeVar = (TypeVar)list.remove(list.size() - 1);
                    ((TypeVar)list.remove(list.size() - 1)).inList = false;
                    arrayList.add(typeVar);
                } while (typeVar != this);
                this.fixTypes(arrayList, cp);
            }
            return index;
        }

        private void fixTypes(List<TypeData> scc, ClassPool cp) throws NotFoundException {
            HashSet<String> hashSet = new HashSet<String>();
            boolean bl = false;
            TypeData typeData = null;
            int n2 = scc.size();
            block0: for (int i2 = 0; i2 < n2; ++i2) {
                TypeVar typeVar = (TypeVar)scc.get(i2);
                List<TypeData> list = typeVar.lowers;
                int n3 = list.size();
                for (int i3 = 0; i3 < n3; ++i3) {
                    TypeData typeData2 = list.get(i3);
                    TypeData typeData3 = typeData2.getArrayType(typeVar.dimension);
                    BasicType basicType = typeData3.isBasicType();
                    if (typeData == null) {
                        if (basicType == null) {
                            bl = false;
                            typeData = typeData3;
                            if (typeData3.isUninit()) {
                                continue block0;
                            }
                        } else {
                            bl = true;
                            typeData = basicType;
                        }
                    } else if (basicType == null && bl || basicType != null && typeData != basicType) {
                        bl = true;
                        typeData = TypeTag.TOP;
                        continue block0;
                    }
                    if (basicType != null || typeData3.isNullType()) continue;
                    hashSet.add(typeData3.getName());
                }
            }
            if (bl) {
                this.is2WordType = typeData.is2WordType();
                this.fixTypes1(scc, typeData);
                return;
            }
            String string = this.fixTypes2(scc, hashSet, cp);
            this.fixTypes1(scc, new ClassName(string));
        }

        private void fixTypes1(List<TypeData> scc, TypeData kind) throws NotFoundException {
            int n2 = scc.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                TypeVar typeVar = (TypeVar)scc.get(i2);
                TypeData typeData = kind.getArrayType(-typeVar.dimension);
                if (typeData.isBasicType() == null) {
                    typeVar.fixedType = typeData.getName();
                    continue;
                }
                typeVar.lowers.clear();
                typeVar.lowers.add(typeData);
                typeVar.is2WordType = typeData.is2WordType();
            }
        }

        private String fixTypes2(List<TypeData> scc, Set<String> lowersSet, ClassPool cp) throws NotFoundException {
            Iterator<String> iterator = lowersSet.iterator();
            if (lowersSet.size() == 0) {
                return null;
            }
            if (lowersSet.size() == 1) {
                return iterator.next();
            }
            CtClass ctClass = cp.get(iterator.next());
            while (iterator.hasNext()) {
                ctClass = TypeVar.commonSuperClassEx(ctClass, cp.get(iterator.next()));
            }
            if (ctClass.getSuperclass() == null || TypeVar.isObjectArray(ctClass)) {
                ctClass = this.fixByUppers(scc, cp, new HashSet<TypeData>(), ctClass);
            }
            if (ctClass.isArray()) {
                return Descriptor.toJvmName(ctClass);
            }
            return ctClass.getName();
        }

        private static boolean isObjectArray(CtClass cc) throws NotFoundException {
            return cc.isArray() && cc.getComponentType().getSuperclass() == null;
        }

        private CtClass fixByUppers(List<TypeData> users, ClassPool cp, Set<TypeData> visited, CtClass type) throws NotFoundException {
            if (users == null) {
                return type;
            }
            int n2 = users.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                TypeVar typeVar = (TypeVar)users.get(i2);
                if (!visited.add(typeVar)) {
                    return type;
                }
                if (typeVar.uppers != null) {
                    int n3 = typeVar.uppers.size();
                    for (int i3 = 0; i3 < n3; ++i3) {
                        CtClass ctClass = cp.get(typeVar.uppers.get(i3));
                        if (!ctClass.subtypeOf(type)) continue;
                        type = ctClass;
                    }
                }
                type = this.fixByUppers(typeVar.usedBy, cp, visited, type);
            }
            return type;
        }

        @Override
        String toString2(Set<TypeData> hash) {
            TypeData typeData;
            hash.add(this);
            if (this.lowers.size() > 0 && (typeData = this.lowers.get(0)) != null && !hash.contains(typeData)) {
                return typeData.toString2(hash);
            }
            return "?";
        }
    }

    public static abstract class AbsTypeVar
    extends TypeData {
        public abstract void merge(TypeData var1);

        @Override
        public int getTypeTag() {
            return 7;
        }

        @Override
        public int getTypeData(ConstPool cp) {
            return cp.addClassInfo(this.getName());
        }

        @Override
        public boolean eq(TypeData d2) {
            return this.getName().equals(d2.getName());
        }
    }

    protected static class BasicType
    extends TypeData {
        private String name;
        private int typeTag;
        private char decodedName;

        public BasicType(String type, int tag, char decoded) {
            this.name = type;
            this.typeTag = tag;
            this.decodedName = decoded;
        }

        @Override
        public int getTypeTag() {
            return this.typeTag;
        }

        @Override
        public int getTypeData(ConstPool cp) {
            return 0;
        }

        @Override
        public TypeData join() {
            if (this == TypeTag.TOP) {
                return this;
            }
            return super.join();
        }

        @Override
        public BasicType isBasicType() {
            return this;
        }

        @Override
        public boolean is2WordType() {
            return this.typeTag == 4 || this.typeTag == 3;
        }

        @Override
        public boolean eq(TypeData d2) {
            return this == d2;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public char getDecodedName() {
            return this.decodedName;
        }

        @Override
        public void setType(String s2, ClassPool cp) throws BadBytecode {
            throw new BadBytecode("conflict: " + this.name + " and " + s2);
        }

        @Override
        public TypeData getArrayType(int dim) throws NotFoundException {
            if (this == TypeTag.TOP) {
                return this;
            }
            if (dim < 0) {
                throw new NotFoundException("no element type: " + this.name);
            }
            if (dim == 0) {
                return this;
            }
            char[] cArray = new char[dim + 1];
            for (int i2 = 0; i2 < dim; ++i2) {
                cArray[i2] = 91;
            }
            cArray[dim] = this.decodedName;
            return new ClassName(new String(cArray));
        }

        @Override
        String toString2(Set<TypeData> set) {
            return this.name;
        }
    }
}

