/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.compiler;

import ai.h2o.javassist.bytecode.Bytecode;
import ai.h2o.javassist.bytecode.Opcode;
import ai.h2o.javassist.compiler.CompileError;
import ai.h2o.javassist.compiler.MemberResolver;
import ai.h2o.javassist.compiler.TokenId;
import ai.h2o.javassist.compiler.TypeChecker;
import ai.h2o.javassist.compiler.ast.ASTList;
import ai.h2o.javassist.compiler.ast.ASTree;
import ai.h2o.javassist.compiler.ast.ArrayInit;
import ai.h2o.javassist.compiler.ast.AssignExpr;
import ai.h2o.javassist.compiler.ast.BinExpr;
import ai.h2o.javassist.compiler.ast.CallExpr;
import ai.h2o.javassist.compiler.ast.CastExpr;
import ai.h2o.javassist.compiler.ast.CondExpr;
import ai.h2o.javassist.compiler.ast.Declarator;
import ai.h2o.javassist.compiler.ast.DoubleConst;
import ai.h2o.javassist.compiler.ast.Expr;
import ai.h2o.javassist.compiler.ast.FieldDecl;
import ai.h2o.javassist.compiler.ast.InstanceOfExpr;
import ai.h2o.javassist.compiler.ast.IntConst;
import ai.h2o.javassist.compiler.ast.Keyword;
import ai.h2o.javassist.compiler.ast.Member;
import ai.h2o.javassist.compiler.ast.MethodDecl;
import ai.h2o.javassist.compiler.ast.NewExpr;
import ai.h2o.javassist.compiler.ast.Pair;
import ai.h2o.javassist.compiler.ast.Stmnt;
import ai.h2o.javassist.compiler.ast.StringL;
import ai.h2o.javassist.compiler.ast.Symbol;
import ai.h2o.javassist.compiler.ast.Variable;
import ai.h2o.javassist.compiler.ast.Visitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class CodeGen
extends Visitor
implements Opcode,
TokenId {
    static final String javaLangObject = "java.lang.Object";
    static final String jvmJavaLangObject = "java/lang/Object";
    static final String javaLangString = "java.lang.String";
    static final String jvmJavaLangString = "java/lang/String";
    protected Bytecode bytecode;
    private int tempVar;
    TypeChecker typeChecker;
    protected boolean hasReturned;
    public boolean inStaticMethod;
    protected List<Integer> breakList;
    protected List<Integer> continueList;
    protected ReturnHook returnHooks;
    protected int exprType;
    protected int arrayDim;
    protected String className;
    static final int[] binOp = new int[]{43, 99, 98, 97, 96, 45, 103, 102, 101, 100, 42, 107, 106, 105, 104, 47, 111, 110, 109, 108, 37, 115, 114, 113, 112, 124, 0, 0, 129, 128, 94, 0, 0, 131, 130, 38, 0, 0, 127, 126, 364, 0, 0, 121, 120, 366, 0, 0, 123, 122, 370, 0, 0, 125, 124};
    private static final int[] ifOp = new int[]{358, 159, 160, 350, 160, 159, 357, 164, 163, 359, 162, 161, 60, 161, 162, 62, 163, 164};
    private static final int[] ifOp2 = new int[]{358, 153, 154, 350, 154, 153, 357, 158, 157, 359, 156, 155, 60, 155, 156, 62, 157, 158};
    private static final int P_DOUBLE = 0;
    private static final int P_FLOAT = 1;
    private static final int P_LONG = 2;
    private static final int P_INT = 3;
    private static final int P_OTHER = -1;
    private static final int[] castOp = new int[]{0, 144, 143, 142, 141, 0, 140, 139, 138, 137, 0, 136, 135, 134, 133, 0};

    public CodeGen(Bytecode b2) {
        this.bytecode = b2;
        this.tempVar = -1;
        this.typeChecker = null;
        this.hasReturned = false;
        this.inStaticMethod = false;
        this.breakList = null;
        this.continueList = null;
        this.returnHooks = null;
    }

    public void setTypeChecker(TypeChecker checker) {
        this.typeChecker = checker;
    }

    protected static void fatal() throws CompileError {
        throw new CompileError("fatal");
    }

    public static boolean is2word(int type, int dim) {
        return dim == 0 && (type == 312 || type == 326);
    }

    public int getMaxLocals() {
        return this.bytecode.getMaxLocals();
    }

    public void setMaxLocals(int n2) {
        this.bytecode.setMaxLocals(n2);
    }

    protected void incMaxLocals(int size) {
        this.bytecode.incMaxLocals(size);
    }

    protected int getTempVar() {
        if (this.tempVar < 0) {
            this.tempVar = this.getMaxLocals();
            this.incMaxLocals(2);
        }
        return this.tempVar;
    }

    protected int getLocalVar(Declarator d2) {
        int n2 = d2.getLocalVar();
        if (n2 < 0) {
            n2 = this.getMaxLocals();
            d2.setLocalVar(n2);
            this.incMaxLocals(1);
        }
        return n2;
    }

    protected abstract String getThisName();

    protected abstract String getSuperName() throws CompileError;

    protected abstract String resolveClassName(ASTList var1) throws CompileError;

    protected abstract String resolveClassName(String var1) throws CompileError;

    protected static String toJvmArrayName(String name, int dim) {
        if (name == null) {
            return null;
        }
        if (dim == 0) {
            return name;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = dim;
        while (n2-- > 0) {
            stringBuffer.append('[');
        }
        stringBuffer.append('L');
        stringBuffer.append(name);
        stringBuffer.append(';');
        return stringBuffer.toString();
    }

    protected static String toJvmTypeName(int type, int dim) {
        char c2 = 'I';
        switch (type) {
            case 301: {
                c2 = 'Z';
                break;
            }
            case 303: {
                c2 = 'B';
                break;
            }
            case 306: {
                c2 = 'C';
                break;
            }
            case 334: {
                c2 = 'S';
                break;
            }
            case 324: {
                c2 = 'I';
                break;
            }
            case 326: {
                c2 = 'J';
                break;
            }
            case 317: {
                c2 = 'F';
                break;
            }
            case 312: {
                c2 = 'D';
                break;
            }
            case 344: {
                c2 = 'V';
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (dim-- > 0) {
            stringBuffer.append('[');
        }
        stringBuffer.append(c2);
        return stringBuffer.toString();
    }

    public void compileExpr(ASTree expr) throws CompileError {
        this.doTypeCheck(expr);
        expr.accept(this);
    }

    public boolean compileBooleanExpr(boolean branchIf, ASTree expr) throws CompileError {
        this.doTypeCheck(expr);
        return this.booleanExpr(branchIf, expr);
    }

    public void doTypeCheck(ASTree expr) throws CompileError {
        if (this.typeChecker != null) {
            expr.accept(this.typeChecker);
        }
    }

    @Override
    public void atASTList(ASTList n2) throws CompileError {
        CodeGen.fatal();
    }

    @Override
    public void atPair(Pair n2) throws CompileError {
        CodeGen.fatal();
    }

    @Override
    public void atSymbol(Symbol n2) throws CompileError {
        CodeGen.fatal();
    }

    @Override
    public void atFieldDecl(FieldDecl field) throws CompileError {
        field.getInit().accept(this);
    }

    @Override
    public void atMethodDecl(MethodDecl method) throws CompileError {
        ASTree aSTree;
        this.setMaxLocals(1);
        for (ASTList aSTList = method.getModifiers(); aSTList != null; aSTList = aSTList.tail()) {
            aSTree = (Keyword)aSTList.head();
            if (((Keyword)aSTree).get() != 335) continue;
            this.setMaxLocals(0);
            this.inStaticMethod = true;
        }
        for (aSTree = method.getParams(); aSTree != null; aSTree = ((ASTList)aSTree).tail()) {
            this.atDeclarator((Declarator)((ASTList)aSTree).head());
        }
        Stmnt stmnt = method.getBody();
        this.atMethodBody(stmnt, method.isConstructor(), method.getReturn().getType() == 344);
    }

    public void atMethodBody(Stmnt s2, boolean isCons, boolean isVoid) throws CompileError {
        if (s2 == null) {
            return;
        }
        if (isCons && this.needsSuperCall(s2)) {
            this.insertDefaultSuperCall();
        }
        this.hasReturned = false;
        s2.accept(this);
        if (!this.hasReturned) {
            if (isVoid) {
                this.bytecode.addOpcode(177);
                this.hasReturned = true;
                return;
            }
            throw new CompileError("no return statement");
        }
    }

    private boolean needsSuperCall(Stmnt body) throws CompileError {
        ASTree aSTree;
        ASTree aSTree2;
        if (body.getOperator() == 66) {
            body = (Stmnt)body.head();
        }
        if (body != null && body.getOperator() == 69 && (aSTree2 = body.head()) != null && aSTree2 instanceof Expr && ((Expr)aSTree2).getOperator() == 67 && (aSTree = ((Expr)aSTree2).head()) instanceof Keyword) {
            int n2 = ((Keyword)aSTree).get();
            return n2 != 339 && n2 != 336;
        }
        return true;
    }

    protected abstract void insertDefaultSuperCall() throws CompileError;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public void atStmnt(Stmnt st) throws CompileError {
        if (st == null) {
            return;
        }
        int n2 = st.getOperator();
        if (n2 == 69) {
            ASTree aSTree = st.getLeft();
            this.doTypeCheck(aSTree);
            if (aSTree instanceof AssignExpr) {
                this.atAssignExpr((AssignExpr)aSTree, false);
                return;
            }
            if (CodeGen.isPlusPlusExpr(aSTree)) {
                Expr expr = (Expr)aSTree;
                this.atPlusPlus(expr.getOperator(), expr.oprand1(), expr, false);
                return;
            }
            aSTree.accept(this);
            if (CodeGen.is2word(this.exprType, this.arrayDim)) {
                this.bytecode.addOpcode(88);
                return;
            }
            if (this.exprType == 344) return;
            this.bytecode.addOpcode(87);
            return;
        }
        if (n2 == 68 || n2 == 66) {
            void var3_5;
            Stmnt stmnt = st;
            while (var3_5 != null) {
                ASTree aSTree = var3_5.head();
                ASTList aSTList = var3_5.tail();
                if (aSTree == null) continue;
                aSTree.accept(this);
            }
            return;
        }
        if (n2 == 320) {
            this.atIfStmnt(st);
            return;
        }
        if (n2 == 346 || n2 == 311) {
            this.atWhileStmnt(st, n2 == 346);
            return;
        }
        if (n2 == 318) {
            this.atForStmnt(st);
            return;
        }
        if (n2 == 302 || n2 == 309) {
            this.atBreakStmnt(st, n2 == 302);
            return;
        }
        if (n2 == 333) {
            this.atReturnStmnt(st);
            return;
        }
        if (n2 == 340) {
            this.atThrowStmnt(st);
            return;
        }
        if (n2 == 343) {
            this.atTryStmnt(st);
            return;
        }
        if (n2 == 337) {
            this.atSwitchStmnt(st);
            return;
        }
        if (n2 == 338) {
            this.atSyncStmnt(st);
            return;
        }
        this.hasReturned = false;
        throw new CompileError("sorry, not supported statement: TokenId " + n2);
    }

    private void atIfStmnt(Stmnt st) throws CompileError {
        ASTree aSTree = st.head();
        Stmnt stmnt = (Stmnt)st.tail().head();
        Stmnt stmnt2 = (Stmnt)st.tail().tail().head();
        if (this.compileBooleanExpr(false, aSTree)) {
            this.hasReturned = false;
            if (stmnt2 != null) {
                stmnt2.accept(this);
            }
            return;
        }
        int n2 = this.bytecode.currentPc();
        int n3 = 0;
        this.bytecode.addIndex(0);
        this.hasReturned = false;
        if (stmnt != null) {
            stmnt.accept(this);
        }
        boolean bl = this.hasReturned;
        this.hasReturned = false;
        if (stmnt2 != null && !bl) {
            this.bytecode.addOpcode(167);
            n3 = this.bytecode.currentPc();
            this.bytecode.addIndex(0);
        }
        Bytecode bytecode = this.bytecode;
        bytecode.write16bit(n2, bytecode.currentPc() - n2 + 1);
        if (stmnt2 != null) {
            stmnt2.accept(this);
            if (!bl) {
                Bytecode bytecode2 = this.bytecode;
                bytecode2.write16bit(n3, bytecode2.currentPc() - n3 + 1);
            }
            this.hasReturned = bl && this.hasReturned;
        }
    }

    private void atWhileStmnt(Stmnt st, boolean notDo) throws CompileError {
        boolean bl;
        List<Integer> list = this.breakList;
        List<Integer> list2 = this.continueList;
        this.breakList = new ArrayList<Integer>();
        this.continueList = new ArrayList<Integer>();
        ASTree aSTree = st.head();
        Stmnt stmnt = (Stmnt)st.tail();
        int n2 = 0;
        if (notDo) {
            this.bytecode.addOpcode(167);
            n2 = this.bytecode.currentPc();
            this.bytecode.addIndex(0);
        }
        int n3 = this.bytecode.currentPc();
        if (stmnt != null) {
            stmnt.accept(this);
        }
        int n4 = this.bytecode.currentPc();
        if (notDo) {
            this.bytecode.write16bit(n2, n4 - n2 + 1);
        }
        if (bl = this.compileBooleanExpr(true, aSTree)) {
            this.bytecode.addOpcode(167);
            bl = this.breakList.size() == 0;
        }
        Bytecode bytecode = this.bytecode;
        bytecode.addIndex(n3 - bytecode.currentPc() + 1);
        CodeGen codeGen = this;
        codeGen.patchGoto(codeGen.breakList, this.bytecode.currentPc());
        CodeGen codeGen2 = this;
        codeGen2.patchGoto(codeGen2.continueList, n4);
        this.continueList = list2;
        this.breakList = list;
        this.hasReturned = bl;
    }

    protected void patchGoto(List<Integer> list, int targetPc) {
        for (int n2 : list) {
            this.bytecode.write16bit(n2, targetPc - n2 + 1);
        }
    }

    private void atForStmnt(Stmnt st) throws CompileError {
        List<Integer> list = this.breakList;
        List<Integer> list2 = this.continueList;
        this.breakList = new ArrayList<Integer>();
        this.continueList = new ArrayList<Integer>();
        Stmnt stmnt = (Stmnt)st.head();
        ASTList aSTList = st.tail();
        ASTree aSTree = aSTList.head();
        aSTList = aSTList.tail();
        Stmnt stmnt2 = (Stmnt)aSTList.head();
        Stmnt stmnt3 = (Stmnt)aSTList.tail();
        if (stmnt != null) {
            stmnt.accept(this);
        }
        int n2 = this.bytecode.currentPc();
        int n3 = 0;
        if (aSTree != null) {
            if (this.compileBooleanExpr(false, aSTree)) {
                this.continueList = list2;
                this.breakList = list;
                this.hasReturned = false;
                return;
            }
            n3 = this.bytecode.currentPc();
            this.bytecode.addIndex(0);
        }
        if (stmnt3 != null) {
            stmnt3.accept(this);
        }
        int n4 = this.bytecode.currentPc();
        if (stmnt2 != null) {
            stmnt2.accept(this);
        }
        this.bytecode.addOpcode(167);
        Bytecode bytecode = this.bytecode;
        bytecode.addIndex(n2 - bytecode.currentPc() + 1);
        int n5 = this.bytecode.currentPc();
        if (aSTree != null) {
            this.bytecode.write16bit(n3, n5 - n3 + 1);
        }
        CodeGen codeGen = this;
        codeGen.patchGoto(codeGen.breakList, n5);
        CodeGen codeGen2 = this;
        codeGen2.patchGoto(codeGen2.continueList, n4);
        this.continueList = list2;
        this.breakList = list;
        this.hasReturned = false;
    }

    private void atSwitchStmnt(Stmnt st) throws CompileError {
        int n2;
        boolean bl = false;
        if (this.typeChecker != null) {
            this.doTypeCheck(st.head());
            bl = this.typeChecker.exprType == 307 && this.typeChecker.arrayDim == 0 && jvmJavaLangString.equals(this.typeChecker.className);
        }
        this.compileExpr(st.head());
        int n3 = -1;
        if (bl) {
            n3 = this.getMaxLocals();
            this.incMaxLocals(1);
            this.bytecode.addAstore(n3);
            this.bytecode.addAload(n3);
            this.bytecode.addInvokevirtual(jvmJavaLangString, "hashCode", "()I");
        }
        List<Integer> list = this.breakList;
        this.breakList = new ArrayList<Integer>();
        int n4 = this.bytecode.currentPc();
        this.bytecode.addOpcode(171);
        int n5 = 3 - (n4 & 3);
        while (n5-- > 0) {
            this.bytecode.add(0);
        }
        Stmnt stmnt = (Stmnt)st.tail();
        int n6 = 0;
        for (ASTList aSTList = stmnt; aSTList != null; aSTList = aSTList.tail()) {
            if (((Stmnt)aSTList.head()).getOperator() != 304) continue;
            ++n6;
        }
        int n7 = this.bytecode.currentPc();
        this.bytecode.addGap(4);
        this.bytecode.add32bit(n6);
        this.bytecode.addGap(n6 << 3);
        long[] lArray = new long[n6];
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n8 = 0;
        int n9 = -1;
        for (ASTList aSTList = stmnt; aSTList != null; aSTList = aSTList.tail()) {
            Stmnt stmnt2 = (Stmnt)aSTList.head();
            int n10 = stmnt2.getOperator();
            if (n10 == 310) {
                n9 = this.bytecode.currentPc();
            } else if (n10 != 304) {
                CodeGen.fatal();
            } else {
                int n11 = this.bytecode.currentPc();
                long l2 = bl ? (long)this.computeStringLabel(stmnt2.head(), n3, arrayList) : (long)this.computeLabel(stmnt2.head());
                lArray[n8++] = (l2 << 32) + (long)(n11 - n4);
            }
            this.hasReturned = false;
            ((Stmnt)stmnt2.tail()).accept(this);
        }
        Arrays.sort(lArray);
        int n12 = n7 + 8;
        for (n2 = 0; n2 < n6; ++n2) {
            this.bytecode.write32bit(n12, (int)(lArray[n2] >>> 32));
            this.bytecode.write32bit(n12 + 4, (int)lArray[n2]);
            n12 += 8;
        }
        if (n9 < 0 || this.breakList.size() > 0) {
            this.hasReturned = false;
        }
        n2 = this.bytecode.currentPc();
        if (n9 < 0) {
            n9 = n2;
        }
        this.bytecode.write32bit(n7, n9 - n4);
        for (int n11 : arrayList) {
            this.bytecode.write16bit(n11, n9 - n11 + 1);
        }
        CodeGen codeGen = this;
        codeGen.patchGoto(codeGen.breakList, n2);
        this.breakList = list;
    }

    private int computeLabel(ASTree expr) throws CompileError {
        this.doTypeCheck(expr);
        expr = TypeChecker.stripPlusExpr(expr);
        if (expr instanceof IntConst) {
            return (int)((IntConst)expr).get();
        }
        throw new CompileError("bad case label");
    }

    private int computeStringLabel(ASTree expr, int tmpVar, List<Integer> gotoDefaults) throws CompileError {
        this.doTypeCheck(expr);
        expr = TypeChecker.stripPlusExpr(expr);
        if (expr instanceof StringL) {
            String string = ((StringL)expr).get();
            this.bytecode.addAload(tmpVar);
            this.bytecode.addLdc(string);
            this.bytecode.addInvokevirtual(jvmJavaLangString, "equals", "(Ljava/lang/Object;)Z");
            this.bytecode.addOpcode(153);
            Integer n2 = this.bytecode.currentPc();
            this.bytecode.addIndex(0);
            gotoDefaults.add(n2);
            return string.hashCode();
        }
        throw new CompileError("bad case label");
    }

    private void atBreakStmnt(Stmnt st, boolean notCont) throws CompileError {
        if (st.head() != null) {
            throw new CompileError("sorry, not support labeled break or continue");
        }
        this.bytecode.addOpcode(167);
        Integer n2 = this.bytecode.currentPc();
        this.bytecode.addIndex(0);
        if (notCont) {
            this.breakList.add(n2);
            return;
        }
        this.continueList.add(n2);
    }

    protected void atReturnStmnt(Stmnt st) throws CompileError {
        this.atReturnStmnt2(st.getLeft());
    }

    protected final void atReturnStmnt2(ASTree result) throws CompileError {
        int n2;
        if (result == null) {
            n2 = 177;
        } else {
            int n3;
            this.compileExpr(result);
            n2 = this.arrayDim > 0 ? 176 : ((n3 = this.exprType) == 312 ? 175 : (n3 == 317 ? 174 : (n3 == 326 ? 173 : (CodeGen.isRefType(n3) ? 176 : 172))));
        }
        ReturnHook returnHook = this.returnHooks;
        while (returnHook != null) {
            if (returnHook.doit(this.bytecode, n2)) {
                this.hasReturned = true;
                return;
            }
            returnHook = returnHook.next;
        }
        this.bytecode.addOpcode(n2);
        this.hasReturned = true;
    }

    private void atThrowStmnt(Stmnt st) throws CompileError {
        ASTree aSTree = st.getLeft();
        this.compileExpr(aSTree);
        if (this.exprType != 307 || this.arrayDim > 0) {
            throw new CompileError("bad throw statement");
        }
        this.bytecode.addOpcode(191);
        this.hasReturned = true;
    }

    protected void atTryStmnt(Stmnt st) throws CompileError {
        this.hasReturned = false;
    }

    private void atSyncStmnt(Stmnt st) throws CompileError {
        int n2 = CodeGen.getListSize(this.breakList);
        int n3 = CodeGen.getListSize(this.continueList);
        this.compileExpr(st.head());
        if (this.exprType != 307 && this.arrayDim == 0) {
            throw new CompileError("bad type expr for synchronized block");
        }
        Bytecode bytecode = this.bytecode;
        final int n4 = bytecode.getMaxLocals();
        bytecode.incMaxLocals(1);
        bytecode.addOpcode(89);
        bytecode.addAstore(n4);
        bytecode.addOpcode(194);
        CodeGen codeGen = this;
        ReturnHook returnHook = new ReturnHook(codeGen){

            @Override
            protected boolean doit(Bytecode b2, int opcode) {
                b2.addAload(n4);
                b2.addOpcode(195);
                return false;
            }
        };
        int n5 = bytecode.currentPc();
        Stmnt stmnt = (Stmnt)st.tail();
        if (stmnt != null) {
            stmnt.accept(this);
        }
        int n6 = bytecode.currentPc();
        int n7 = 0;
        if (!this.hasReturned) {
            returnHook.doit(bytecode, 0);
            bytecode.addOpcode(167);
            n7 = bytecode.currentPc();
            bytecode.addIndex(0);
        }
        if (n5 < n6) {
            int n8 = bytecode.currentPc();
            returnHook.doit(bytecode, 0);
            bytecode.addOpcode(191);
            bytecode.addExceptionHandler(n5, n6, n8, 0);
        }
        if (!this.hasReturned) {
            bytecode.write16bit(n7, bytecode.currentPc() - n7 + 1);
        }
        returnHook.remove(this);
        if (CodeGen.getListSize(this.breakList) != n2 || CodeGen.getListSize(this.continueList) != n3) {
            throw new CompileError("sorry, cannot break/continue in synchronized block");
        }
    }

    private static int getListSize(List<Integer> list) {
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    private static boolean isPlusPlusExpr(ASTree expr) {
        if (expr instanceof Expr) {
            int n2 = ((Expr)expr).getOperator();
            return n2 == 362 || n2 == 363;
        }
        return false;
    }

    @Override
    public void atDeclarator(Declarator d2) throws CompileError {
        d2.setLocalVar(this.getMaxLocals());
        d2.setClassName(this.resolveClassName(d2.getClassName()));
        int n2 = CodeGen.is2word(d2.getType(), d2.getArrayDim()) ? 2 : 1;
        this.incMaxLocals(n2);
        ASTree aSTree = d2.getInitializer();
        if (aSTree != null) {
            this.doTypeCheck(aSTree);
            this.atVariableAssign(null, 61, null, d2, aSTree, false);
        }
    }

    @Override
    public abstract void atNewExpr(NewExpr var1) throws CompileError;

    @Override
    public abstract void atArrayInit(ArrayInit var1) throws CompileError;

    @Override
    public void atAssignExpr(AssignExpr expr) throws CompileError {
        this.atAssignExpr(expr, true);
    }

    protected void atAssignExpr(AssignExpr expr, boolean doDup) throws CompileError {
        Expr expr2;
        int n2 = expr.getOperator();
        ASTree aSTree = expr.oprand1();
        ASTree aSTree2 = expr.oprand2();
        if (aSTree instanceof Variable) {
            this.atVariableAssign(expr, n2, (Variable)aSTree, ((Variable)aSTree).getDeclarator(), aSTree2, doDup);
            return;
        }
        if (aSTree instanceof Expr && (expr2 = (Expr)aSTree).getOperator() == 65) {
            this.atArrayAssign(expr, n2, (Expr)aSTree, aSTree2, doDup);
            return;
        }
        this.atFieldAssign(expr, n2, aSTree, aSTree2, doDup);
    }

    protected static void badAssign(Expr expr) throws CompileError {
        String string = expr == null ? "incompatible type for assignment" : "incompatible type for " + expr.getName();
        throw new CompileError(string);
    }

    private void atVariableAssign(Expr expr, int op, Variable var, Declarator d2, ASTree right, boolean doDup) throws CompileError {
        int n2 = d2.getType();
        int n3 = d2.getArrayDim();
        String string = d2.getClassName();
        int n4 = this.getLocalVar(d2);
        if (op != 61) {
            this.atVariable(var);
        }
        if (expr == null && right instanceof ArrayInit) {
            this.atArrayVariableAssign((ArrayInit)right, n2, n3, string);
        } else {
            this.atAssignCore(expr, op, right, n2, n3, string);
        }
        if (doDup) {
            if (CodeGen.is2word(n2, n3)) {
                this.bytecode.addOpcode(92);
            } else {
                this.bytecode.addOpcode(89);
            }
        }
        if (n3 > 0) {
            this.bytecode.addAstore(n4);
        } else if (n2 == 312) {
            this.bytecode.addDstore(n4);
        } else if (n2 == 317) {
            this.bytecode.addFstore(n4);
        } else if (n2 == 326) {
            this.bytecode.addLstore(n4);
        } else if (CodeGen.isRefType(n2)) {
            this.bytecode.addAstore(n4);
        } else {
            this.bytecode.addIstore(n4);
        }
        this.exprType = n2;
        this.arrayDim = n3;
        this.className = string;
    }

    protected abstract void atArrayVariableAssign(ArrayInit var1, int var2, int var3, String var4) throws CompileError;

    private void atArrayAssign(Expr expr, int op, Expr array, ASTree right, boolean doDup) throws CompileError {
        this.arrayAccess(array.oprand1(), array.oprand2());
        if (op != 61) {
            this.bytecode.addOpcode(92);
            this.bytecode.addOpcode(CodeGen.getArrayReadOp(this.exprType, this.arrayDim));
        }
        int n2 = this.exprType;
        int n3 = this.arrayDim;
        String string = this.className;
        this.atAssignCore(expr, op, right, n2, n3, string);
        if (doDup) {
            if (CodeGen.is2word(n2, n3)) {
                this.bytecode.addOpcode(94);
            } else {
                this.bytecode.addOpcode(91);
            }
        }
        this.bytecode.addOpcode(CodeGen.getArrayWriteOp(n2, n3));
        this.exprType = n2;
        this.arrayDim = n3;
        this.className = string;
    }

    protected abstract void atFieldAssign(Expr var1, int var2, ASTree var3, ASTree var4, boolean var5) throws CompileError;

    protected void atAssignCore(Expr expr, int op, ASTree right, int type, int dim, String cname) throws CompileError {
        if (op == 354 && dim == 0 && type == 307) {
            this.atStringPlusEq(expr, type, dim, cname, right);
        } else {
            right.accept(this);
            CodeGen codeGen = this;
            if (codeGen.invalidDim(codeGen.exprType, this.arrayDim, this.className, type, dim, cname, false) || op != 61 && dim > 0) {
                CodeGen.badAssign(expr);
            }
            if (op != 61) {
                int n2 = assignOps[op - 351];
                int n3 = CodeGen.lookupBinOp(n2);
                if (n3 < 0) {
                    CodeGen.fatal();
                }
                this.atArithBinExpr(expr, n2, n3, type);
            }
        }
        if (op != 61 || dim == 0 && !CodeGen.isRefType(type)) {
            CodeGen codeGen = this;
            codeGen.atNumCastExpr(codeGen.exprType, type);
        }
    }

    private void atStringPlusEq(Expr expr, int type, int dim, String cname, ASTree right) throws CompileError {
        if (!jvmJavaLangString.equals(cname)) {
            CodeGen.badAssign(expr);
        }
        this.convToString(type, dim);
        right.accept(this);
        CodeGen codeGen = this;
        codeGen.convToString(codeGen.exprType, this.arrayDim);
        this.bytecode.addInvokevirtual(javaLangString, "concat", "(Ljava/lang/String;)Ljava/lang/String;");
        this.exprType = 307;
        this.arrayDim = 0;
        this.className = jvmJavaLangString;
    }

    private boolean invalidDim(int srcType, int srcDim, String srcClass, int destType, int destDim, String destClass, boolean isCast) {
        if (srcDim != destDim) {
            if (srcType == 412) {
                return false;
            }
            if (destDim == 0 && destType == 307 && jvmJavaLangObject.equals(destClass)) {
                return false;
            }
            return !isCast || srcDim != 0 || srcType != 307 || !jvmJavaLangObject.equals(srcClass);
        }
        return false;
    }

    @Override
    public void atCondExpr(CondExpr expr) throws CompileError {
        if (this.booleanExpr(false, expr.condExpr())) {
            expr.elseExpr().accept(this);
            return;
        }
        int n2 = this.bytecode.currentPc();
        this.bytecode.addIndex(0);
        expr.thenExpr().accept(this);
        int n3 = this.arrayDim;
        this.bytecode.addOpcode(167);
        int n4 = this.bytecode.currentPc();
        this.bytecode.addIndex(0);
        Bytecode bytecode = this.bytecode;
        bytecode.write16bit(n2, bytecode.currentPc() - n2 + 1);
        expr.elseExpr().accept(this);
        if (n3 != this.arrayDim) {
            throw new CompileError("type mismatch in ?:");
        }
        Bytecode bytecode2 = this.bytecode;
        bytecode2.write16bit(n4, bytecode2.currentPc() - n4 + 1);
    }

    static int lookupBinOp(int token) {
        int[] nArray = binOp;
        int n2 = binOp.length;
        for (int i2 = 0; i2 < n2; i2 += 5) {
            if (nArray[i2] != token) continue;
            return i2;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void atBinExpr(BinExpr expr) throws CompileError {
        int n2 = expr.getOperator();
        int n3 = CodeGen.lookupBinOp(n2);
        if (n3 >= 0) {
            expr.oprand1().accept(this);
            ASTree aSTree = expr.oprand2();
            if (aSTree == null) {
                return;
            }
            int n4 = this.exprType;
            int n5 = this.arrayDim;
            String string = this.className;
            aSTree.accept(this);
            if (n5 != this.arrayDim) {
                throw new CompileError("incompatible array types");
            }
            if (n2 == 43 && n5 == 0 && (n4 == 307 || this.exprType == 307)) {
                this.atStringConcatExpr(expr, n4, n5, string);
                return;
            }
            this.atArithBinExpr(expr, n2, n3, n4);
            return;
        }
        if (!this.booleanExpr(true, expr)) {
            this.bytecode.addIndex(7);
            this.bytecode.addIconst(0);
            this.bytecode.addOpcode(167);
            this.bytecode.addIndex(4);
        }
        this.bytecode.addIconst(1);
    }

    private void atArithBinExpr(Expr expr, int token, int index, int type1) throws CompileError {
        int n2;
        if (this.arrayDim != 0) {
            CodeGen.badTypes(expr);
        }
        int n3 = this.exprType;
        if (token == 364 || token == 366 || token == 370) {
            if (n3 == 324 || n3 == 334 || n3 == 306 || n3 == 303) {
                this.exprType = type1;
            } else {
                CodeGen.badTypes(expr);
            }
        } else {
            this.convertOprandTypes(type1, n3, expr);
        }
        int n4 = CodeGen.typePrecedence(this.exprType);
        if (n4 >= 0 && (n2 = binOp[index + n4 + 1]) != 0) {
            if (n4 == 3 && this.exprType != 301) {
                this.exprType = 324;
            }
            this.bytecode.addOpcode(n2);
            return;
        }
        CodeGen.badTypes(expr);
    }

    private void atStringConcatExpr(Expr expr, int type1, int dim1, String cname1) throws CompileError {
        boolean bl;
        int n2 = this.exprType;
        int n3 = this.arrayDim;
        boolean bl2 = CodeGen.is2word(n2, n3);
        boolean bl3 = bl = n2 == 307 && jvmJavaLangString.equals(this.className);
        if (bl2) {
            this.convToString(n2, n3);
        }
        if (CodeGen.is2word(type1, dim1)) {
            this.bytecode.addOpcode(91);
            this.bytecode.addOpcode(87);
        } else {
            this.bytecode.addOpcode(95);
        }
        this.convToString(type1, dim1);
        this.bytecode.addOpcode(95);
        if (!bl2 && !bl) {
            this.convToString(n2, n3);
        }
        this.bytecode.addInvokevirtual(javaLangString, "concat", "(Ljava/lang/String;)Ljava/lang/String;");
        this.exprType = 307;
        this.arrayDim = 0;
        this.className = jvmJavaLangString;
    }

    private void convToString(int type, int dim) throws CompileError {
        if (CodeGen.isRefType(type) || dim > 0) {
            this.bytecode.addInvokestatic(javaLangString, "valueOf", "(Ljava/lang/Object;)Ljava/lang/String;");
            return;
        }
        if (type == 312) {
            this.bytecode.addInvokestatic(javaLangString, "valueOf", "(D)Ljava/lang/String;");
            return;
        }
        if (type == 317) {
            this.bytecode.addInvokestatic(javaLangString, "valueOf", "(F)Ljava/lang/String;");
            return;
        }
        if (type == 326) {
            this.bytecode.addInvokestatic(javaLangString, "valueOf", "(J)Ljava/lang/String;");
            return;
        }
        if (type == 301) {
            this.bytecode.addInvokestatic(javaLangString, "valueOf", "(Z)Ljava/lang/String;");
            return;
        }
        if (type == 306) {
            this.bytecode.addInvokestatic(javaLangString, "valueOf", "(C)Ljava/lang/String;");
            return;
        }
        if (type == 344) {
            throw new CompileError("void type expression");
        }
        this.bytecode.addInvokestatic(javaLangString, "valueOf", "(I)Ljava/lang/String;");
    }

    private boolean booleanExpr(boolean branchIf, ASTree expr) throws CompileError {
        block9: {
            int n2;
            while (true) {
                if ((n2 = CodeGen.getCompOperator(expr)) == 358) {
                    BinExpr binExpr = (BinExpr)expr;
                    int n3 = this.compileOprands(binExpr);
                    this.compareExpr(branchIf, binExpr.getOperator(), n3, binExpr);
                    break block9;
                }
                if (n2 != 33) break;
                expr = ((Expr)expr).oprand1();
                branchIf = !branchIf;
            }
            boolean bl = n2 == 369;
            if (bl || n2 == 368) {
                BinExpr binExpr;
                if (this.booleanExpr(!bl, (binExpr = (BinExpr)expr).oprand1())) {
                    this.exprType = 301;
                    this.arrayDim = 0;
                    return true;
                }
                int n4 = this.bytecode.currentPc();
                this.bytecode.addIndex(0);
                if (this.booleanExpr(bl, binExpr.oprand2())) {
                    this.bytecode.addOpcode(167);
                }
                Bytecode bytecode = this.bytecode;
                bytecode.write16bit(n4, bytecode.currentPc() - n4 + 3);
                if (branchIf != bl) {
                    this.bytecode.addIndex(6);
                    this.bytecode.addOpcode(167);
                }
            } else {
                if (CodeGen.isAlwaysBranch(expr, branchIf)) {
                    this.exprType = 301;
                    this.arrayDim = 0;
                    return true;
                }
                expr.accept(this);
                if (this.exprType != 301 || this.arrayDim != 0) {
                    throw new CompileError("boolean expr is required");
                }
                this.bytecode.addOpcode(branchIf ? 154 : 153);
            }
        }
        this.exprType = 301;
        this.arrayDim = 0;
        return false;
    }

    private static boolean isAlwaysBranch(ASTree expr, boolean branchIf) {
        if (expr instanceof Keyword) {
            int n2 = ((Keyword)expr).get();
            if (branchIf) {
                return n2 == 410;
            }
            return n2 == 411;
        }
        return false;
    }

    static int getCompOperator(ASTree expr) throws CompileError {
        if (expr instanceof Expr) {
            Expr expr2 = (Expr)expr;
            int n2 = expr2.getOperator();
            if (n2 == 33) {
                return 33;
            }
            if (expr2 instanceof BinExpr && n2 != 368 && n2 != 369 && n2 != 38 && n2 != 124) {
                return 358;
            }
            return n2;
        }
        return 32;
    }

    private int compileOprands(BinExpr expr) throws CompileError {
        expr.oprand1().accept(this);
        int n2 = this.exprType;
        int n3 = this.arrayDim;
        expr.oprand2().accept(this);
        if (n3 != this.arrayDim) {
            if (n2 != 412 && this.exprType != 412) {
                throw new CompileError("incompatible array types");
            }
            if (this.exprType == 412) {
                this.arrayDim = n3;
            }
        }
        if (n2 == 412) {
            return this.exprType;
        }
        return n2;
    }

    private void compareExpr(boolean branchIf, int token, int type1, BinExpr expr) throws CompileError {
        int n2;
        if (this.arrayDim == 0) {
            this.convertOprandTypes(type1, this.exprType, expr);
        }
        if ((n2 = CodeGen.typePrecedence(this.exprType)) == -1 || this.arrayDim > 0) {
            if (token == 358) {
                this.bytecode.addOpcode(branchIf ? 165 : 166);
                return;
            }
            if (token == 350) {
                this.bytecode.addOpcode(branchIf ? 166 : 165);
                return;
            }
            CodeGen.badTypes(expr);
            return;
        }
        if (n2 == 3) {
            int[] nArray = ifOp;
            for (int i2 = 0; i2 < nArray.length; i2 += 3) {
                if (nArray[i2] != token) continue;
                this.bytecode.addOpcode(nArray[i2 + (branchIf ? 1 : 2)]);
                return;
            }
            CodeGen.badTypes(expr);
            return;
        }
        if (n2 == 0) {
            if (token == 60 || token == 357) {
                this.bytecode.addOpcode(152);
            } else {
                this.bytecode.addOpcode(151);
            }
        } else if (n2 == 1) {
            if (token == 60 || token == 357) {
                this.bytecode.addOpcode(150);
            } else {
                this.bytecode.addOpcode(149);
            }
        } else if (n2 == 2) {
            this.bytecode.addOpcode(148);
        } else {
            CodeGen.fatal();
        }
        int[] nArray = ifOp2;
        for (int i3 = 0; i3 < nArray.length; i3 += 3) {
            if (nArray[i3] != token) continue;
            this.bytecode.addOpcode(nArray[i3 + (branchIf ? 1 : 2)]);
            return;
        }
        CodeGen.badTypes(expr);
    }

    protected static void badTypes(Expr expr) throws CompileError {
        throw new CompileError("invalid types for " + expr.getName());
    }

    protected static boolean isRefType(int type) {
        return type == 307 || type == 412;
    }

    private static int typePrecedence(int type) {
        if (type == 312) {
            return 0;
        }
        if (type == 317) {
            return 1;
        }
        if (type == 326) {
            return 2;
        }
        if (CodeGen.isRefType(type)) {
            return -1;
        }
        if (type == 344) {
            return -1;
        }
        return 3;
    }

    static boolean isP_INT(int type) {
        return CodeGen.typePrecedence(type) == 3;
    }

    static boolean rightIsStrong(int type1, int type2) {
        int n2 = CodeGen.typePrecedence(type1);
        int n3 = CodeGen.typePrecedence(type2);
        return n2 >= 0 && n3 >= 0 && n2 > n3;
    }

    private void convertOprandTypes(int type1, int type2, Expr expr) throws CompileError {
        int n2;
        boolean bl;
        int n3 = CodeGen.typePrecedence(type1);
        int n4 = CodeGen.typePrecedence(type2);
        if (n4 < 0 && n3 < 0) {
            return;
        }
        if (n4 < 0 || n3 < 0) {
            CodeGen.badTypes(expr);
        }
        if (n3 <= n4) {
            bl = false;
            this.exprType = type1;
            n2 = castOp[(n4 << 2) + n3];
        } else {
            bl = true;
            n2 = castOp[(n3 << 2) + n4];
        }
        if (bl) {
            if (n4 == 0 || n4 == 2) {
                if (n3 == 0 || n3 == 2) {
                    this.bytecode.addOpcode(94);
                } else {
                    this.bytecode.addOpcode(93);
                }
                this.bytecode.addOpcode(88);
                this.bytecode.addOpcode(n2);
                this.bytecode.addOpcode(94);
                this.bytecode.addOpcode(88);
                return;
            }
            if (n4 == 1) {
                if (n3 == 2) {
                    this.bytecode.addOpcode(91);
                    this.bytecode.addOpcode(87);
                } else {
                    this.bytecode.addOpcode(95);
                }
                this.bytecode.addOpcode(n2);
                this.bytecode.addOpcode(95);
                return;
            }
            CodeGen.fatal();
            return;
        }
        if (n2 != 0) {
            this.bytecode.addOpcode(n2);
        }
    }

    @Override
    public void atCastExpr(CastExpr expr) throws CompileError {
        String string = this.resolveClassName(expr.getClassName());
        String string2 = this.checkCastExpr(expr, string);
        int n2 = this.exprType;
        this.exprType = expr.getType();
        this.arrayDim = expr.getArrayDim();
        this.className = string;
        if (string2 == null) {
            this.atNumCastExpr(n2, this.exprType);
            return;
        }
        this.bytecode.addCheckcast(string2);
    }

    @Override
    public void atInstanceOfExpr(InstanceOfExpr expr) throws CompileError {
        String string = this.resolveClassName(expr.getClassName());
        String string2 = this.checkCastExpr(expr, string);
        this.bytecode.addInstanceof(string2);
        this.exprType = 301;
        this.arrayDim = 0;
    }

    private String checkCastExpr(CastExpr expr, String name) throws CompileError {
        ASTree aSTree = expr.getOprand();
        int n2 = expr.getArrayDim();
        int n3 = expr.getType();
        aSTree.accept(this);
        int n4 = this.exprType;
        int n5 = this.arrayDim;
        if (this.invalidDim(n4, this.arrayDim, this.className, n3, n2, name, true) || n4 == 344 || n3 == 344) {
            throw new CompileError("invalid cast");
        }
        if (n3 == 307) {
            if (!CodeGen.isRefType(n4) && n5 == 0) {
                throw new CompileError("invalid cast");
            }
            return CodeGen.toJvmArrayName(name, n2);
        }
        if (n2 > 0) {
            return CodeGen.toJvmTypeName(n3, n2);
        }
        return null;
    }

    void atNumCastExpr(int srcType, int destType) throws CompileError {
        if (srcType == destType) {
            return;
        }
        int n2 = CodeGen.typePrecedence(srcType);
        int n3 = CodeGen.typePrecedence(destType);
        int n4 = n2 >= 0 && n2 < 3 ? castOp[(n2 << 2) + n3] : 0;
        int n5 = destType == 312 ? 135 : (destType == 317 ? 134 : (destType == 326 ? 133 : (destType == 334 ? 147 : (destType == 306 ? 146 : (destType == 303 ? 145 : 0)))));
        if (n4 != 0) {
            this.bytecode.addOpcode(n4);
        }
        if ((n4 == 0 || n4 == 136 || n4 == 139 || n4 == 142) && n5 != 0) {
            this.bytecode.addOpcode(n5);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void atExpr(Expr expr) throws CompileError {
        int n2 = expr.getOperator();
        ASTree aSTree = expr.oprand1();
        if (n2 == 46) {
            String string = ((Symbol)expr.oprand2()).get();
            if (string.equals("class")) {
                this.atClassObject(expr);
                return;
            }
            this.atFieldRead(expr);
            return;
        }
        if (n2 == 35) {
            this.atFieldRead(expr);
            return;
        }
        if (n2 == 65) {
            this.atArrayRead(aSTree, expr.oprand2());
            return;
        }
        if (n2 == 362 || n2 == 363) {
            this.atPlusPlus(n2, aSTree, expr, true);
            return;
        }
        if (n2 == 33) {
            if (!this.booleanExpr(false, expr)) {
                this.bytecode.addIndex(7);
                this.bytecode.addIconst(1);
                this.bytecode.addOpcode(167);
                this.bytecode.addIndex(4);
            }
            this.bytecode.addIconst(0);
            return;
        }
        if (n2 != 67) {
            expr.oprand1().accept(this);
            int n3 = CodeGen.typePrecedence(this.exprType);
            if (this.arrayDim > 0) {
                CodeGen.badType(expr);
            }
            if (n2 == 45) {
                if (n3 == 0) {
                    this.bytecode.addOpcode(119);
                    return;
                }
                if (n3 == 1) {
                    this.bytecode.addOpcode(118);
                    return;
                }
                if (n3 == 2) {
                    this.bytecode.addOpcode(117);
                    return;
                }
                if (n3 == 3) {
                    this.bytecode.addOpcode(116);
                    this.exprType = 324;
                    return;
                }
                CodeGen.badType(expr);
                return;
            }
            if (n2 == 126) {
                if (n3 == 3) {
                    this.bytecode.addIconst(-1);
                    this.bytecode.addOpcode(130);
                    this.exprType = 324;
                    return;
                }
                if (n3 == 2) {
                    this.bytecode.addLconst(-1L);
                    this.bytecode.addOpcode(131);
                    return;
                }
                CodeGen.badType(expr);
                return;
            }
            if (n2 == 43) {
                if (n3 != -1) return;
                CodeGen.badType(expr);
                return;
            }
        }
        CodeGen.fatal();
    }

    protected static void badType(Expr expr) throws CompileError {
        throw new CompileError("invalid type for " + expr.getName());
    }

    @Override
    public abstract void atCallExpr(CallExpr var1) throws CompileError;

    protected abstract void atFieldRead(ASTree var1) throws CompileError;

    public void atClassObject(Expr expr) throws CompileError {
        ASTree aSTree = expr.oprand1();
        if (!(aSTree instanceof Symbol)) {
            throw new CompileError("fatal error: badly parsed .class expr");
        }
        String string = ((Symbol)aSTree).get();
        if (string.startsWith("[")) {
            String string2;
            String string3;
            int n2 = string.indexOf("[L");
            if (n2 >= 0 && !(string3 = string.substring(n2 + 2, string.length() - 1)).equals(string2 = this.resolveClassName(string3))) {
                string2 = MemberResolver.jvmToJavaName(string2);
                StringBuffer stringBuffer = new StringBuffer();
                while (n2-- >= 0) {
                    stringBuffer.append('[');
                }
                stringBuffer.append('L').append(string2).append(';');
                string = stringBuffer.toString();
            }
        } else {
            string = this.resolveClassName(MemberResolver.javaToJvmName(string));
            string = MemberResolver.jvmToJavaName(string);
        }
        this.atClassObject2(string);
        this.exprType = 307;
        this.arrayDim = 0;
        this.className = "java/lang/Class";
    }

    protected void atClassObject2(String cname) throws CompileError {
        int n2 = this.bytecode.currentPc();
        this.bytecode.addLdc(cname);
        this.bytecode.addInvokestatic("java.lang.Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
        int n3 = this.bytecode.currentPc();
        this.bytecode.addOpcode(167);
        int n4 = this.bytecode.currentPc();
        this.bytecode.addIndex(0);
        this.bytecode.addExceptionHandler(n2, n3, this.bytecode.currentPc(), "java.lang.ClassNotFoundException");
        this.bytecode.growStack(1);
        this.bytecode.addInvokestatic("ai.h2o.javassist.runtime.DotClass", "fail", "(Ljava/lang/ClassNotFoundException;)Ljava/lang/NoClassDefFoundError;");
        this.bytecode.addOpcode(191);
        Bytecode bytecode = this.bytecode;
        bytecode.write16bit(n4, bytecode.currentPc() - n4 + 1);
    }

    public void atArrayRead(ASTree array, ASTree index) throws CompileError {
        this.arrayAccess(array, index);
        this.bytecode.addOpcode(CodeGen.getArrayReadOp(this.exprType, this.arrayDim));
    }

    protected void arrayAccess(ASTree array, ASTree index) throws CompileError {
        array.accept(this);
        int n2 = this.exprType;
        int n3 = this.arrayDim;
        if (n3 == 0) {
            throw new CompileError("bad array access");
        }
        String string = this.className;
        index.accept(this);
        if (CodeGen.typePrecedence(this.exprType) != 3 || this.arrayDim > 0) {
            throw new CompileError("bad array index");
        }
        this.exprType = n2;
        this.arrayDim = n3 - 1;
        this.className = string;
    }

    protected static int getArrayReadOp(int type, int dim) {
        if (dim > 0) {
            return 50;
        }
        switch (type) {
            case 312: {
                return 49;
            }
            case 317: {
                return 48;
            }
            case 326: {
                return 47;
            }
            case 324: {
                return 46;
            }
            case 334: {
                return 53;
            }
            case 306: {
                return 52;
            }
            case 301: 
            case 303: {
                return 51;
            }
        }
        return 50;
    }

    protected static int getArrayWriteOp(int type, int dim) {
        if (dim > 0) {
            return 83;
        }
        switch (type) {
            case 312: {
                return 82;
            }
            case 317: {
                return 81;
            }
            case 326: {
                return 80;
            }
            case 324: {
                return 79;
            }
            case 334: {
                return 86;
            }
            case 306: {
                return 85;
            }
            case 301: 
            case 303: {
                return 84;
            }
        }
        return 83;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void atPlusPlus(int token, ASTree oprand, Expr expr, boolean doDup) throws CompileError {
        Expr expr2;
        boolean bl = oprand == null;
        if (bl) {
            oprand = expr.oprand2();
        }
        if (oprand instanceof Variable) {
            int n2;
            Declarator declarator = ((Variable)oprand).getDeclarator();
            int n3 = this.exprType = declarator.getType();
            this.arrayDim = declarator.getArrayDim();
            int n4 = this.getLocalVar(declarator);
            if (this.arrayDim > 0) {
                CodeGen.badType(expr);
            }
            if (n3 == 312) {
                this.bytecode.addDload(n4);
                if (doDup && bl) {
                    this.bytecode.addOpcode(92);
                }
                this.bytecode.addDconst(1.0);
                this.bytecode.addOpcode(token == 362 ? 99 : 103);
                if (doDup && !bl) {
                    this.bytecode.addOpcode(92);
                }
                this.bytecode.addDstore(n4);
                return;
            }
            if (n3 == 326) {
                this.bytecode.addLload(n4);
                if (doDup && bl) {
                    this.bytecode.addOpcode(92);
                }
                this.bytecode.addLconst(1L);
                this.bytecode.addOpcode(token == 362 ? 97 : 101);
                if (doDup && !bl) {
                    this.bytecode.addOpcode(92);
                }
                this.bytecode.addLstore(n4);
                return;
            }
            if (n3 == 317) {
                this.bytecode.addFload(n4);
                if (doDup && bl) {
                    this.bytecode.addOpcode(89);
                }
                this.bytecode.addFconst(1.0f);
                this.bytecode.addOpcode(token == 362 ? 98 : 102);
                if (doDup && !bl) {
                    this.bytecode.addOpcode(89);
                }
                this.bytecode.addFstore(n4);
                return;
            }
            if (n3 != 303 && n3 != 306 && n3 != 334 && n3 != 324) {
                CodeGen.badType(expr);
                return;
            }
            if (doDup && bl) {
                this.bytecode.addIload(n4);
            }
            int n5 = n2 = token == 362 ? 1 : -1;
            if (n4 > 255) {
                this.bytecode.addOpcode(196);
                this.bytecode.addOpcode(132);
                this.bytecode.addIndex(n4);
                this.bytecode.addIndex(n2);
            } else {
                this.bytecode.addOpcode(132);
                this.bytecode.add(n4);
                this.bytecode.add(n2);
            }
            if (!doDup) return;
            if (bl) return;
            this.bytecode.addIload(n4);
            return;
        }
        if (oprand instanceof Expr && (expr2 = (Expr)oprand).getOperator() == 65) {
            this.atArrayPlusPlus(token, bl, expr2, doDup);
            return;
        }
        this.atFieldPlusPlus(token, bl, oprand, expr, doDup);
    }

    public void atArrayPlusPlus(int token, boolean isPost, Expr expr, boolean doDup) throws CompileError {
        this.arrayAccess(expr.oprand1(), expr.oprand2());
        int n2 = this.exprType;
        int n3 = this.arrayDim;
        if (n3 > 0) {
            CodeGen.badType(expr);
        }
        this.bytecode.addOpcode(92);
        this.bytecode.addOpcode(CodeGen.getArrayReadOp(n2, this.arrayDim));
        int n4 = CodeGen.is2word(n2, n3) ? 94 : 91;
        this.atPlusPlusCore(n4, doDup, token, isPost, expr);
        this.bytecode.addOpcode(CodeGen.getArrayWriteOp(n2, n3));
    }

    protected void atPlusPlusCore(int dup_code, boolean doDup, int token, boolean isPost, Expr expr) throws CompileError {
        int n2 = this.exprType;
        if (doDup && isPost) {
            this.bytecode.addOpcode(dup_code);
        }
        if (n2 == 324 || n2 == 303 || n2 == 306 || n2 == 334) {
            this.bytecode.addIconst(1);
            this.bytecode.addOpcode(token == 362 ? 96 : 100);
            this.exprType = 324;
        } else if (n2 == 326) {
            this.bytecode.addLconst(1L);
            this.bytecode.addOpcode(token == 362 ? 97 : 101);
        } else if (n2 == 317) {
            this.bytecode.addFconst(1.0f);
            this.bytecode.addOpcode(token == 362 ? 98 : 102);
        } else if (n2 == 312) {
            this.bytecode.addDconst(1.0);
            this.bytecode.addOpcode(token == 362 ? 99 : 103);
        } else {
            CodeGen.badType(expr);
        }
        if (doDup && !isPost) {
            this.bytecode.addOpcode(dup_code);
        }
    }

    protected abstract void atFieldPlusPlus(int var1, boolean var2, ASTree var3, Expr var4, boolean var5) throws CompileError;

    @Override
    public abstract void atMember(Member var1) throws CompileError;

    @Override
    public void atVariable(Variable v2) throws CompileError {
        Declarator declarator = v2.getDeclarator();
        this.exprType = declarator.getType();
        this.arrayDim = declarator.getArrayDim();
        this.className = declarator.getClassName();
        int n2 = this.getLocalVar(declarator);
        if (this.arrayDim > 0) {
            this.bytecode.addAload(n2);
            return;
        }
        switch (this.exprType) {
            case 307: {
                this.bytecode.addAload(n2);
                return;
            }
            case 326: {
                this.bytecode.addLload(n2);
                return;
            }
            case 317: {
                this.bytecode.addFload(n2);
                return;
            }
            case 312: {
                this.bytecode.addDload(n2);
                return;
            }
        }
        this.bytecode.addIload(n2);
    }

    @Override
    public void atKeyword(Keyword k2) throws CompileError {
        this.arrayDim = 0;
        int n2 = k2.get();
        switch (n2) {
            case 410: {
                this.bytecode.addIconst(1);
                this.exprType = 301;
                return;
            }
            case 411: {
                this.bytecode.addIconst(0);
                this.exprType = 301;
                return;
            }
            case 412: {
                this.bytecode.addOpcode(1);
                this.exprType = 412;
                return;
            }
            case 336: 
            case 339: {
                if (this.inStaticMethod) {
                    throw new CompileError("not-available: " + (n2 == 339 ? "this" : "super"));
                }
                this.bytecode.addAload(0);
                this.exprType = 307;
                if (n2 == 339) {
                    this.className = this.getThisName();
                    return;
                }
                this.className = this.getSuperName();
                return;
            }
        }
        CodeGen.fatal();
    }

    @Override
    public void atStringL(StringL s2) throws CompileError {
        this.exprType = 307;
        this.arrayDim = 0;
        this.className = jvmJavaLangString;
        this.bytecode.addLdc(s2.get());
    }

    @Override
    public void atIntConst(IntConst i2) throws CompileError {
        this.arrayDim = 0;
        long l2 = i2.get();
        int n2 = i2.getType();
        if (n2 == 402 || n2 == 401) {
            this.exprType = n2 == 402 ? 324 : 306;
            this.bytecode.addIconst((int)l2);
            return;
        }
        this.exprType = 326;
        this.bytecode.addLconst(l2);
    }

    @Override
    public void atDoubleConst(DoubleConst d2) throws CompileError {
        this.arrayDim = 0;
        if (d2.getType() == 405) {
            this.exprType = 312;
            this.bytecode.addDconst(d2.get());
            return;
        }
        this.exprType = 317;
        this.bytecode.addFconst((float)d2.get());
    }

    protected static abstract class ReturnHook {
        ReturnHook next;

        protected abstract boolean doit(Bytecode var1, int var2);

        protected ReturnHook(CodeGen gen) {
            this.next = gen.returnHooks;
            gen.returnHooks = this;
        }

        protected void remove(CodeGen gen) {
            gen.returnHooks = this.next;
        }
    }
}

