/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.compiler.ast;

import ai.h2o.javassist.compiler.CompileError;
import ai.h2o.javassist.compiler.TokenId;
import ai.h2o.javassist.compiler.ast.ASTList;
import ai.h2o.javassist.compiler.ast.ASTree;
import ai.h2o.javassist.compiler.ast.Visitor;

public class Expr
extends ASTList
implements TokenId {
    private static final long serialVersionUID = 1L;
    protected int operatorId;

    Expr(int op, ASTree _head, ASTList _tail) {
        super(_head, _tail);
        this.operatorId = op;
    }

    Expr(int op, ASTree _head) {
        super(_head);
        this.operatorId = op;
    }

    public static Expr make(int op, ASTree oprand1, ASTree oprand2) {
        return new Expr(op, oprand1, new ASTList(oprand2));
    }

    public static Expr make(int op, ASTree oprand1) {
        return new Expr(op, oprand1);
    }

    public int getOperator() {
        return this.operatorId;
    }

    public void setOperator(int op) {
        this.operatorId = op;
    }

    public ASTree oprand1() {
        return this.getLeft();
    }

    public void setOprand1(ASTree expr) {
        this.setLeft(expr);
    }

    public ASTree oprand2() {
        return this.getRight().getLeft();
    }

    public void setOprand2(ASTree expr) {
        this.getRight().setLeft(expr);
    }

    @Override
    public void accept(Visitor v2) throws CompileError {
        v2.atExpr(this);
    }

    public String getName() {
        int n2 = this.operatorId;
        if (n2 < 128) {
            return String.valueOf((char)n2);
        }
        if (350 <= n2 && n2 <= 371) {
            return opNames[n2 - 350];
        }
        if (n2 == 323) {
            return "instanceof";
        }
        return String.valueOf(n2);
    }

    @Override
    protected String getTag() {
        return "op:" + this.getName();
    }
}

