/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.convert;

import ai.h2o.javassist.ClassPool;
import ai.h2o.javassist.CtClass;
import ai.h2o.javassist.CtMethod;
import ai.h2o.javassist.Modifier;
import ai.h2o.javassist.NotFoundException;
import ai.h2o.javassist.bytecode.BadBytecode;
import ai.h2o.javassist.bytecode.CodeAttribute;
import ai.h2o.javassist.bytecode.CodeIterator;
import ai.h2o.javassist.bytecode.ConstPool;
import ai.h2o.javassist.convert.Transformer;

public class TransformCall
extends Transformer {
    protected String classname;
    protected String methodname;
    protected String methodDescriptor;
    protected String newClassname;
    protected String newMethodname;
    protected boolean newMethodIsPrivate;
    protected int newIndex;
    protected ConstPool constPool;

    public TransformCall(Transformer next, CtMethod origMethod, CtMethod substMethod) {
        this(next, origMethod.getName(), substMethod);
        this.classname = origMethod.getDeclaringClass().getName();
    }

    public TransformCall(Transformer next, String oldMethodName, CtMethod substMethod) {
        super(next);
        this.methodname = oldMethodName;
        this.methodDescriptor = substMethod.getMethodInfo2().getDescriptor();
        TransformCall transformCall = this;
        transformCall.classname = transformCall.newClassname = substMethod.getDeclaringClass().getName();
        this.newMethodname = substMethod.getName();
        this.constPool = null;
        this.newMethodIsPrivate = Modifier.isPrivate(substMethod.getModifiers());
    }

    @Override
    public void initialize(ConstPool cp, CodeAttribute attr) {
        if (this.constPool != cp) {
            this.newIndex = 0;
        }
    }

    @Override
    public int transform(CtClass clazz, int pos, CodeIterator iterator, ConstPool cp) throws BadBytecode {
        int n2;
        String string;
        int n3 = iterator.byteAt(pos);
        if ((n3 == 185 || n3 == 183 || n3 == 184 || n3 == 182) && (string = cp.eqMember(this.methodname, this.methodDescriptor, n2 = iterator.u16bitAt(pos + 1))) != null && this.matchClass(string, clazz.getClassPool())) {
            int n4 = cp.getMemberNameAndType(n2);
            pos = this.match(n3, pos, iterator, cp.getNameAndTypeDescriptor(n4), cp);
        }
        return pos;
    }

    private boolean matchClass(String name, ClassPool pool) {
        if (this.classname.equals(name)) {
            return true;
        }
        try {
            CtClass ctClass = pool.get(name);
            CtClass ctClass2 = pool.get(this.classname);
            if (ctClass.subtypeOf(ctClass2)) {
                try {
                    CtMethod ctMethod = ctClass.getMethod(this.methodname, this.methodDescriptor);
                    return ctMethod.getDeclaringClass().getName().equals(this.classname);
                }
                catch (NotFoundException notFoundException) {
                    return true;
                }
            }
        }
        catch (NotFoundException notFoundException) {
            return false;
        }
        return false;
    }

    protected int match(int c2, int pos, CodeIterator iterator, int typedesc, ConstPool cp) throws BadBytecode {
        if (this.newIndex == 0) {
            ConstPool constPool = cp;
            int n2 = constPool.addNameAndTypeInfo(constPool.addUtf8Info(this.newMethodname), typedesc);
            int n3 = cp.addClassInfo(this.newClassname);
            if (c2 == 185) {
                this.newIndex = cp.addInterfaceMethodrefInfo(n3, n2);
            } else {
                if (this.newMethodIsPrivate && c2 == 182) {
                    iterator.writeByte(183, pos);
                }
                this.newIndex = cp.addMethodrefInfo(n3, n2);
            }
            this.constPool = cp;
        }
        iterator.write16bit(this.newIndex, pos + 1);
        return pos;
    }
}

