/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.convert;

import ai.h2o.javassist.CtClass;
import ai.h2o.javassist.CtField;
import ai.h2o.javassist.Modifier;
import ai.h2o.javassist.bytecode.CodeAttribute;
import ai.h2o.javassist.bytecode.CodeIterator;
import ai.h2o.javassist.bytecode.ConstPool;
import ai.h2o.javassist.convert.TransformReadField;
import ai.h2o.javassist.convert.Transformer;

public final class TransformFieldAccess
extends Transformer {
    private String newClassname;
    private String newFieldname;
    private String fieldname;
    private CtClass fieldClass;
    private boolean isPrivate;
    private int newIndex;
    private ConstPool constPool;

    public TransformFieldAccess(Transformer next, CtField field, String newClassname, String newFieldname) {
        super(next);
        this.fieldClass = field.getDeclaringClass();
        this.fieldname = field.getName();
        this.isPrivate = Modifier.isPrivate(field.getModifiers());
        this.newClassname = newClassname;
        this.newFieldname = newFieldname;
        this.constPool = null;
    }

    @Override
    public final void initialize(ConstPool cp, CodeAttribute attr) {
        if (this.constPool != cp) {
            this.newIndex = 0;
        }
    }

    @Override
    public final int transform(CtClass clazz, int pos, CodeIterator iterator, ConstPool cp) {
        int n2 = iterator.byteAt(pos);
        if (n2 == 180 || n2 == 178 || n2 == 181 || n2 == 179) {
            int n3 = iterator.u16bitAt(pos + 1);
            String string = TransformReadField.isField(clazz.getClassPool(), cp, this.fieldClass, this.fieldname, this.isPrivate, n3);
            if (string != null) {
                if (this.newIndex == 0) {
                    int n4 = cp.addNameAndTypeInfo(this.newFieldname, string);
                    ConstPool constPool = cp;
                    this.newIndex = constPool.addFieldrefInfo(constPool.addClassInfo(this.newClassname), n4);
                    this.constPool = cp;
                }
                iterator.write16bit(this.newIndex, pos + 1);
            }
        }
        return pos;
    }
}

