/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.util.proxy;

import ai.h2o.javassist.CannotCompileException;
import ai.h2o.javassist.bytecode.Bytecode;
import ai.h2o.javassist.bytecode.ClassFile;
import ai.h2o.javassist.bytecode.CodeAttribute;
import ai.h2o.javassist.bytecode.ConstPool;
import ai.h2o.javassist.bytecode.Descriptor;
import ai.h2o.javassist.bytecode.DuplicateMemberException;
import ai.h2o.javassist.bytecode.ExceptionsAttribute;
import ai.h2o.javassist.bytecode.FieldInfo;
import ai.h2o.javassist.bytecode.MethodInfo;
import ai.h2o.javassist.bytecode.StackMapTable;
import ai.h2o.javassist.util.proxy.FactoryHelper;
import ai.h2o.javassist.util.proxy.MethodFilter;
import ai.h2o.javassist.util.proxy.MethodHandler;
import ai.h2o.javassist.util.proxy.Proxy;
import ai.h2o.javassist.util.proxy.ProxyObject;
import ai.h2o.javassist.util.proxy.RuntimeSupport;
import ai.h2o.javassist.util.proxy.SecurityActions;
import java.lang.invoke.MethodHandles;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class ProxyFactory {
    private Class<?> superClass = null;
    private Class<?>[] interfaces = null;
    private MethodFilter methodFilter = null;
    private MethodHandler handler = null;
    private List<Map.Entry<String, Method>> signatureMethods = null;
    private boolean hasGetHandler = false;
    private byte[] signature = null;
    private String classname;
    private String basename;
    private String superName;
    private Class<?> thisClass = null;
    private boolean factoryUseCache = useCache;
    private boolean factoryWriteReplace = useWriteReplace;
    public static boolean onlyPublicMethods = false;
    public String writeDirectory = null;
    private static final Class<?> OBJECT_TYPE = Object.class;
    private static final String HOLDER = "_methods_";
    private static final String HOLDER_TYPE = "[Ljava/lang/reflect/Method;";
    private static final String FILTER_SIGNATURE_FIELD = "_filter_signature";
    private static final String FILTER_SIGNATURE_TYPE = "[B";
    private static final String HANDLER = "handler";
    private static final String NULL_INTERCEPTOR_HOLDER = "ai.h2o.javassist.util.proxy.RuntimeSupport";
    private static final String DEFAULT_INTERCEPTOR = "default_interceptor";
    private static final String HANDLER_TYPE = "L" + MethodHandler.class.getName().replace('.', '/') + ';';
    private static final String HANDLER_SETTER = "setHandler";
    private static final String HANDLER_SETTER_TYPE = "(" + HANDLER_TYPE + ")V";
    private static final String HANDLER_GETTER = "getHandler";
    private static final String HANDLER_GETTER_TYPE = "()" + HANDLER_TYPE;
    private static final String SERIAL_VERSION_UID_FIELD = "serialVersionUID";
    private static final String SERIAL_VERSION_UID_TYPE = "J";
    private static final long SERIAL_VERSION_UID_VALUE = -1L;
    public static volatile boolean useCache = true;
    public static volatile boolean useWriteReplace = true;
    private static Map<ClassLoader, Map<String, ProxyDetails>> proxyCache = new WeakHashMap<ClassLoader, Map<String, ProxyDetails>>();
    private static char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static ClassLoaderProvider classLoaderProvider = new ClassLoaderProvider(){

        @Override
        public ClassLoader get(ProxyFactory pf) {
            return pf.getClassLoader0();
        }
    };
    public static UniqueName nameGenerator = new UniqueName(){
        private final String sep = "_$$_jvst" + Integer.toHexString(this.hashCode() & 0xFFF) + "_";
        private int counter = 0;

        @Override
        public String get(String classname) {
            return classname + this.sep + Integer.toHexString(this.counter++);
        }
    };
    private static final String packageForJavaBase = "ai.h2o.javassist.util.proxy.";
    private static Comparator<Map.Entry<String, Method>> sorter = new Comparator<Map.Entry<String, Method>>(){

        @Override
        public int compare(Map.Entry<String, Method> e1, Map.Entry<String, Method> e2) {
            return e1.getKey().compareTo(e2.getKey());
        }
    };
    private static final String HANDLER_GETTER_KEY = "getHandler:()";

    public boolean isUseCache() {
        return this.factoryUseCache;
    }

    public void setUseCache(boolean useCache) {
        if (this.handler != null && useCache) {
            throw new RuntimeException("caching cannot be enabled if the factory default interceptor has been set");
        }
        this.factoryUseCache = useCache;
    }

    public boolean isUseWriteReplace() {
        return this.factoryWriteReplace;
    }

    public void setUseWriteReplace(boolean useWriteReplace) {
        this.factoryWriteReplace = useWriteReplace;
    }

    public static boolean isProxyClass(Class<?> cl) {
        return Proxy.class.isAssignableFrom(cl);
    }

    public void setSuperclass(Class<?> clazz) {
        this.superClass = clazz;
        this.signature = null;
    }

    public Class<?> getSuperclass() {
        return this.superClass;
    }

    public void setInterfaces(Class<?>[] ifs) {
        this.interfaces = ifs;
        this.signature = null;
    }

    public Class<?>[] getInterfaces() {
        return this.interfaces;
    }

    public void setFilter(MethodFilter mf) {
        this.methodFilter = mf;
        this.signature = null;
    }

    public Class<?> createClass() {
        if (this.signature == null) {
            ProxyFactory proxyFactory = this;
            proxyFactory.computeSignature(proxyFactory.methodFilter);
        }
        return this.createClass1(null);
    }

    public Class<?> createClass(MethodFilter filter) {
        this.computeSignature(filter);
        return this.createClass1(null);
    }

    Class<?> createClass(byte[] signature) {
        this.installSignature(signature);
        return this.createClass1(null);
    }

    public Class<?> createClass(MethodHandles.Lookup lookup) {
        if (this.signature == null) {
            ProxyFactory proxyFactory = this;
            proxyFactory.computeSignature(proxyFactory.methodFilter);
        }
        return this.createClass1(lookup);
    }

    public Class<?> createClass(MethodHandles.Lookup lookup, MethodFilter filter) {
        this.computeSignature(filter);
        return this.createClass1(lookup);
    }

    Class<?> createClass(MethodHandles.Lookup lookup, byte[] signature) {
        this.installSignature(signature);
        return this.createClass1(lookup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> createClass1(MethodHandles.Lookup lookup) {
        Class<?> clazz = this.thisClass;
        if (clazz == null) {
            ClassLoader classLoader = this.getClassLoader();
            Map<ClassLoader, Map<String, ProxyDetails>> map = proxyCache;
            synchronized (map) {
                if (this.factoryUseCache) {
                    this.createClass2(classLoader, lookup);
                } else {
                    this.createClass3(classLoader, lookup);
                }
                clazz = this.thisClass;
                this.thisClass = null;
            }
        }
        return clazz;
    }

    public String getKey(Class<?> superClass, Class<?>[] interfaces, byte[] signature, boolean useWriteReplace) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        if (superClass != null) {
            stringBuffer.append(superClass.getName());
        }
        stringBuffer.append(":");
        for (n2 = 0; n2 < interfaces.length; ++n2) {
            stringBuffer.append(interfaces[n2].getName());
            stringBuffer.append(":");
        }
        for (n2 = 0; n2 < signature.length; ++n2) {
            byte by = signature[n2];
            int n3 = by & 0xF;
            int n4 = by >> 4 & 0xF;
            stringBuffer.append(hexDigits[n3]);
            stringBuffer.append(hexDigits[n4]);
        }
        if (useWriteReplace) {
            stringBuffer.append(":w");
        }
        return stringBuffer.toString();
    }

    private void createClass2(ClassLoader cl, MethodHandles.Lookup lookup) {
        ProxyDetails proxyDetails;
        ProxyFactory proxyFactory = this;
        String string = proxyFactory.getKey(proxyFactory.superClass, this.interfaces, this.signature, this.factoryWriteReplace);
        Map<String, ProxyDetails> map = proxyCache.get(cl);
        if (map == null) {
            map = new HashMap<String, ProxyDetails>();
            proxyCache.put(cl, map);
        }
        if ((proxyDetails = map.get(string)) != null) {
            Reference<Class<?>> reference = proxyDetails.proxyClass;
            this.thisClass = reference.get();
            if (this.thisClass != null) {
                return;
            }
        }
        this.createClass3(cl, lookup);
        proxyDetails = new ProxyDetails(this.signature, this.thisClass, this.factoryWriteReplace);
        map.put(string, proxyDetails);
    }

    private void createClass3(ClassLoader cl, MethodHandles.Lookup lookup) {
        this.allocateClassName();
        try {
            ClassFile classFile = this.make();
            if (this.writeDirectory != null) {
                FactoryHelper.writeFile(classFile, this.writeDirectory);
            }
            this.thisClass = lookup == null ? FactoryHelper.toClass(classFile, this.getClassInTheSamePackage(), cl, this.getDomain()) : FactoryHelper.toClass(classFile, lookup);
            this.setField(FILTER_SIGNATURE_FIELD, this.signature);
            if (!this.factoryUseCache) {
                this.setField(DEFAULT_INTERCEPTOR, this.handler);
            }
            return;
        }
        catch (CannotCompileException cannotCompileException) {
            throw new RuntimeException(cannotCompileException.getMessage(), cannotCompileException);
        }
    }

    private Class<?> getClassInTheSamePackage() {
        if (this.basename.startsWith(packageForJavaBase)) {
            return this.getClass();
        }
        if (this.superClass != null && this.superClass != OBJECT_TYPE) {
            return this.superClass;
        }
        if (this.interfaces != null && this.interfaces.length > 0) {
            return this.interfaces[0];
        }
        return this.getClass();
    }

    private void setField(String fieldName, Object value) {
        if (this.thisClass != null && value != null) {
            try {
                Field field = this.thisClass.getField(fieldName);
                SecurityActions.setAccessible(field, true);
                field.set(null, value);
                SecurityActions.setAccessible(field, false);
                return;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    static byte[] getFilterSignature(Class<?> clazz) {
        return (byte[])ProxyFactory.getField(clazz, FILTER_SIGNATURE_FIELD);
    }

    private static Object getField(Class<?> clazz, String fieldName) {
        try {
            Field field = clazz.getField(fieldName);
            field.setAccessible(true);
            Object object = field.get(null);
            field.setAccessible(false);
            return object;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static MethodHandler getHandler(Proxy p2) {
        try {
            Field field = p2.getClass().getDeclaredField(HANDLER);
            field.setAccessible(true);
            Object object = field.get(p2);
            field.setAccessible(false);
            return (MethodHandler)object;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    protected ClassLoader getClassLoader() {
        return classLoaderProvider.get(this);
    }

    protected ClassLoader getClassLoader0() {
        ClassLoader classLoader = null;
        if (this.superClass != null && !this.superClass.getName().equals("java.lang.Object")) {
            classLoader = this.superClass.getClassLoader();
        } else if (this.interfaces != null && this.interfaces.length > 0) {
            classLoader = this.interfaces[0].getClassLoader();
        }
        if (classLoader == null && (classLoader = this.getClass().getClassLoader()) == null && (classLoader = Thread.currentThread().getContextClassLoader()) == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    protected ProtectionDomain getDomain() {
        Class<?> clazz = this.superClass != null && !this.superClass.getName().equals("java.lang.Object") ? this.superClass : (this.interfaces != null && this.interfaces.length > 0 ? this.interfaces[0] : this.getClass());
        return clazz.getProtectionDomain();
    }

    public Object create(Class<?>[] paramTypes, Object[] args, MethodHandler mh) throws NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Object object = this.create(paramTypes, args);
        ((Proxy)object).setHandler(mh);
        return object;
    }

    public Object create(Class<?>[] paramTypes, Object[] args) throws NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = this.createClass();
        Constructor<?> constructor = clazz.getConstructor(paramTypes);
        return constructor.newInstance(args);
    }

    @Deprecated
    public void setHandler(MethodHandler mi) {
        if (this.factoryUseCache && mi != null) {
            this.factoryUseCache = false;
            this.thisClass = null;
        }
        this.handler = mi;
        this.setField(DEFAULT_INTERCEPTOR, this.handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String makeProxyName(String classname) {
        UniqueName uniqueName = nameGenerator;
        synchronized (uniqueName) {
            return nameGenerator.get(classname);
        }
    }

    private ClassFile make() throws CannotCompileException {
        FieldInfo fieldInfo;
        ClassFile classFile = new ClassFile(false, this.classname, this.superName);
        classFile.setAccessFlags(1);
        ProxyFactory.setInterfaces(classFile, this.interfaces, this.hasGetHandler ? Proxy.class : ProxyObject.class);
        ConstPool constPool = classFile.getConstPool();
        if (!this.factoryUseCache) {
            fieldInfo = new FieldInfo(constPool, DEFAULT_INTERCEPTOR, HANDLER_TYPE);
            fieldInfo.setAccessFlags(9);
            classFile.addField(fieldInfo);
        }
        fieldInfo = new FieldInfo(constPool, HANDLER, HANDLER_TYPE);
        fieldInfo.setAccessFlags(2);
        classFile.addField(fieldInfo);
        FieldInfo fieldInfo2 = new FieldInfo(constPool, FILTER_SIGNATURE_FIELD, FILTER_SIGNATURE_TYPE);
        fieldInfo2.setAccessFlags(9);
        classFile.addField(fieldInfo2);
        FieldInfo fieldInfo3 = new FieldInfo(constPool, SERIAL_VERSION_UID_FIELD, SERIAL_VERSION_UID_TYPE);
        fieldInfo3.setAccessFlags(25);
        classFile.addField(fieldInfo3);
        ProxyFactory proxyFactory = this;
        proxyFactory.makeConstructors(proxyFactory.classname, classFile, constPool, this.classname);
        ArrayList<Find2MethodsArgs> arrayList = new ArrayList<Find2MethodsArgs>();
        int n2 = this.overrideMethods(classFile, constPool, this.classname, arrayList);
        ProxyFactory.addClassInitializer(classFile, constPool, this.classname, n2, arrayList);
        ProxyFactory.addSetter(this.classname, classFile, constPool);
        if (!this.hasGetHandler) {
            ProxyFactory.addGetter(this.classname, classFile, constPool);
        }
        if (this.factoryWriteReplace) {
            try {
                classFile.addMethod(ProxyFactory.makeWriteReplace(constPool));
            }
            catch (DuplicateMemberException duplicateMemberException) {}
        }
        this.thisClass = null;
        return classFile;
    }

    private void checkClassAndSuperName() {
        if (this.interfaces == null) {
            this.interfaces = new Class[0];
        }
        if (this.superClass == null) {
            this.superClass = OBJECT_TYPE;
            this.superName = this.superClass.getName();
            this.basename = this.interfaces.length == 0 ? this.superName : this.interfaces[0].getName();
        } else {
            this.basename = this.superName = this.superClass.getName();
        }
        if (Modifier.isFinal(this.superClass.getModifiers())) {
            throw new RuntimeException(this.superName + " is final");
        }
        if (this.basename.startsWith("java.") || this.basename.startsWith("jdk.") || onlyPublicMethods) {
            this.basename = packageForJavaBase + this.basename.replace('.', '_');
        }
    }

    private void allocateClassName() {
        this.classname = ProxyFactory.makeProxyName(this.basename);
    }

    private void makeSortedMethodList() {
        this.checkClassAndSuperName();
        this.hasGetHandler = false;
        ProxyFactory proxyFactory = this;
        Map<String, Method> map = proxyFactory.getMethods(proxyFactory.superClass, this.interfaces);
        this.signatureMethods = new ArrayList<Map.Entry<String, Method>>(map.entrySet());
        Collections.sort(this.signatureMethods, sorter);
    }

    private void computeSignature(MethodFilter filter) {
        this.makeSortedMethodList();
        int n2 = this.signatureMethods.size();
        int n3 = n2 + 7 >> 3;
        this.signature = new byte[n3];
        for (int i2 = 0; i2 < n2; ++i2) {
            Method method = this.signatureMethods.get(i2).getValue();
            int n4 = method.getModifiers();
            if (Modifier.isFinal(n4) || Modifier.isStatic(n4) || !ProxyFactory.isVisible(n4, this.basename, method) || filter != null && !filter.isHandled(method)) continue;
            ProxyFactory proxyFactory = this;
            proxyFactory.setBit(proxyFactory.signature, i2);
        }
    }

    private void installSignature(byte[] signature) {
        this.makeSortedMethodList();
        int n2 = this.signatureMethods.size();
        int n3 = n2 + 7 >> 3;
        if (signature.length != n3) {
            throw new RuntimeException("invalid filter signature length for deserialized proxy class");
        }
        this.signature = signature;
    }

    private boolean testBit(byte[] signature, int idx) {
        int n2 = idx >> 3;
        if (n2 > signature.length) {
            return false;
        }
        byte by = signature[n2];
        int n3 = idx & 7;
        int n4 = 1 << n3;
        return (by & n4) != 0;
    }

    private void setBit(byte[] signature, int idx) {
        int n2 = idx >> 3;
        if (n2 < signature.length) {
            int n3 = idx & 7;
            int n4 = 1 << n3;
            byte by = signature[n2];
            signature[n2] = (byte)(by | n4);
        }
    }

    private static void setInterfaces(ClassFile cf, Class<?>[] interfaces, Class<?> proxyClass) {
        String[] stringArray;
        String string = proxyClass.getName();
        if (interfaces == null || interfaces.length == 0) {
            stringArray = new String[]{string};
        } else {
            stringArray = new String[interfaces.length + 1];
            for (int i2 = 0; i2 < interfaces.length; ++i2) {
                stringArray[i2] = interfaces[i2].getName();
            }
            stringArray[interfaces.length] = string;
        }
        cf.setInterfaces(stringArray);
    }

    private static void addClassInitializer(ClassFile cf, ConstPool cp, String classname, int size, List<Find2MethodsArgs> forwarders) throws CannotCompileException {
        FieldInfo fieldInfo = new FieldInfo(cp, HOLDER, HOLDER_TYPE);
        fieldInfo.setAccessFlags(10);
        cf.addField(fieldInfo);
        MethodInfo methodInfo = new MethodInfo(cp, "<clinit>", "()V");
        methodInfo.setAccessFlags(8);
        ProxyFactory.setThrows(methodInfo, cp, new Class[]{ClassNotFoundException.class});
        Bytecode bytecode = new Bytecode(cp, 0, 2);
        bytecode.addIconst(size << 1);
        bytecode.addAnewarray("java.lang.reflect.Method");
        bytecode.addAstore(0);
        bytecode.addLdc(classname);
        bytecode.addInvokestatic("java.lang.Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
        bytecode.addAstore(1);
        for (Find2MethodsArgs find2MethodsArgs : forwarders) {
            ProxyFactory.callFind2Methods(bytecode, find2MethodsArgs.methodName, find2MethodsArgs.delegatorName, find2MethodsArgs.origIndex, find2MethodsArgs.descriptor, 1, 0);
        }
        bytecode.addAload(0);
        bytecode.addPutstatic(classname, HOLDER, HOLDER_TYPE);
        bytecode.addLconst(-1L);
        bytecode.addPutstatic(classname, SERIAL_VERSION_UID_FIELD, SERIAL_VERSION_UID_TYPE);
        bytecode.addOpcode(177);
        methodInfo.setCodeAttribute(bytecode.toCodeAttribute());
        cf.addMethod(methodInfo);
    }

    private static void callFind2Methods(Bytecode code, String superMethod, String thisMethod, int index, String desc, int classVar, int arrayVar) {
        String string = RuntimeSupport.class.getName();
        String string2 = "(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;[Ljava/lang/reflect/Method;)V";
        code.addAload(classVar);
        code.addLdc(superMethod);
        if (thisMethod == null) {
            code.addOpcode(1);
        } else {
            code.addLdc(thisMethod);
        }
        code.addIconst(index);
        code.addLdc(desc);
        code.addAload(arrayVar);
        code.addInvokestatic(string, "find2Methods", string2);
    }

    private static void addSetter(String classname, ClassFile cf, ConstPool cp) throws CannotCompileException {
        MethodInfo methodInfo = new MethodInfo(cp, HANDLER_SETTER, HANDLER_SETTER_TYPE);
        methodInfo.setAccessFlags(1);
        Bytecode bytecode = new Bytecode(cp, 2, 2);
        bytecode.addAload(0);
        bytecode.addAload(1);
        bytecode.addPutfield(classname, HANDLER, HANDLER_TYPE);
        bytecode.addOpcode(177);
        methodInfo.setCodeAttribute(bytecode.toCodeAttribute());
        cf.addMethod(methodInfo);
    }

    private static void addGetter(String classname, ClassFile cf, ConstPool cp) throws CannotCompileException {
        MethodInfo methodInfo = new MethodInfo(cp, HANDLER_GETTER, HANDLER_GETTER_TYPE);
        methodInfo.setAccessFlags(1);
        Bytecode bytecode = new Bytecode(cp, 1, 1);
        bytecode.addAload(0);
        bytecode.addGetfield(classname, HANDLER, HANDLER_TYPE);
        bytecode.addOpcode(176);
        methodInfo.setCodeAttribute(bytecode.toCodeAttribute());
        cf.addMethod(methodInfo);
    }

    private int overrideMethods(ClassFile cf, ConstPool cp, String className, List<Find2MethodsArgs> forwarders) throws CannotCompileException {
        String string = ProxyFactory.makeUniqueName("_d", this.signatureMethods);
        Iterator<Map.Entry<String, Method>> iterator = this.signatureMethods.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            Map.Entry<String, Method> entry = iterator.next();
            if (ClassFile.MAJOR_VERSION < 49 || !ProxyFactory.isBridge(entry.getValue())) {
                ProxyFactory proxyFactory = this;
                if (proxyFactory.testBit(proxyFactory.signature, n2)) {
                    this.override(className, entry.getValue(), string, n2, ProxyFactory.keyToDesc(entry.getKey(), entry.getValue()), cf, cp, forwarders);
                }
            }
            ++n2;
        }
        return n2;
    }

    private static boolean isBridge(Method m2) {
        return m2.isBridge();
    }

    private void override(String thisClassname, Method meth, String prefix, int index, String desc, ClassFile cf, ConstPool cp, List<Find2MethodsArgs> forwarders) throws CannotCompileException {
        MethodInfo methodInfo;
        Class<?> clazz = meth.getDeclaringClass();
        String string = prefix + index + meth.getName();
        if (Modifier.isAbstract(meth.getModifiers())) {
            string = null;
        } else {
            methodInfo = this.makeDelegator(meth, desc, cp, clazz, string);
            methodInfo.setAccessFlags(methodInfo.getAccessFlags() & 0xFFFFFFBF);
            cf.addMethod(methodInfo);
        }
        methodInfo = ProxyFactory.makeForwarder(thisClassname, meth, desc, cp, clazz, string, index, forwarders);
        cf.addMethod(methodInfo);
    }

    private void makeConstructors(String thisClassName, ClassFile cf, ConstPool cp, String classname) throws CannotCompileException {
        Constructor<?>[] constructorArray = SecurityActions.getDeclaredConstructors(this.superClass);
        boolean bl = !this.factoryUseCache;
        for (int i2 = 0; i2 < constructorArray.length; ++i2) {
            Constructor<?> constructor = constructorArray[i2];
            int n2 = constructor.getModifiers();
            if (Modifier.isFinal(n2) || Modifier.isPrivate(n2) || !ProxyFactory.isVisible(n2, this.basename, constructor)) continue;
            MethodInfo methodInfo = ProxyFactory.makeConstructor(thisClassName, constructor, cp, this.superClass, bl);
            cf.addMethod(methodInfo);
        }
    }

    private static String makeUniqueName(String name, List<Map.Entry<String, Method>> sortedMethods) {
        if (ProxyFactory.makeUniqueName0(name, sortedMethods.iterator())) {
            return name;
        }
        for (int i2 = 100; i2 < 999; ++i2) {
            String string = name + i2;
            if (!ProxyFactory.makeUniqueName0(string, sortedMethods.iterator())) continue;
            return string;
        }
        throw new RuntimeException("cannot make a unique method name");
    }

    private static boolean makeUniqueName0(String name, Iterator<Map.Entry<String, Method>> it) {
        while (it.hasNext()) {
            if (!it.next().getKey().startsWith(name)) continue;
            return false;
        }
        return true;
    }

    private static boolean isVisible(int mod, String from, Member meth) {
        if ((mod & 2) != 0) {
            return false;
        }
        if ((mod & 5) != 0) {
            return true;
        }
        String string = ProxyFactory.getPackageName(from);
        String string2 = ProxyFactory.getPackageName(meth.getDeclaringClass().getName());
        if (string == null) {
            return string2 == null;
        }
        return string.equals(string2);
    }

    private static String getPackageName(String name) {
        int n2 = name.lastIndexOf(46);
        if (n2 < 0) {
            return null;
        }
        return name.substring(0, n2);
    }

    private Map<String, Method> getMethods(Class<?> superClass, Class<?>[] interfaceTypes) {
        HashMap<String, Method> hashMap = new HashMap<String, Method>();
        HashSet hashSet = new HashSet();
        for (int i2 = 0; i2 < interfaceTypes.length; ++i2) {
            this.getMethods(hashMap, interfaceTypes[i2], hashSet);
        }
        this.getMethods(hashMap, superClass, hashSet);
        return hashMap;
    }

    private void getMethods(Map<String, Method> hash, Class<?> clazz, Set<Class<?>> visitedClasses) {
        if (!visitedClasses.add(clazz)) {
            return;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            this.getMethods(hash, classArray[i2], visitedClasses);
        }
        Class<?> clazz2 = clazz.getSuperclass();
        if (clazz2 != null) {
            this.getMethods(hash, clazz2, visitedClasses);
        }
        Method[] methodArray = SecurityActions.getDeclaredMethods(clazz);
        for (int i3 = 0; i3 < methodArray.length; ++i3) {
            Method method;
            if (Modifier.isPrivate(methodArray[i3].getModifiers())) continue;
            Method method2 = methodArray[i3];
            String string = method2.getName() + ':' + RuntimeSupport.makeDescriptor(method2);
            if (string.startsWith(HANDLER_GETTER_KEY)) {
                this.hasGetHandler = true;
            }
            if ((method = hash.put(string, method2)) != null && ProxyFactory.isBridge(method2) && !Modifier.isPublic(method.getDeclaringClass().getModifiers()) && !Modifier.isAbstract(method.getModifiers()) && !ProxyFactory.isDuplicated(i3, methodArray)) {
                hash.put(string, method);
            }
            if (method == null || !Modifier.isPublic(method.getModifiers()) || Modifier.isPublic(method2.getModifiers())) continue;
            hash.put(string, method);
        }
    }

    private static boolean isDuplicated(int index, Method[] methods) {
        String string = methods[index].getName();
        for (int i2 = 0; i2 < methods.length; ++i2) {
            if (i2 == index || !string.equals(methods[i2].getName()) || !ProxyFactory.areParametersSame(methods[index], methods[i2])) continue;
            return true;
        }
        return false;
    }

    private static boolean areParametersSame(Method method, Method targetMethod) {
        Class<?>[] classArray;
        Class<?>[] classArray2 = method.getParameterTypes();
        if (classArray2.length == (classArray = targetMethod.getParameterTypes()).length) {
            for (int i2 = 0; i2 < classArray2.length; ++i2) {
                if (classArray2[i2].getName().equals(classArray[i2].getName())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static String keyToDesc(String key, Method m2) {
        String string = key;
        return string.substring(string.indexOf(58) + 1);
    }

    private static MethodInfo makeConstructor(String thisClassName, Constructor<?> cons, ConstPool cp, Class<?> superClass, boolean doHandlerInit) {
        String string = RuntimeSupport.makeDescriptor(cons.getParameterTypes(), Void.TYPE);
        MethodInfo methodInfo = new MethodInfo(cp, "<init>", string);
        methodInfo.setAccessFlags(1);
        ProxyFactory.setThrows(methodInfo, cp, cons.getExceptionTypes());
        Bytecode bytecode = new Bytecode(cp, 0, 0);
        if (doHandlerInit) {
            bytecode.addAload(0);
            bytecode.addGetstatic(thisClassName, DEFAULT_INTERCEPTOR, HANDLER_TYPE);
            bytecode.addPutfield(thisClassName, HANDLER, HANDLER_TYPE);
            bytecode.addGetstatic(thisClassName, DEFAULT_INTERCEPTOR, HANDLER_TYPE);
            bytecode.addOpcode(199);
            bytecode.addIndex(10);
        }
        bytecode.addAload(0);
        bytecode.addGetstatic(NULL_INTERCEPTOR_HOLDER, DEFAULT_INTERCEPTOR, HANDLER_TYPE);
        bytecode.addPutfield(thisClassName, HANDLER, HANDLER_TYPE);
        int n2 = bytecode.currentPc();
        bytecode.addAload(0);
        int n3 = ProxyFactory.addLoadParameters(bytecode, cons.getParameterTypes(), 1);
        bytecode.addInvokespecial(superClass.getName(), "<init>", string);
        bytecode.addOpcode(177);
        bytecode.setMaxLocals(n3 + 1);
        CodeAttribute codeAttribute = bytecode.toCodeAttribute();
        methodInfo.setCodeAttribute(codeAttribute);
        StackMapTable.Writer writer = new StackMapTable.Writer(32);
        writer.sameFrame(n2);
        codeAttribute.setAttribute(writer.toStackMapTable(cp));
        return methodInfo;
    }

    private MethodInfo makeDelegator(Method meth, String desc, ConstPool cp, Class<?> declClass, String delegatorName) {
        MethodInfo methodInfo = new MethodInfo(cp, delegatorName, desc);
        methodInfo.setAccessFlags(0x11 | meth.getModifiers() & 0xFFFFFAD9);
        ProxyFactory.setThrows(methodInfo, cp, meth);
        Bytecode bytecode = new Bytecode(cp, 0, 0);
        bytecode.addAload(0);
        int n2 = ProxyFactory.addLoadParameters(bytecode, meth.getParameterTypes(), 1);
        Class<?> clazz = this.invokespecialTarget(declClass);
        bytecode.addInvokespecial(clazz.isInterface(), cp.addClassInfo(clazz.getName()), meth.getName(), desc);
        ProxyFactory.addReturn(bytecode, meth.getReturnType());
        bytecode.setMaxLocals(++n2);
        methodInfo.setCodeAttribute(bytecode.toCodeAttribute());
        return methodInfo;
    }

    private Class<?> invokespecialTarget(Class<?> declClass) {
        if (declClass.isInterface()) {
            Class<?>[] classArray = this.interfaces;
            int n2 = this.interfaces.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Class<?> clazz = classArray[i2];
                if (!declClass.isAssignableFrom(clazz)) continue;
                return clazz;
            }
        }
        return this.superClass;
    }

    private static MethodInfo makeForwarder(String thisClassName, Method meth, String desc, ConstPool cp, Class<?> declClass, String delegatorName, int index, List<Find2MethodsArgs> forwarders) {
        MethodInfo methodInfo = new MethodInfo(cp, meth.getName(), desc);
        methodInfo.setAccessFlags(0x10 | meth.getModifiers() & 0xFFFFFADF);
        ProxyFactory.setThrows(methodInfo, cp, meth);
        int n2 = Descriptor.paramSize(desc);
        Bytecode bytecode = new Bytecode(cp, 0, n2 + 2);
        int n3 = index << 1;
        int n4 = n3 + 1;
        int n5 = n2 + 1;
        bytecode.addGetstatic(thisClassName, HOLDER, HOLDER_TYPE);
        bytecode.addAstore(n5);
        forwarders.add(new Find2MethodsArgs(meth.getName(), delegatorName, desc, n3));
        bytecode.addAload(0);
        bytecode.addGetfield(thisClassName, HANDLER, HANDLER_TYPE);
        bytecode.addAload(0);
        bytecode.addAload(n5);
        bytecode.addIconst(n3);
        bytecode.addOpcode(50);
        bytecode.addAload(n5);
        bytecode.addIconst(n4);
        bytecode.addOpcode(50);
        ProxyFactory.makeParameterList(bytecode, meth.getParameterTypes());
        bytecode.addInvokeinterface(MethodHandler.class.getName(), "invoke", "(Ljava/lang/Object;Ljava/lang/reflect/Method;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;", 5);
        Class<?> clazz = meth.getReturnType();
        ProxyFactory.addUnwrapper(bytecode, clazz);
        ProxyFactory.addReturn(bytecode, clazz);
        CodeAttribute codeAttribute = bytecode.toCodeAttribute();
        methodInfo.setCodeAttribute(codeAttribute);
        return methodInfo;
    }

    private static void setThrows(MethodInfo minfo, ConstPool cp, Method orig) {
        Class<?>[] classArray = orig.getExceptionTypes();
        ProxyFactory.setThrows(minfo, cp, classArray);
    }

    private static void setThrows(MethodInfo minfo, ConstPool cp, Class<?>[] exceptions) {
        if (exceptions.length == 0) {
            return;
        }
        String[] stringArray = new String[exceptions.length];
        for (int i2 = 0; i2 < exceptions.length; ++i2) {
            stringArray[i2] = exceptions[i2].getName();
        }
        ExceptionsAttribute exceptionsAttribute = new ExceptionsAttribute(cp);
        exceptionsAttribute.setExceptions(stringArray);
        minfo.setExceptionsAttribute(exceptionsAttribute);
    }

    private static int addLoadParameters(Bytecode code, Class<?>[] params, int offset) {
        int n2 = 0;
        int n3 = params.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 += ProxyFactory.addLoad(code, n2 + offset, params[i2]);
        }
        return n2;
    }

    private static int addLoad(Bytecode code, int n2, Class<?> type) {
        if (type.isPrimitive()) {
            if (type == Long.TYPE) {
                code.addLload(n2);
                return 2;
            }
            if (type == Float.TYPE) {
                code.addFload(n2);
            } else {
                if (type == Double.TYPE) {
                    code.addDload(n2);
                    return 2;
                }
                code.addIload(n2);
            }
        } else {
            code.addAload(n2);
        }
        return 1;
    }

    private static int addReturn(Bytecode code, Class<?> type) {
        if (type.isPrimitive()) {
            if (type == Long.TYPE) {
                code.addOpcode(173);
                return 2;
            }
            if (type == Float.TYPE) {
                code.addOpcode(174);
            } else {
                if (type == Double.TYPE) {
                    code.addOpcode(175);
                    return 2;
                }
                if (type == Void.TYPE) {
                    code.addOpcode(177);
                    return 0;
                }
                code.addOpcode(172);
            }
        } else {
            code.addOpcode(176);
        }
        return 1;
    }

    private static void makeParameterList(Bytecode code, Class<?>[] params) {
        int n2 = 1;
        int n3 = params.length;
        code.addIconst(n3);
        code.addAnewarray("java/lang/Object");
        for (int i2 = 0; i2 < n3; ++i2) {
            code.addOpcode(89);
            code.addIconst(i2);
            Class<?> clazz = params[i2];
            if (clazz.isPrimitive()) {
                n2 = ProxyFactory.makeWrapper(code, clazz, n2);
            } else {
                code.addAload(n2);
                ++n2;
            }
            code.addOpcode(83);
        }
    }

    private static int makeWrapper(Bytecode code, Class<?> type, int regno) {
        int n2 = FactoryHelper.typeIndex(type);
        String string = FactoryHelper.wrapperTypes[n2];
        code.addNew(string);
        code.addOpcode(89);
        ProxyFactory.addLoad(code, regno, type);
        code.addInvokespecial(string, "<init>", FactoryHelper.wrapperDesc[n2]);
        return regno + FactoryHelper.dataSize[n2];
    }

    private static void addUnwrapper(Bytecode code, Class<?> type) {
        if (type.isPrimitive()) {
            if (type == Void.TYPE) {
                code.addOpcode(87);
                return;
            }
            int n2 = FactoryHelper.typeIndex(type);
            String string = FactoryHelper.wrapperTypes[n2];
            code.addCheckcast(string);
            code.addInvokevirtual(string, FactoryHelper.unwarpMethods[n2], FactoryHelper.unwrapDesc[n2]);
            return;
        }
        code.addCheckcast(type.getName());
    }

    private static MethodInfo makeWriteReplace(ConstPool cp) {
        MethodInfo methodInfo = new MethodInfo(cp, "writeReplace", "()Ljava/lang/Object;");
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = "java.io.ObjectStreamException";
        ExceptionsAttribute exceptionsAttribute = new ExceptionsAttribute(cp);
        exceptionsAttribute.setExceptions(stringArray2);
        methodInfo.setExceptionsAttribute(exceptionsAttribute);
        Bytecode bytecode = new Bytecode(cp, 0, 1);
        bytecode.addAload(0);
        bytecode.addInvokestatic(NULL_INTERCEPTOR_HOLDER, "makeSerializedProxy", "(Ljava/lang/Object;)Ljavassist/util/proxy/SerializedProxy;");
        bytecode.addOpcode(176);
        methodInfo.setCodeAttribute(bytecode.toCodeAttribute());
        return methodInfo;
    }

    static class Find2MethodsArgs {
        String methodName;
        String delegatorName;
        String descriptor;
        int origIndex;

        Find2MethodsArgs(String mname, String dname, String desc, int index) {
            this.methodName = mname;
            this.delegatorName = dname;
            this.descriptor = desc;
            this.origIndex = index;
        }
    }

    public static interface UniqueName {
        public String get(String var1);
    }

    public static interface ClassLoaderProvider {
        public ClassLoader get(ProxyFactory var1);
    }

    static class ProxyDetails {
        byte[] signature;
        Reference<Class<?>> proxyClass;
        boolean isUseWriteReplace;

        ProxyDetails(byte[] signature, Class<?> proxyClass, boolean isUseWriteReplace) {
            this.signature = signature;
            this.proxyClass = new WeakReference(proxyClass);
            this.isUseWriteReplace = isUseWriteReplace;
        }
    }
}

