/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.util.proxy;

import ai.h2o.javassist.util.proxy.MethodHandler;
import ai.h2o.javassist.util.proxy.Proxy;
import ai.h2o.javassist.util.proxy.ProxyFactory;
import ai.h2o.javassist.util.proxy.ProxyObject;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

class SerializedProxy
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String superClass;
    private String[] interfaces;
    private byte[] filterSignature;
    private MethodHandler handler;

    SerializedProxy(Class<?> proxy, byte[] sig, MethodHandler h2) {
        this.filterSignature = sig;
        this.handler = h2;
        this.superClass = proxy.getSuperclass().getName();
        Class<?>[] classArray = proxy.getInterfaces();
        int n2 = classArray.length;
        this.interfaces = new String[n2 - 1];
        String string = ProxyObject.class.getName();
        String string2 = Proxy.class.getName();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string3 = classArray[i2].getName();
            if (string3.equals(string) || string3.equals(string2)) continue;
            this.interfaces[i2] = string3;
        }
    }

    protected Class<?> loadClass(final String className) throws ClassNotFoundException {
        try {
            return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                @Override
                public Class<?> run() throws Exception {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    return Class.forName(className, true, classLoader);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new RuntimeException("cannot load the class: " + className, privilegedActionException.getException());
        }
    }

    Object readResolve() throws ObjectStreamException {
        try {
            int n2 = this.interfaces.length;
            Class[] classArray = new Class[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                SerializedProxy serializedProxy = this;
                classArray[i2] = serializedProxy.loadClass(serializedProxy.interfaces[i2]);
            }
            ProxyFactory proxyFactory = new ProxyFactory();
            SerializedProxy serializedProxy = this;
            proxyFactory.setSuperclass(serializedProxy.loadClass(serializedProxy.superClass));
            proxyFactory.setInterfaces(classArray);
            Proxy proxy = (Proxy)proxyFactory.createClass(this.filterSignature).getConstructor(new Class[0]).newInstance(new Object[0]);
            proxy.setHandler(this.handler);
            return proxy;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InvalidClassException(noSuchMethodException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new InvalidClassException(invocationTargetException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidClassException(classNotFoundException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            throw new InvalidObjectException(instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InvalidClassException(illegalAccessException.getMessage());
        }
    }
}

