/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime;

import ai.h2o.mojos.runtime.MojoPipeline;
import ai.h2o.mojos.runtime.api.MojoColumnMeta;
import ai.h2o.mojos.runtime.api.PipelineConfig;
import ai.h2o.mojos.runtime.api.PipelineLoader;
import ai.h2o.mojos.runtime.api.backend.ReaderBackend;
import ai.h2o.mojos.runtime.frame.MojoFrameMeta;
import ai.h2o.mojos.runtime.lic.LicenseException;
import ai.h2o.mojos.runtime.lic.a;
import ai.h2o.mojos.runtime.transforms.MojoTransform;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPipelineLoader
implements PipelineLoader {
    private static final Logger log = LoggerFactory.getLogger(AbstractPipelineLoader.class);
    protected final ReaderBackend backend;
    protected final PipelineConfig config;

    public AbstractPipelineLoader(ReaderBackend backend, PipelineConfig config) {
        assert (backend != null);
        this.backend = backend;
        this.config = config;
    }

    @Override
    public final MojoPipeline load() throws IOException, LicenseException {
        a.a(this.backend);
        return this.internalLoad();
    }

    protected abstract MojoPipeline internalLoad() throws IOException, LicenseException;

    public static <T extends MojoTransform> List<T> removeDeadTransforms(List<T> transformations, Collection<Integer> outputs) {
        LinkedHashSet<Integer> linkedHashSet = new LinkedHashSet<Integer>(outputs);
        int n2 = transformations.size();
        LinkedList<MojoTransform> linkedList = new LinkedList<MojoTransform>();
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            int n3;
            int n4;
            MojoTransform mojoTransform = (MojoTransform)transformations.get(i2);
            boolean bl = true;
            int[] nArray = mojoTransform.oindices;
            int n5 = mojoTransform.oindices.length;
            for (n4 = 0; n4 < n5; ++n4) {
                n3 = nArray[n4];
                if (linkedHashSet.contains(n3)) {
                    bl = false;
                    continue;
                }
                linkedHashSet.add(n3);
            }
            if (!bl) {
                nArray = mojoTransform.iindices;
                n5 = mojoTransform.iindices.length;
                for (n4 = 0; n4 < n5; ++n4) {
                    n3 = nArray[n4];
                    linkedHashSet.add(n3);
                }
                linkedList.addFirst(mojoTransform);
                continue;
            }
            log.trace("Unused transform {}:{}, group: {}", mojoTransform.getId(), mojoTransform.getName(), mojoTransform.getTransformationGroup());
        }
        if (transformations.size() != linkedList.size()) {
            log.warn("Skipping {} unused transforms of {} total; see details above on TRACE log", (Object)(transformations.size() - linkedList.size()), (Object)transformations.size());
        }
        return linkedList;
    }

    @Override
    public List<MojoColumnMeta> getColumns() {
        return Collections.emptyList();
    }

    @Override
    public MojoFrameMeta getInput() {
        return MojoFrameMeta.getEmpty();
    }

    @Override
    public MojoFrameMeta getOutput() {
        return MojoFrameMeta.getEmpty();
    }
}

