/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime;

import ai.h2o.mojos.runtime.api.MojoColumnMeta;
import ai.h2o.mojos.runtime.frame.MojoColumn;
import ai.h2o.mojos.runtime.transforms.MojoTransform;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class ColumnOptimizer {
    private int slotCount;
    private final Map<MojoColumn.Type, Stack<Integer>> pools = new LinkedHashMap<MojoColumn.Type, Stack<Integer>>();
    private final List<MojoColumnMeta> columns;
    private final int[] slots;

    public ColumnOptimizer(List<MojoColumnMeta> columns, int[] inputIndices, int[] outputIndices, int[] othersToLock) {
        int n2;
        int n3;
        this.columns = columns;
        this.slots = new int[columns.size()];
        Arrays.fill(this.slots, -1);
        int[] nArray = outputIndices;
        int n4 = outputIndices.length;
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = nArray[n3];
            this.slots[n2] = this.lock(n2);
        }
        nArray = inputIndices;
        n4 = inputIndices.length;
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = nArray[n3];
            this.slots[n2] = this.lock(n2);
        }
        if (othersToLock != null) {
            nArray = othersToLock;
            n4 = othersToLock.length;
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = nArray[n3];
                this.slots[n2] = this.lock(n2);
            }
        }
    }

    private Stack<Integer> getPool(int index) {
        MojoColumnMeta mojoColumnMeta = this.columns.get(index);
        return this.pools.computeIfAbsent(mojoColumnMeta.getColumnType(), k2 -> new Stack());
    }

    private int generateSlot() {
        int n2 = this.slotCount++;
        return n2;
    }

    private int lock(int index) {
        Stack<Integer> stack = this.getPool(index);
        Integer n2 = !stack.isEmpty() ? stack.pop() : Integer.valueOf(this.generateSlot());
        return n2;
    }

    private void unlock(int index, int slot) {
        Stack<Integer> stack = this.getPool(index);
        stack.push(slot);
    }

    public static ColumnOptimizer optimize(List<? extends MojoTransform> transforms, int[] inputIndices, int[] outputIndices, List<MojoColumnMeta> columns) {
        return ColumnOptimizer.optimize(transforms, inputIndices, outputIndices, new int[0], columns);
    }

    public static ColumnOptimizer optimize(List<? extends MojoTransform> transforms, int[] inputIndices, int[] outputIndices, int[] others, List<MojoColumnMeta> columns) {
        ColumnOptimizer columnOptimizer = new ColumnOptimizer(columns, inputIndices, outputIndices, others);
        for (int i2 = transforms.size() - 1; i2 >= 0; --i2) {
            MojoTransform mojoTransform = transforms.get(i2);
            columnOptimizer.process(mojoTransform);
        }
        return columnOptimizer;
    }

    public static ColumnOptimizer dummy(List<MojoColumnMeta> columns) {
        ColumnOptimizer columnOptimizer = new ColumnOptimizer(columns, new int[0], new int[0], new int[0]);
        new ColumnOptimizer(columns, new int[0], new int[0], new int[0]).slotCount = columns.size();
        int n2 = 0;
        while (n2 < columnOptimizer.slots.length) {
            int n3 = n2++;
            columnOptimizer.slots[n3] = n3;
        }
        return columnOptimizer;
    }

    private void process(MojoTransform transform) {
        int n2;
        int n3;
        boolean bl = true;
        int[] nArray = transform.oindices;
        int n4 = transform.oindices.length;
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = nArray[n3];
            if (this.slots[n2] < 0) {
                this.slots[n2] = this.lock(n2);
                continue;
            }
            bl = false;
        }
        if (!bl) {
            nArray = transform.iindices;
            n4 = transform.iindices.length;
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = nArray[n3];
                if (this.slots[n2] >= 0) continue;
                this.slots[n2] = this.lock(n2);
            }
        }
        nArray = transform.oindices;
        n4 = transform.oindices.length;
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = nArray[n3];
            int n5 = this.slots[n2];
            if (n5 < 0) continue;
            this.unlock(n2, n5);
        }
    }

    public int[] getSlots() {
        return this.slots;
    }

    public int getSlotCount() {
        return this.slotCount;
    }

    public void graphPrintOptimized(List<MojoTransform> transforms) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        for (MojoTransform object2 : transforms) {
            stringBuilder.append(String.format("%30s: ", object2.getName()));
            ArrayList<String> arrayList = new ArrayList<String>();
            this.cellsRenderSlots(arrayList, object2.iindices, true);
            this.cellsRenderSlots(arrayList, object2.oindices, false);
            for (String string : arrayList) {
                stringBuilder.append(String.format("%4s", string));
            }
            stringBuilder.append("\n");
        }
        try {
            object = new FileOutputStream("/tmp/x.txt");
            PrintWriter printWriter = new PrintWriter((OutputStream)object);
            printWriter.println(stringBuilder);
            printWriter.close();
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            object = fileNotFoundException;
            fileNotFoundException.printStackTrace();
            return;
        }
    }

    private void cellsRenderSlots(List<String> cells, int[] indices, boolean isInput) {
        int[] nArray = indices;
        int n2 = indices.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = nArray[i2];
            int n4 = this.slots[n3];
            while (n4 >= cells.size()) {
                cells.add("");
            }
            String string = isInput ? "\u21d3" : "\u21d1";
            cells.set(n4, String.format("%s%s", n3, string));
        }
    }
}

